/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypeVisitor;

public class ListType
extends BaseType {
    public final Type elementType;

    ListType(Type elementType) {
        super(Op.LIST);
        this.elementType = Objects.requireNonNull(elementType);
    }

    @Override
    public Type.Key key() {
        return Keys.list(this.elementType.key());
    }

    @Override
    public Type arg(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.elementType;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public ListType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        Type elementType2 = this.elementType.copy(typeSystem, transform);
        return elementType2 == this.elementType ? this : typeSystem.listType(elementType2);
    }

    @Override
    public boolean specializes(Type type) {
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            return this.elementType.specializes(listType.elementType);
        }
        return type instanceof TypeVar;
    }
}

