/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypeVisitor;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;

public class RecordType
extends BaseType
implements RecordLikeType {
    public final SortedMap<String, Type> argNameTypes;
    public static final Ordering<String> ORDERING = Ordering.from(RecordType::compareNames);

    RecordType(SortedMap<String, Type> argNameTypes) {
        super(Op.RECORD_TYPE);
        this.argNameTypes = ImmutableSortedMap.copyOfSorted(argNameTypes);
        Preconditions.checkArgument((argNameTypes.comparator() == ORDERING ? 1 : 0) != 0);
    }

    @Override
    public SortedMap<String, Type> argNameTypes() {
        return this.argNameTypes;
    }

    @Override
    public Type argType(int i) {
        return (Type)ImmutableList.copyOf(this.argNameTypes.values()).get(i);
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public Type.Key key() {
        return Keys.record(Keys.toKeys(this.argNameTypes));
    }

    @Override
    public RecordType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        int differenceCount = 0;
        PairList<String, Type> argNameTypes2 = PairList.of();
        for (Map.Entry<String, Type> entry : this.argNameTypes.entrySet()) {
            Type type2;
            Type type = entry.getValue();
            if (type != (type2 = type.copy(typeSystem, transform))) {
                ++differenceCount;
            }
            argNameTypes2.add(entry.getKey(), type2);
        }
        return differenceCount == 0 ? this : (RecordType)typeSystem.recordType(argNameTypes2);
    }

    @Override
    public boolean specializes(Type type) {
        return type instanceof RecordType && this.argNameTypes.size() == ((RecordType)type).argNameTypes.size() && this.argNameTypes.keySet().equals(((RecordType)type).argNameTypes.keySet()) && Pair.allMatch(this.argNameTypes.values(), ((RecordType)type).argNameTypes.values(), Type::specializes) || type instanceof TypeVar;
    }

    public static <V> SortedMap<String, V> map(String name, V v0, Object ... entries) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy(ORDERING);
        builder.put((Object)name, v0);
        for (int i = 0; i < entries.length / 2; i += 2) {
            builder.put((Object)((String)entries[i]), entries[i + 1]);
        }
        return builder.build();
    }

    public static <V> NavigableMap<String, V> mutableMap() {
        return new TreeMap((Comparator<String>)ORDERING);
    }

    public static int compareNames(String o1, String o2) {
        int i2;
        int i1 = RecordType.parseInt(o1);
        int c = Integer.compare(i1, i2 = RecordType.parseInt(o2));
        if (c != 0) {
            return c;
        }
        return o1.compareTo(o2);
    }

    private static int parseInt(String s) {
        int length = s.length();
        if (length > 9) {
            return Integer.MAX_VALUE;
        }
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                return Integer.MAX_VALUE;
            }
            int digit = c - 48;
            n = n * 10 + digit;
        }
        return n;
    }
}

