/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.List;
import java.util.SortedMap;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypeVisitor;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;

public class TupleType
extends BaseType
implements RecordLikeType {
    private static final IntStringCache INT_STRING_CACHE = new IntStringCache();
    public final List<Type> argTypes;

    TupleType(List<? extends Type> argTypes) {
        super(Op.TUPLE_TYPE);
        this.argTypes = ImmutableList.copyOf(argTypes);
    }

    @Override
    public SortedMap<String, Type> argNameTypes() {
        ImmutableSortedMap.Builder map = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        Pair.forEach(this.argNames(), this.argTypes, (arg_0, arg_1) -> ((ImmutableSortedMap.Builder)map).put(arg_0, arg_1));
        return map.build();
    }

    @Override
    public List<String> argNames() {
        return TupleType.ordinalNames(this.argTypes.size());
    }

    @Override
    public List<Type> argTypes() {
        return this.argTypes;
    }

    @Override
    public Type argType(int i) {
        return this.argTypes.get(i);
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public Type.Key key() {
        return Keys.record(TupleType.recordMap(Static.transform(this.argTypes, Type::key)));
    }

    @Override
    public TupleType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        int differenceCount = 0;
        ImmutableList.Builder argTypes2 = ImmutableList.builder();
        for (Type argType : this.argTypes) {
            Type argType2;
            if (argType != (argType2 = (Type)transform.apply(argType))) {
                ++differenceCount;
            }
            argTypes2.add((Object)argType2);
        }
        return differenceCount == 0 ? this : new TupleType((List<? extends Type>)argTypes2.build());
    }

    @Override
    public boolean specializes(Type type) {
        return type instanceof TupleType && this.argTypes.size() == ((TupleType)type).argTypes.size() && Pair.allMatch(this.argTypes, ((TupleType)type).argTypes, Type::specializes) || type instanceof TypeVar;
    }

    public static List<String> ordinalNames(int size) {
        return INT_STRING_CACHE.subList(1, size + 1);
    }

    static <E> ImmutableSortedMap<String, E> recordMap(List<? extends E> argTypes) {
        ImmutableSortedMap.Builder b = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        Pair.forEach(TupleType.ordinalNames(argTypes.size()), argTypes, (arg_0, arg_1) -> ((ImmutableSortedMap.Builder)b).put(arg_0, arg_1));
        return b.build();
    }

    private static class IntStringCache {
        volatile ImmutableList<String> list = ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9", (Object)"10", (Object)"11", (Object[])new String[]{"12", "13", "14", "15"});

        private IntStringCache() {
        }

        ImmutableList<String> ensure(int minimumSize) {
            ImmutableList newList = this.list;
            while (newList.size() < minimumSize) {
                int minimumSize2 = Math.max(newList.size() + 8, minimumSize);
                int newSize = Integer.highestOneBit(minimumSize2 * 2 - 1);
                assert (newSize > newList.size()) : String.format("newSize = %d, newList.size() = %d, minimumSize2 = %d", newSize, newList.size(), minimumSize2);
                ImmutableList.Builder b = ImmutableList.builderWithExpectedSize((int)newSize);
                b.addAll(newList);
                for (int i = newList.size(); i < newSize; ++i) {
                    b.add((Object)Integer.toString(i));
                }
                newList = this.list = b.build();
            }
            return newList;
        }

        List<String> subList(int start, int end) {
            return this.ensure(end).subList(start, end);
        }
    }
}

