/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.TypeShuttle;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeUnifier;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypeVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Type {
    public Key key();

    default public String moniker() {
        return this.key().toString();
    }

    public Op op();

    default public Type arg(int i) {
        throw new UnsupportedOperationException();
    }

    public Type copy(TypeSystem var1, UnaryOperator<Type> var2);

    public <R> R accept(TypeVisitor<R> var1);

    default public Type substitute(TypeSystem typeSystem, final List<? extends Type> types) {
        if (types.isEmpty()) {
            return this;
        }
        return this.accept(new TypeShuttle(typeSystem){

            @Override
            public Type visit(TypeVar typeVar) {
                return (Type)types.get(typeVar.ordinal);
            }
        });
    }

    default public boolean isProgressive() {
        return false;
    }

    default public boolean isFinite() {
        return false;
    }

    default public boolean isCollection() {
        return false;
    }

    default public boolean canCallArgOf(Type type) {
        return false;
    }

    default public boolean specializes(Type type) {
        return false;
    }

    default public @Nullable Map<Integer, Type> unifyWith(Type type) {
        return TypeUnifier.unify(this, type);
    }

    public static abstract class Key {
        public final Op op;

        protected Key(Op op) {
            this.op = Objects.requireNonNull(op);
        }

        public String toString() {
            return this.describe(new StringBuilder(), 0, 0).toString();
        }

        abstract StringBuilder describe(StringBuilder var1, int var2, int var3);

        public abstract Type toType(TypeSystem var1);

        Key substitute(List<? extends Type> types) {
            return this;
        }

        Key copy(UnaryOperator<Key> transform) {
            return this;
        }
    }
}

