/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.NameGenerator;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.DummyType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.MultiType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.ProgressiveRecordType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeShuttle;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypeVisitor;
import net.hydromatic.morel.util.ComparableSingletonList;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;

public class TypeSystem {
    final Map<String, Type> typeByName = new HashMap<String, Type>();
    final Map<BuiltIn.BuiltInType, Type> builtInTypes = new HashMap<BuiltIn.BuiltInType, Type>();
    final Map<Type.Key, Type> typeByKey = new HashMap<Type.Key, Type>();
    private final Map<String, Pair<DataType, Type.Key>> typeConstructorByName = new HashMap<String, Pair<DataType, Type.Key>>();
    public final NameGenerator nameGenerator = new NameGenerator();
    public final AtomicInteger expandCount = new AtomicInteger();

    public TypeSystem() {
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            this.typeByName.put(primitiveType.moniker, primitiveType);
        }
    }

    public Binding bindTyCon(DataType dataType, String tyConName) {
        Type type = dataType.typeConstructors(this).get(tyConName);
        if (type == DummyType.INSTANCE) {
            return Binding.of((Core.NamedPat)CoreBuilder.core.idPat((Type)dataType, tyConName, 0), Codes.constant(ComparableSingletonList.of(tyConName)));
        }
        Type type2 = this.wrap(dataType, this.fnType(type, dataType));
        return Binding.of((Core.NamedPat)CoreBuilder.core.idPat(type2, tyConName, 0), Codes.tyCon(dataType, tyConName));
    }

    private Type wrap(DataType dataType, Type type) {
        List typeVars = (List)dataType.parameterTypes.stream().filter(t -> t instanceof TypeVar).map(t -> (TypeVar)t).collect(ImmutableList.toImmutableList());
        return typeVars.isEmpty() ? type : this.forallType(typeVars.size(), type);
    }

    public Type lookup(BuiltIn.BuiltInType builtInType) {
        Type type = this.builtInTypes.get(builtInType);
        if (type == null) {
            throw new AssertionError((Object)("unknown type: " + builtInType));
        }
        return type;
    }

    public Type lookup(String name) {
        Type type = this.typeByName.get(name);
        if (type == null) {
            throw new AssertionError((Object)("unknown type: " + name));
        }
        return type;
    }

    public Type lookupOpt(String name) {
        return this.typeByName.get(name);
    }

    public Type typeFor(Type.Key key) {
        Type type = this.typeByKey.get(key);
        if (type == null) {
            type = key.toType(this);
            this.typeByKey.putIfAbsent(key, type);
        }
        return type;
    }

    public List<Type> typesFor(Iterable<? extends Type.Key> keys) {
        return Static.transformEager(keys, key -> key.toType(this));
    }

    public SortedMap<String, Type> typesFor(Map<String, ? extends Type.Key> keys) {
        ImmutableSortedMap.Builder types = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        keys.forEach((name, key) -> types.put(name, (Object)this.typeFor((Type.Key)key)));
        return types.build();
    }

    public Type fnType(Type paramType, Type type1, Type type2, Type ... moreTypes) {
        ImmutableList types = ImmutableList.builder().add((Object)paramType).add((Object)type1).add((Object)type2).add((Object[])moreTypes).build();
        Type t = null;
        for (Type type : Lists.reverse((List)types)) {
            if (t == null) {
                t = type;
                continue;
            }
            t = this.fnType(type, t);
        }
        return Objects.requireNonNull(t);
    }

    public FnType fnType(Type paramType, Type resultType) {
        return (FnType)this.typeFor(Keys.fn(paramType.key(), resultType.key()));
    }

    public TupleType tupleType(Type argType0, Type ... argTypes) {
        return (TupleType)this.tupleType(Lists.asList((Object)argType0, (Object[])argTypes));
    }

    public RecordLikeType tupleType(List<? extends Type> argTypes) {
        return (RecordLikeType)this.typeFor(Keys.tuple(Keys.toKeys(argTypes)));
    }

    public Type bagType(Type elementType) {
        return this.typeFor(Keys.apply(Keys.name(BuiltIn.Eqtype.BAG.mlName()), (Iterable<? extends Type.Key>)ImmutableList.of((Object)elementType.key())));
    }

    public ListType listType(Type elementType) {
        return (ListType)this.typeFor(Keys.list(elementType.key()));
    }

    public List<Type> dataTypes(List<Keys.DataTypeKey> keys) {
        LinkedHashMap dataTypeMap = new LinkedHashMap();
        keys.forEach(key -> {
            DataType dataType = key.toType(this);
            Type.Key nameKey = Keys.name(dataType.name);
            this.typeByKey.put(nameKey, dataType);
            dataType.typeConstructors.forEach((name, typeKey) -> this.typeConstructorByName.put((String)name, Pair.of(dataType, typeKey)));
            dataTypeMap.put(nameKey, dataType);
        });
        ImmutableList.Builder types = ImmutableList.builder();
        dataTypeMap.values().forEach(dataType -> {
            DataType t = dataType.arguments.isEmpty() ? dataType : this.forallType(dataType.arguments.size(), (Type)dataType);
            this.typeByName.put(dataType.name, t);
            types.add((Object)t);
        });
        return types.build();
    }

    DataType dataType(String name, ImmutableList<Type> argumentTypes, ImmutableMap<String, Type.Key> tyCons) {
        String moniker = DataType.computeMoniker(name, argumentTypes);
        DataType dataType = new DataType(name, moniker, argumentTypes, tyCons);
        if (argumentTypes.isEmpty()) {
            tyCons.forEach((name3, typeKey) -> this.typeConstructorByName.put((String)name3, Pair.of(dataType, typeKey)));
        }
        return dataType;
    }

    public void setBuiltIn(BuiltIn.BuiltInType datatype) {
        Type type = datatype.isInternal() ? this.typeByName.remove(datatype.mlName()) : this.typeByName.get(datatype.mlName());
        Objects.requireNonNull(type, datatype.mlName());
        this.builtInTypes.put(datatype, type);
    }

    public Type dataTypeScheme(String name, List<TypeVar> parameters, Map<String, Type.Key> tyCons) {
        List<Type.Key> keys = Keys.toKeys(parameters);
        Keys.DataTypeKey key = Keys.datatype(name, keys, tyCons);
        return this.dataTypes((List<Keys.DataTypeKey>)ImmutableList.of((Object)key)).get(0);
    }

    public Type recordOrScalarType(Collection<Map.Entry<String, Type>> argNameTypes) {
        switch (argNameTypes.size()) {
            case 1: {
                return (Type)((Map.Entry)Iterables.getOnlyElement(argNameTypes)).getValue();
            }
        }
        return this.recordType(argNameTypes);
    }

    public RecordLikeType recordType(Collection<Map.Entry<String, Type>> argNameTypes) {
        return this.recordType((SortedMap<String, ? extends Type>)ImmutableSortedMap.copyOf(argNameTypes, RecordType.ORDERING));
    }

    public RecordLikeType recordType(SortedMap<String, ? extends Type> argNameTypes) {
        ImmutableSortedMap argNameTypes2 = ImmutableSortedMap.copyOf(argNameTypes, RecordType.ORDERING);
        if (argNameTypes2.isEmpty()) {
            return PrimitiveType.UNIT;
        }
        if (TypeSystem.areContiguousIntegers((Iterable<String>)argNameTypes2.keySet()) && argNameTypes2.size() != 1) {
            return this.tupleType((List<? extends Type>)ImmutableList.copyOf((Collection)argNameTypes2.values()));
        }
        return (RecordLikeType)this.typeFor(Keys.record(Keys.toKeys((SortedMap<String, ? extends Type>)argNameTypes2)));
    }

    public static boolean areContiguousIntegers(Iterable<String> strings) {
        int i = 1;
        for (String string : strings) {
            if (string.equals(Integer.toString(i++))) continue;
            return false;
        }
        return true;
    }

    public ProgressiveRecordType progressiveRecordType(Collection<Map.Entry<String, Type>> argNameTypes) {
        return this.progressiveRecordType((SortedMap<String, Type>)ImmutableSortedMap.copyOf(argNameTypes, RecordType.ORDERING));
    }

    public ProgressiveRecordType progressiveRecordType(SortedMap<String, Type> argNameTypes) {
        ImmutableSortedMap argNameTypes2 = ImmutableSortedMap.copyOf(argNameTypes, RecordType.ORDERING);
        Type.Key key = Keys.progressiveRecord(Keys.toKeys((SortedMap<String, ? extends Type>)argNameTypes2));
        return (ProgressiveRecordType)this.typeFor(key);
    }

    public Type forallType(int typeCount, Function<ForallHelper, Type> builder) {
        ForallHelper helper = new ForallHelper(){

            @Override
            public TypeVar get(int i) {
                return TypeSystem.this.typeVariable(i);
            }

            @Override
            public ListType list(int i) {
                return TypeSystem.this.listType(this.get(i));
            }

            @Override
            public Type bag(int i) {
                return TypeSystem.this.bagType(this.get(i));
            }

            @Override
            public Type vector(int i) {
                return TypeSystem.this.vector(this.get(i));
            }

            @Override
            public Type option(int i) {
                return TypeSystem.this.option(this.get(i));
            }

            @Override
            public FnType predicate(int i) {
                return TypeSystem.this.fnType(this.get(i), PrimitiveType.BOOL);
            }
        };
        Type type = builder.apply(helper);
        return this.forallType(typeCount, type);
    }

    public ForallType forallType(int typeCount, Type type) {
        Type.Key key = Keys.forall(type, typeCount);
        return (ForallType)this.typeFor(key);
    }

    public MultiType multi(Type ... types) {
        return this.multi((List<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public MultiType multi(List<? extends Type> types) {
        return new MultiType((Iterable<? extends Type>)ImmutableList.copyOf(types));
    }

    static StringBuilder unparseList(StringBuilder builder, Op op, int left, int right, Collection<? extends Type.Key> argTypes) {
        if (op == Op.COMMA && argTypes.size() != 1 && (left != 0 || right != 0)) {
            builder.append('(');
            TypeSystem.unparseList(builder, op, 0, 0, argTypes);
            builder.append(')');
        } else {
            Ord.forEachIndexed(argTypes, (type, i) -> {
                if (i > 0) {
                    builder.append(op.padded);
                }
                TypeSystem.unparse(builder, type, i == 0 ? left : op.right, i == argTypes.size() - 1 ? right : op.left);
            });
        }
        return builder;
    }

    static StringBuilder unparse(StringBuilder builder, Type.Key type, int left, int right) {
        if (left > type.op.left || type.op.right < right) {
            builder.append("(");
            TypeSystem.unparse(builder, type, 0, 0);
            return builder.append(")");
        }
        return type.describe(builder, left, right);
    }

    public List<TypeVar> typeVariables(final int size) {
        return new AbstractList<TypeVar>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public TypeVar get(int index) {
                return TypeSystem.this.typeVariable(index);
            }
        };
    }

    public Type unqualified(Type type) {
        Type type0 = type;
        while (type instanceof ForallType) {
            type = ((ForallType)type).type;
        }
        if (type == type0) {
            return type0;
        }
        return type.accept(new TypeShuttle(this){
            final Map<Integer, TypeVar> map;
            {
                this.map = new HashMap<Integer, TypeVar>();
            }

            @Override
            public Type visit(TypeVar typeVar) {
                return this.map.computeIfAbsent(typeVar.ordinal, i -> TypeSystem.this.typeVariable(this.map.size()));
            }
        });
    }

    public Pair<DataType, Type.Key> lookupTyCon(String tyConName) {
        return this.typeConstructorByName.get(tyConName);
    }

    public Type apply(Type type, Type ... types) {
        return this.apply(type, (List<Type>)ImmutableList.copyOf((Object[])types));
    }

    public Type apply(Type type, List<Type> types) {
        if (type instanceof ForallType) {
            ForallType forallType = (ForallType)type;
            return forallType.substitute(this, types);
        }
        if (type instanceof DataType) {
            DataType dataType = (DataType)type;
            return dataType.substitute(this, types);
        }
        throw new AssertionError();
    }

    public TypeVar typeVariable(int ordinal) {
        return (TypeVar)this.typeFor(Keys.ordinal(ordinal));
    }

    public Type descending() {
        return this.lookup(BuiltIn.Datatype.DESCENDING);
    }

    public Type order() {
        return this.lookup(BuiltIn.Datatype.ORDER);
    }

    public Type bag(Type type) {
        Type bagType = this.lookup(BuiltIn.Eqtype.BAG);
        return this.apply(bagType, type);
    }

    public Type option(Type type) {
        Type optionType = this.lookup(BuiltIn.Datatype.OPTION);
        return this.apply(optionType, type);
    }

    public Type vector(Type type) {
        Type vectorType = this.lookup(BuiltIn.Eqtype.VECTOR);
        return this.apply(vectorType, type);
    }

    public Type ensureClosed(Type type) {
        VariableCollector collector = new VariableCollector();
        type.accept(collector);
        if (collector.vars.isEmpty()) {
            return type;
        }
        ArrayList<TypeVar> types = new ArrayList<TypeVar>();
        int i = 0;
        for (TypeVar var : collector.vars) {
            while (var.ordinal >= types.size()) {
                types.add(null);
            }
            types.set(var.ordinal, this.typeVariable(i++));
        }
        TypeSystem ts = this;
        return this.forallType(collector.vars.size(), (ForallHelper h) -> type.substitute(ts, types));
    }

    private static class VariableCollector
    extends TypeVisitor<Void> {
        final Set<TypeVar> vars = new LinkedHashSet<TypeVar>();

        private VariableCollector() {
        }

        @Override
        public Void visit(DataType dataType) {
            dataType.arguments.forEach(t -> t.accept(this));
            return null;
        }

        @Override
        public Void visit(TypeVar typeVar) {
            this.vars.add(typeVar);
            return (Void)super.visit(typeVar);
        }
    }

    public static interface ForallHelper {
        public TypeVar get(int var1);

        public Type bag(int var1);

        public ListType list(int var1);

        public Type vector(int var1);

        public Type option(int var1);

        public FnType predicate(int var1);
    }
}

