/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeUnifier {
    private Map<Integer, Type> variables = new HashMap<Integer, Type>();

    public static @Nullable Map<Integer, Type> unify(Type type1, Type type2) {
        TypeUnifier unifier = new TypeUnifier();
        if (unifier.tryUnify(type1, type2)) {
            return ImmutableMap.copyOf(unifier.variables);
        }
        return null;
    }

    boolean tryUnify(Type type1, Type type2) {
        if (type2.op() == Op.TY_VAR && type1.op() != Op.TY_VAR) {
            return this.tryUnify(type2, type1);
        }
        switch (type1.op()) {
            case TY_VAR: {
                TypeVar var1 = (TypeVar)type1;
                @Nullable Type type1b = this.variables.get(var1.ordinal);
                if (type1b == null) {
                    this.variables.put(var1.ordinal, type2);
                    return true;
                }
                return this.tryUnify(type1b, type2);
            }
            case DATA_TYPE: {
                DataType dataType1 = (DataType)type1;
                switch (type2.op()) {
                    case DATA_TYPE: {
                        DataType dataType2 = (DataType)type2;
                        return dataType1.name.equals(dataType2.name) && Pair.allMatch(dataType1.arguments, dataType2.arguments, this::tryUnify);
                    }
                }
                return false;
            }
            case TUPLE_TYPE: {
                TupleType tuple1 = (TupleType)type1;
                switch (type2.op()) {
                    case TUPLE_TYPE: {
                        TupleType tuple2 = (TupleType)type2;
                        return tuple1.argTypes.size() == tuple2.argTypes.size() && Pair.allMatch(tuple1.argTypes, tuple2.argTypes, this::tryUnify);
                    }
                }
                return false;
            }
            case RECORD_TYPE: {
                RecordType record1 = (RecordType)type1;
                switch (type2.op()) {
                    case RECORD_TYPE: {
                        RecordType record2 = (RecordType)type2;
                        return record1.argNameTypes.size() == record2.argNameTypes.size() && record1.argNameTypes.keySet().equals(record2.argNameTypes.keySet()) && Pair.allMatch(record1.argNameTypes.values(), record2.argNameTypes.values(), this::tryUnify);
                    }
                }
                return false;
            }
            case LIST: {
                ListType list1 = (ListType)type1;
                switch (type2.op()) {
                    case LIST: {
                        ListType list2 = (ListType)type2;
                        return this.tryUnify(list1.elementType, list2.elementType);
                    }
                }
                return false;
            }
            case ID: {
                PrimitiveType primitiveType1 = (PrimitiveType)type1;
                switch (type2.op()) {
                    case ID: {
                        PrimitiveType primitiveType2 = (PrimitiveType)type2;
                        return primitiveType1 == primitiveType2;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

