/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.PairLists;

public interface ImmutablePairList<T, U>
extends PairList<T, U> {
    public static <T, U> ImmutablePairList<T, U> of() {
        return PairLists.EMPTY;
    }

    public static <T, U> ImmutablePairList<T, U> of(T t, U u) {
        return new PairLists.SingletonImmutablePairList<T, U>(t, u);
    }

    public static <T, U> PairList<T, U> copyOf(T t, U u, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (Object)"even number");
        if (rest.length == 0) {
            return new PairLists.SingletonImmutablePairList<T, U>(t, u);
        }
        Object[] elements = new Object[rest.length + 2];
        elements[0] = t;
        elements[1] = u;
        System.arraycopy(rest, 0, elements, 2, rest.length);
        return new PairLists.ArrayImmutablePairList(elements);
    }

    public static <T, U> ImmutablePairList<T, U> copyOf(Iterable<? extends Map.Entry<T, U>> iterable) {
        if (iterable instanceof PairList) {
            return ((PairList)iterable).immutable();
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            switch (collection.size()) {
                case 0: {
                    return ImmutablePairList.of();
                }
                case 1: {
                    Map.Entry<Map.Entry, U> entry2 = iterable.iterator().next();
                    return ImmutablePairList.of(entry2.getKey(), entry2.getValue());
                }
            }
            Object[] elements = new Object[2 * collection.size()];
            int i = 0;
            for (Map.Entry<Map.Entry, U> entry2 : iterable) {
                elements[i++] = entry2.getKey();
                elements[i++] = entry2.getValue();
            }
            return new PairLists.ArrayImmutablePairList(elements);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        iterable.forEach((? super T entry) -> {
            list.add(entry.getKey());
            list.add(entry.getValue());
        });
        return PairLists.immutableBackedBy(list);
    }

    @Override
    default public ImmutablePairList<T, U> immutable() {
        return this;
    }
}

