/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.hydromatic.morel.util.ArrayQueue;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Unifier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MartelliUnifier
extends Unifier {
    @Override
    public @NonNull Unifier.Result unify(List<Unifier.TermTerm> termPairs, Map<Unifier.Variable, Unifier.Action> termActions, List<Unifier.Constraint> constraints, Unifier.Tracer tracer) {
        long start = System.nanoTime();
        LinkedHashMap<Unifier.Variable, Unifier.Term> result = new LinkedHashMap<Unifier.Variable, Unifier.Term>();
        Work work = new Work(tracer, termPairs, constraints, result);
        int iteration = 0;
        while (true) {
            Unifier.TermTerm pair;
            if (!work.deleteQueue.isEmpty() && (pair = work.deleteQueue.remove(0)) != null) {
                tracer.onDelete(pair.left, pair.right);
            } else if (!work.seqSeqQueue.isEmpty()) {
                pair = work.seqSeqQueue.remove(0);
                Unifier.Sequence left = (Unifier.Sequence)pair.left;
                Unifier.Sequence right = (Unifier.Sequence)pair.right;
                if (!left.operator.equals(right.operator) || left.terms.size() != right.terms.size()) {
                    tracer.onConflict(left, right);
                    return this.failure("conflict: " + left + " vs " + right);
                }
                tracer.onSequence(left, right);
                for (int j = 0; j < left.terms.size(); ++j) {
                    work.add(left.terms.get(j), right.terms.get(j));
                }
            } else if (!work.varAnyQueue.isEmpty()) {
                Unifier.Term term2;
                pair = work.varAnyQueue.remove(0);
                Unifier.Term term = pair.right;
                Unifier.Variable variable = (Unifier.Variable)pair.left;
                if (term.contains(variable)) {
                    tracer.onCycle(variable, term);
                    return this.failure("cycle: variable " + variable + " in " + term);
                }
                while (term instanceof Unifier.Variable && (term2 = (Unifier.Term)result.get(term)) != null) {
                    term = term2;
                }
                if (!term.equals(variable)) {
                    Unifier.Failure failure;
                    tracer.onVariable(variable, term);
                    Unifier.Term priorTerm = result.put(variable, term);
                    if (priorTerm != null && !priorTerm.equals(term)) {
                        work.add(priorTerm, term);
                    }
                    if (!termActions.isEmpty()) {
                        HashSet<Unifier.Variable> set = new HashSet<Unifier.Variable>();
                        this.act(variable, term, work, new Unifier.Substitution(result), termActions, set);
                        Preconditions.checkArgument((boolean)set.isEmpty(), (String)"Working set not empty: %s", set);
                    }
                    if ((failure = work.substituteList(variable, term)) != null) {
                        return failure;
                    }
                }
            } else {
                long duration = System.nanoTime() - start;
                return Unifier.SubstitutionResult.create(result);
            }
            ++iteration;
        }
    }

    private void act(Unifier.Variable variable, Unifier.Term term, Work work, Unifier.Substitution substitution, Map<Unifier.Variable, Unifier.Action> termActions, Set<Unifier.Variable> set) {
        if (set.add(variable)) {
            this.act2(variable, term, work, substitution, termActions, set);
            set.remove(variable);
        }
    }

    private void act2(Unifier.Variable variable, Unifier.Term term, Work work, Unifier.Substitution substitution, Map<Unifier.Variable, Unifier.Action> termActions, Set<Unifier.Variable> set) {
        Unifier.Action action = termActions.get(variable);
        if (action != null) {
            action.accept(variable, term, substitution, work::add);
        }
        if (term instanceof Unifier.Variable) {
            List<Unifier.TermTerm> termPairsCopy = work.allTermPairs();
            termPairsCopy.forEach(termPair -> {
                if (termPair.left.equals(term)) {
                    this.act(variable, termPair.right, work, substitution, termActions, set);
                }
            });
            if (set.size() < 2) {
                this.act((Unifier.Variable)term, variable, work, substitution, termActions, set);
            }
        }
        substitution.resultMap.forEach((variable2, v) -> {
            if (v.equals(variable)) {
                this.act((Unifier.Variable)variable2, term, work, substitution, termActions, set);
            }
        });
    }

    class Work {
        final Unifier.Tracer tracer;
        final ArrayQueue<Unifier.TermTerm> deleteQueue = new ArrayQueue();
        final ArrayQueue<Unifier.TermTerm> seqSeqQueue = new ArrayQueue();
        final ArrayQueue<Unifier.TermTerm> varAnyQueue = new ArrayQueue();
        final List<MutableConstraint> constraintQueue = new ArrayList<MutableConstraint>();
        final Map<Unifier.Variable, Unifier.Term> result;

        Work(Unifier.Tracer tracer, List<Unifier.TermTerm> termPairs, List<Unifier.Constraint> constraints, Map<Unifier.Variable, Unifier.Term> result) {
            this.tracer = tracer;
            this.result = result;
            termPairs.forEach(pair -> this.add(pair.left, pair.right));
            constraints.forEach(c -> this.constraintQueue.add(new MutableConstraint((Unifier.Constraint)c)));
        }

        public String toString() {
            return String.format("delete %s seqSeq %s varAny %s constraints %s result %s", this.deleteQueue, this.seqSeqQueue, this.varAnyQueue, this.constraintQueue, this.result);
        }

        void add2(Unifier.Term left, Unifier.Term right) {
            this.add(left.apply(this.result), right.apply(this.result));
        }

        void add(Unifier.Term left, Unifier.Term right) {
            switch (Kind.of(left, right).ordinal()) {
                case 0: {
                    this.deleteQueue.add(new Unifier.TermTerm(left, right));
                    break;
                }
                case 1: {
                    this.seqSeqQueue.add(new Unifier.TermTerm(left, right));
                    break;
                }
                case 3: {
                    this.tracer.onSwap(left, right);
                    this.varAnyQueue.add(new Unifier.TermTerm(right, left));
                    break;
                }
                case 2: {
                    this.varAnyQueue.add(new Unifier.TermTerm(left, right));
                }
            }
        }

        List<Unifier.TermTerm> allTermPairs() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.deleteQueue.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.seqSeqQueue.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.varAnyQueue.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }

        private @Nullable Unifier.Failure substituteList(Unifier.Variable variable, Unifier.Term term) {
            this.sub(variable, term, this.deleteQueue, Kind.DELETE);
            this.sub(variable, term, this.seqSeqQueue, Kind.SEQ_SEQ);
            this.sub(variable, term, this.varAnyQueue, Kind.VAR_ANY);
            return this.subConstraint(variable, term);
        }

        private void sub(Unifier.Variable variable, Unifier.Term term, ArrayQueue<Unifier.TermTerm> queue, Kind kind) {
            ListIterator<Unifier.TermTerm> iter = queue.listIterator();
            while (iter.hasNext()) {
                Unifier.TermTerm pair = iter.next();
                Unifier.Term left2 = pair.left.apply1(variable, term);
                Unifier.Term right2 = pair.right.apply1(variable, term);
                if (left2 == pair.left && right2 == pair.right) continue;
                this.tracer.onSubstitute(pair.left, pair.right, left2, right2);
                Kind kind2 = Kind.of(left2, right2);
                if (kind2 == kind) {
                    iter.set(new Unifier.TermTerm(left2, right2));
                    continue;
                }
                if (kind2 == Kind.NON_VAR_VAR && kind == Kind.VAR_ANY) {
                    iter.set(new Unifier.TermTerm(right2, left2));
                    continue;
                }
                iter.remove();
                this.add(left2, right2);
            }
        }

        private @Nullable Unifier.Failure subConstraint(Unifier.Variable variable, Unifier.Term term) {
            for (MutableConstraint constraint : this.constraintQueue) {
                Unifier.Term arg2 = constraint.arg.apply1(variable, term);
                int changeCount = 0;
                if (arg2 != constraint.arg) {
                    ++changeCount;
                    constraint.arg = arg2;
                    constraint.termActions.leftList().removeIf(arg1 -> !arg2.couldUnifyWith((Unifier.Term)arg1));
                }
                ListIterator<Unifier.Term> iterator = constraint.termActions.leftList().listIterator();
                while (iterator.hasNext()) {
                    Unifier.Term subArg2;
                    Unifier.Term subArg = iterator.next();
                    if (subArg == (subArg2 = subArg.apply1(variable, term))) continue;
                    ++changeCount;
                    iterator.set(subArg2);
                    if (arg2.couldUnifyWith(subArg2)) continue;
                    iterator.remove();
                }
                if (changeCount <= 0) continue;
                switch (constraint.termActions.size()) {
                    case 0: {
                        return MartelliUnifier.this.failure("no valid overloads");
                    }
                    case 1: {
                        Unifier.Term term1 = constraint.termActions.left(0);
                        Unifier.Constraint.Action action = constraint.termActions.right(0);
                        action.accept(constraint.arg, term1, this::add2);
                    }
                }
            }
            return null;
        }
    }

    private static class MutableConstraint {
        final Unifier.Variable v;
        Unifier.Term arg;
        Unifier.Variable result;
        final PairList<Unifier.Term, Unifier.Constraint.Action> termActions;

        MutableConstraint(Unifier.Variable arg, PairList<Unifier.Term, Unifier.Constraint.Action> termActions) {
            this.v = Objects.requireNonNull(arg);
            this.arg = Objects.requireNonNull(arg);
            this.termActions = termActions;
            Preconditions.checkArgument((!termActions.isEmpty() ? 1 : 0) != 0);
        }

        MutableConstraint(Unifier.Constraint constraint) {
            this(constraint.arg, PairList.copyOf(constraint.termActions));
        }

        public String toString() {
            return String.format("{constraint %s = %s %s %s}", this.v, this.arg, this.result, this.termActions);
        }
    }

    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind DELETE = new Kind();
        public static final /* enum */ Kind SEQ_SEQ = new Kind();
        public static final /* enum */ Kind VAR_ANY = new Kind();
        public static final /* enum */ Kind NON_VAR_VAR = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        static Kind of(Unifier.Term left, Unifier.Term right) {
            if (left.equals(right)) {
                return DELETE;
            }
            if (left instanceof Unifier.Sequence) {
                if (right instanceof Unifier.Sequence) {
                    return SEQ_SEQ;
                }
                assert (right instanceof Unifier.Variable);
                return NON_VAR_VAR;
            }
            assert (left instanceof Unifier.Variable);
            return VAR_ANY;
        }

        private static /* synthetic */ Kind[] $values() {
            return new Kind[]{DELETE, SEQ_SEQ, VAR_ANY, NON_VAR_VAR};
        }

        static {
            $VALUES = Kind.$values();
        }
    }
}

