/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableSortedMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.Unifier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RobinsonUnifier
extends Unifier {
    static Map<Unifier.Variable, Unifier.Term> compose(Map<Unifier.Variable, Unifier.Term> s1, Map<Unifier.Variable, Unifier.Term> s2) {
        HashMap<Unifier.Variable, Unifier.Term> composed = new HashMap<Unifier.Variable, Unifier.Term>(s1);
        s2.forEach((key, value) -> composed.put((Unifier.Variable)key, value.apply(s1)));
        return composed;
    }

    private @NonNull Unifier.Result sequenceUnify(Unifier.Sequence lhs, Unifier.Sequence rhs) {
        Unifier.Sequence restRhs;
        Unifier.Term firstRhs;
        if (lhs.terms.size() != rhs.terms.size()) {
            return this.failure("sequences have different length: " + lhs + ", " + rhs);
        }
        if (!lhs.operator.equals(rhs.operator)) {
            return this.failure("sequences have different operator: " + lhs + ", " + rhs);
        }
        if (lhs.terms.isEmpty()) {
            return Unifier.SubstitutionResult.EMPTY;
        }
        Unifier.Term firstLhs = lhs.terms.get(0);
        Unifier.Result r1 = this.unify(firstLhs, firstRhs = rhs.terms.get(0));
        if (!(r1 instanceof Unifier.Substitution)) {
            return r1;
        }
        Unifier.Substitution subs1 = (Unifier.Substitution)((Object)r1);
        Unifier.Sequence restLhs = RobinsonUnifier.sequenceApply(lhs.operator, subs1.resultMap, Static.skip(lhs.terms));
        Unifier.Result r2 = this.sequenceUnify(restLhs, restRhs = RobinsonUnifier.sequenceApply(rhs.operator, subs1.resultMap, Static.skip(rhs.terms)));
        if (!(r2 instanceof Unifier.Substitution)) {
            return r2;
        }
        Unifier.Substitution subs2 = (Unifier.Substitution)((Object)r2);
        ImmutableSortedMap joined = ImmutableSortedMap.naturalOrder().putAll(subs1.resultMap).putAll(subs2.resultMap).build();
        return Unifier.SubstitutionResult.create((Map<Unifier.Variable, Unifier.Term>)joined);
    }

    @Override
    public @NonNull Unifier.Result unify(List<Unifier.TermTerm> termPairs, Map<Unifier.Variable, Unifier.Action> termActions, List<Unifier.Constraint> constraints, Unifier.Tracer tracer) {
        if (!constraints.isEmpty()) {
            throw new AssertionError((Object)"Constraints are not supported");
        }
        switch (termPairs.size()) {
            case 1: {
                return this.unify(termPairs.get((int)0).left, termPairs.get((int)0).right);
            }
        }
        throw new AssertionError();
    }

    public @NonNull Unifier.Result unify(Unifier.Term lhs, Unifier.Term rhs) {
        if (lhs instanceof Unifier.Variable) {
            return Unifier.SubstitutionResult.create((Unifier.Variable)lhs, rhs);
        }
        if (rhs instanceof Unifier.Variable) {
            return Unifier.SubstitutionResult.create((Unifier.Variable)rhs, lhs);
        }
        if (lhs instanceof Unifier.Sequence && rhs instanceof Unifier.Sequence) {
            return this.sequenceUnify((Unifier.Sequence)lhs, (Unifier.Sequence)rhs);
        }
        return this.failure("terms have different types: " + lhs + ", " + rhs);
    }
}

