/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.hydromatic.morel.util.ConsList;
import org.apache.calcite.util.Util;

public class Static {
    public static final boolean SKIP = Static.getBooleanProperty("skipMorelBuiltIns", false);

    private Static() {
    }

    private static boolean getBooleanProperty(String prop, boolean defaultVal) {
        String value = System.getProperty(prop);
        if (value == null) {
            return defaultVal;
        }
        String low = value.toLowerCase(Locale.ROOT);
        return low.equals("true") || low.equals("1") || low.isEmpty() ? true : (low.equals("false") || low.equals("0") ? false : defaultVal);
    }

    public static <E> boolean shorterThan(Iterable<E> iterable, int n) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size() < n;
        }
        if (n <= 0) {
            return false;
        }
        int i = 0;
        Iterator<E> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (++i == n) {
                return false;
            }
            iterator.next();
        }
        return true;
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> skip(List<E> list) {
        return Static.skip(list, 1);
    }

    public static <E> List<E> skip(List<E> list, int count) {
        return list.subList(count, list.size());
    }

    public static <E> List<E> skipLast(List<E> list) {
        return Static.skipLast(list, 1);
    }

    public static <E> List<E> skipLast(List<E> list, int n) {
        return list.subList(0, list.size() - n);
    }

    public static <E> List<E> append(List<E> list, E e) {
        return ImmutableList.builder().addAll(list).add(e).build();
    }

    public static <E> List<E> plus(E e, List<E> list) {
        return ConsList.of(e, list);
    }

    public static <E> List<E> minus(List<E> list, E e) {
        ImmutableList.Builder builder = ImmutableList.builder();
        list.forEach(e2 -> {
            if (!e2.equals(e)) {
                builder.add(e2);
            }
        });
        return builder.build();
    }

    public static <K, V> Map<K, V> plus(Map<K, V> map, K k, V v) {
        return ImmutableMap.builder().putAll(map).put(k, v).build();
    }

    public static <K extends Comparable<K>, V> SortedMap<K, V> plus(SortedMap<K, V> map, K k, V v) {
        return new ImmutableSortedMap.Builder(map.comparator()).putAll(map).put(k, v).build();
    }

    public static int nextPowerOfTwo(int n) {
        int p = Integer.numberOfLeadingZeros(n);
        return 1 << 32 - p;
    }

    public static <E> boolean allMatch(Iterable<? extends E> iterable, Predicate<E> predicate) {
        for (E e : iterable) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean anyMatch(Iterable<? extends E> iterable, Predicate<E> predicate) {
        for (E e : iterable) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean noneMatch(Iterable<? extends E> iterable, Predicate<E> predicate) {
        for (E e : iterable) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E, T> List<T> transform(List<? extends E> elements, Function<E, T> mapper) {
        return Util.transform(elements, mapper);
    }

    public static <E, T> Iterable<T> transform(Iterable<? extends E> elements, Function<E, T> mapper) {
        return Iterables.transform(elements, mapper::apply);
    }

    public static <E, T> ImmutableList<T> transformEager(Iterable<? extends E> elements, Function<E, T> mapper) {
        if (elements instanceof List) {
            return Static.transformEager((Collection)elements, mapper);
        }
        ImmutableList.Builder b = ImmutableList.builder();
        elements.forEach(e -> b.add(mapper.apply(e)));
        return b.build();
    }

    public static <E, T> ImmutableList<T> transformEager(Collection<? extends E> elements, Function<E, T> mapper) {
        if (elements.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder b = ImmutableList.builderWithExpectedSize((int)elements.size());
        elements.forEach(e -> b.add(mapper.apply(e)));
        return b.build();
    }

    public static <E, T> ImmutableList<T> transformEager(List<? extends E> elements, Function<E, T> mapper) {
        switch (elements.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(mapper.apply(elements.get(0)));
            }
        }
        ImmutableList.Builder b = ImmutableList.builderWithExpectedSize((int)elements.size());
        elements.forEach(e -> b.add(mapper.apply(e)));
        return b.build();
    }

    public static <E> ImmutableList<E> filterEager(List<? extends E> elements, Predicate<E> predicate) {
        for (int i = 0; i < elements.size(); ++i) {
            int j;
            E element = elements.get(i);
            if (predicate.test(element)) continue;
            ImmutableList.Builder b = ImmutableList.builderWithExpectedSize((int)elements.size());
            for (j = 0; j < i; ++j) {
                b.add(elements.get(j));
            }
            for (j = i + 1; j < elements.size(); ++j) {
                E e = elements.get(j);
                if (!predicate.test(e)) continue;
                b.add(e);
            }
            return b.build();
        }
        return ImmutableList.copyOf(elements);
    }

    public static <K, V, V2> ImmutableMap<K, V2> transformValuesEager(Map<K, V> map, Function<V, V2> mapper) {
        if (map.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder b = ImmutableMap.builderWithExpectedSize((int)map.size());
        map.forEach((k, v) -> b.put(k, mapper.apply(v)));
        return b.build();
    }

    public static <K, V, V2> ImmutableSortedMap<K, V2> transformValuesEager(SortedMap<K, V> map, Function<V, V2> mapper) {
        if (map.isEmpty()) {
            return ImmutableSortedMap.of();
        }
        ImmutableSortedMap.Builder b = ImmutableSortedMap.orderedBy(map.comparator());
        map.forEach((k, v) -> b.put(k, mapper.apply(v)));
        return b.build();
    }

    public static <E> int find(List<? extends E> list, Predicate<E> predicate) {
        if (list instanceof RandomAccess) {
            for (int i = 0; i < list.size(); ++i) {
                if (!predicate.test(list.get(i))) continue;
                return i;
            }
        } else {
            int i = 0;
            for (E e : list) {
                if (predicate.test(e)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static <E> List<E> intersect(List<E> list0, Iterable<? extends E> list1) {
        ImmutableList.Builder list2 = ImmutableList.builder();
        HashSet<E> set = new HashSet<E>(list0);
        for (E e : list1) {
            if (!set.contains(e)) continue;
            list2.add(e);
        }
        return list2.build();
    }

    public static String str(StringBuilder b) {
        String s = b.toString();
        b.setLength(0);
        return s;
    }

    public static boolean endsWith(StringBuilder buf, String s) {
        int i = buf.length() - s.length();
        return i >= 0 && buf.indexOf(s, i) == i;
    }
}

