/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TailList<E>
extends AbstractList<E> {
    private final List<E> list;
    private final int start;

    public TailList(List<E> list, int start) {
        this.list = Objects.requireNonNull(list);
        this.start = start;
    }

    public TailList(List<E> list) {
        this(list, list.size());
    }

    @Override
    public E get(int index) {
        return this.list.get(this.start + index);
    }

    @Override
    public int size() {
        return this.list.size() - this.start;
    }

    @Override
    public void clear() {
        while (this.list.size() > this.start) {
            this.list.remove(this.list.size() - 1);
        }
    }

    @Override
    public boolean add(E e) {
        return this.list.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.list.add(this.start + index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(this.start + index, c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(this.start + index);
    }

    @Override
    public E set(int index, E element) {
        return this.list.set(this.start + index, element);
    }
}

