/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class ThreadLocals {
    private ThreadLocals() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void let(ThreadLocal<T> threadLocal, T value, Runnable runnable) {
        T originalValue = threadLocal.get();
        threadLocal.set(value);
        try {
            runnable.run();
        }
        finally {
            threadLocal.set(originalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R let(ThreadLocal<T> threadLocal, T value, Supplier<R> supplier) {
        T originalValue = threadLocal.get();
        threadLocal.set(value);
        try {
            R r = supplier.get();
            return r;
        }
        finally {
            threadLocal.set(originalValue);
        }
    }

    public static <T> void mutate(ThreadLocal<T> threadLocal, UnaryOperator<T> transform, Runnable runnable) {
        ThreadLocals.let(threadLocal, transform.apply(threadLocal.get()), runnable);
    }

    public static <T, R> R mutate(ThreadLocal<T> threadLocal, UnaryOperator<T> transform, Supplier<R> supplier) {
        return ThreadLocals.let(threadLocal, transform.apply(threadLocal.get()), supplier);
    }
}

