/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.Unifier;

public class Tracers {
    private Tracers() {
    }

    public static ConfigurableTracer nullTracer() {
        return ConfigurableTracerImpl.INITIAL;
    }

    public static ConfigurableTracer printTracer(PrintWriter w) {
        PrintTracer p = new PrintTracer(w);
        return ConfigurableTracerImpl.INITIAL.withConflictHandler(p::onConflict).withCycleHandler(p::onCycle).withDeleteHandler(p::onDelete).withSequenceHandler(p::onSequence).withVariableHandler(p::onVariable).withSubstituteHandler(p::onSubstitute).withSwapHandler(p::onSwap);
    }

    public static ConfigurableTracer printTracer(OutputStream stream) {
        return Tracers.printTracer(new PrintWriter(stream));
    }

    private static class ConfigurableTracerImpl
    implements ConfigurableTracer {
        static final ConfigurableTracerImpl INITIAL = new ConfigurableTracerImpl((left, right) -> {}, (left, right) -> {}, (left, right) -> {}, (left, right) -> {}, (left, right) -> {}, (left, right) -> {}, (left, right, left2, right2) -> {});
        private final BiConsumer<Unifier.Term, Unifier.Term> deleteHandler;
        private final BiConsumer<Unifier.Sequence, Unifier.Sequence> conflictHandler;
        private final BiConsumer<Unifier.Sequence, Unifier.Sequence> sequenceHandler;
        private final BiConsumer<Unifier.Term, Unifier.Term> swapHandler;
        private final BiConsumer<Unifier.Variable, Unifier.Term> cycleHandler;
        private final BiConsumer<Unifier.Variable, Unifier.Term> variableHandler;
        private final QuadConsumer<Unifier.Term, Unifier.Term, Unifier.Term, Unifier.Term> substituteHandler;

        private ConfigurableTracerImpl(BiConsumer<Unifier.Term, Unifier.Term> deleteHandler, BiConsumer<Unifier.Sequence, Unifier.Sequence> conflictHandler, BiConsumer<Unifier.Sequence, Unifier.Sequence> sequenceHandler, BiConsumer<Unifier.Term, Unifier.Term> swapHandler, BiConsumer<Unifier.Variable, Unifier.Term> cycleHandler, BiConsumer<Unifier.Variable, Unifier.Term> variableHandler, QuadConsumer<Unifier.Term, Unifier.Term, Unifier.Term, Unifier.Term> substituteHandler) {
            this.deleteHandler = Objects.requireNonNull(deleteHandler);
            this.conflictHandler = Objects.requireNonNull(conflictHandler);
            this.sequenceHandler = Objects.requireNonNull(sequenceHandler);
            this.swapHandler = Objects.requireNonNull(swapHandler);
            this.cycleHandler = Objects.requireNonNull(cycleHandler);
            this.variableHandler = Objects.requireNonNull(variableHandler);
            this.substituteHandler = Objects.requireNonNull(substituteHandler);
        }

        @Override
        public ConfigurableTracer withDeleteHandler(BiConsumer<Unifier.Term, Unifier.Term> deleteHandler) {
            return new ConfigurableTracerImpl(deleteHandler, this.conflictHandler, this.sequenceHandler, this.swapHandler, this.cycleHandler, this.variableHandler, this.substituteHandler);
        }

        @Override
        public ConfigurableTracer withConflictHandler(BiConsumer<Unifier.Sequence, Unifier.Sequence> conflictHandler) {
            return new ConfigurableTracerImpl(this.deleteHandler, conflictHandler, this.sequenceHandler, this.swapHandler, this.cycleHandler, this.variableHandler, this.substituteHandler);
        }

        @Override
        public ConfigurableTracer withSequenceHandler(BiConsumer<Unifier.Sequence, Unifier.Sequence> sequenceHandler) {
            return new ConfigurableTracerImpl(this.deleteHandler, this.conflictHandler, sequenceHandler, this.swapHandler, this.cycleHandler, this.variableHandler, this.substituteHandler);
        }

        @Override
        public ConfigurableTracer withSwapHandler(BiConsumer<Unifier.Term, Unifier.Term> swapHandler) {
            return new ConfigurableTracerImpl(this.deleteHandler, this.conflictHandler, this.sequenceHandler, swapHandler, this.cycleHandler, this.variableHandler, this.substituteHandler);
        }

        @Override
        public ConfigurableTracer withCycleHandler(BiConsumer<Unifier.Variable, Unifier.Term> cycleHandler) {
            return new ConfigurableTracerImpl(this.deleteHandler, this.conflictHandler, this.sequenceHandler, this.swapHandler, cycleHandler, this.variableHandler, this.substituteHandler);
        }

        @Override
        public ConfigurableTracer withVariableHandler(BiConsumer<Unifier.Variable, Unifier.Term> variableHandler) {
            return new ConfigurableTracerImpl(this.deleteHandler, this.conflictHandler, this.sequenceHandler, this.swapHandler, this.cycleHandler, variableHandler, this.substituteHandler);
        }

        @Override
        public ConfigurableTracer withSubstituteHandler(QuadConsumer<Unifier.Term, Unifier.Term, Unifier.Term, Unifier.Term> substituteHandler) {
            return new ConfigurableTracerImpl(this.deleteHandler, this.conflictHandler, this.sequenceHandler, this.swapHandler, this.cycleHandler, this.variableHandler, substituteHandler);
        }

        @Override
        public void onDelete(Unifier.Term left, Unifier.Term right) {
            this.deleteHandler.accept(left, right);
        }

        @Override
        public void onConflict(Unifier.Sequence left, Unifier.Sequence right) {
            this.conflictHandler.accept(left, right);
        }

        @Override
        public void onSequence(Unifier.Sequence left, Unifier.Sequence right) {
            this.sequenceHandler.accept(left, right);
        }

        @Override
        public void onSwap(Unifier.Term left, Unifier.Term right) {
            this.swapHandler.accept(left, right);
        }

        @Override
        public void onCycle(Unifier.Variable variable, Unifier.Term term) {
            this.cycleHandler.accept(variable, term);
        }

        @Override
        public void onVariable(Unifier.Variable variable, Unifier.Term term) {
            this.variableHandler.accept(variable, term);
        }

        @Override
        public void onSubstitute(Unifier.Term left, Unifier.Term right, Unifier.Term left2, Unifier.Term right2) {
            this.substituteHandler.accept(left, right, left2, right2);
        }
    }

    private static class PrintTracer
    implements Unifier.Tracer {
        private final StringBuilder b = new StringBuilder();
        private final PrintWriter w;

        PrintTracer(PrintWriter w) {
            this.w = Objects.requireNonNull(w);
        }

        private void flush() {
            this.w.println(Static.str(this.b));
            this.w.flush();
        }

        @Override
        public void onDelete(Unifier.Term left, Unifier.Term right) {
            this.b.append("delete ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onConflict(Unifier.Sequence left, Unifier.Sequence right) {
            this.b.append("conflict ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onSequence(Unifier.Sequence left, Unifier.Sequence right) {
            this.b.append("sequence ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onSwap(Unifier.Term left, Unifier.Term right) {
            this.b.append("swap ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onCycle(Unifier.Variable variable, Unifier.Term term) {
            this.b.append("cycle ").append(variable).append(' ').append(term);
            this.flush();
        }

        @Override
        public void onVariable(Unifier.Variable variable, Unifier.Term term) {
            this.b.append("variable ").append(variable).append(' ').append(term);
            this.flush();
        }

        @Override
        public void onSubstitute(Unifier.Term left, Unifier.Term right, Unifier.Term left2, Unifier.Term right2) {
            this.b.append("substitute ").append(left).append(' ').append(right);
            if (left2 != left) {
                this.b.append("; ").append(left).append(" -> ").append(left2);
            }
            if (right2 != right) {
                this.b.append("; ").append(right).append(" -> ").append(right2);
            }
            this.flush();
        }
    }

    public static interface ConfigurableTracer
    extends Unifier.Tracer {
        public ConfigurableTracer withDeleteHandler(BiConsumer<Unifier.Term, Unifier.Term> var1);

        public ConfigurableTracer withConflictHandler(BiConsumer<Unifier.Sequence, Unifier.Sequence> var1);

        public ConfigurableTracer withSequenceHandler(BiConsumer<Unifier.Sequence, Unifier.Sequence> var1);

        public ConfigurableTracer withSwapHandler(BiConsumer<Unifier.Term, Unifier.Term> var1);

        public ConfigurableTracer withCycleHandler(BiConsumer<Unifier.Variable, Unifier.Term> var1);

        public ConfigurableTracer withVariableHandler(BiConsumer<Unifier.Variable, Unifier.Term> var1);

        public ConfigurableTracer withSubstituteHandler(QuadConsumer<Unifier.Term, Unifier.Term, Unifier.Term, Unifier.Term> var1);
    }

    @FunctionalInterface
    public static interface QuadConsumer<T, U, V, W> {
        public void accept(T var1, U var2, V var3, W var4);
    }

    private static class NullTracer
    implements Unifier.Tracer {
        private NullTracer() {
        }

        @Override
        public void onDelete(Unifier.Term left, Unifier.Term right) {
        }

        @Override
        public void onConflict(Unifier.Sequence left, Unifier.Sequence right) {
        }

        @Override
        public void onSequence(Unifier.Sequence left, Unifier.Sequence right) {
        }

        @Override
        public void onSwap(Unifier.Term left, Unifier.Term right) {
        }

        @Override
        public void onCycle(Unifier.Variable variable, Unifier.Term term) {
        }

        @Override
        public void onVariable(Unifier.Variable variable, Unifier.Term term) {
        }

        @Override
        public void onSubstitute(Unifier.Term left, Unifier.Term right, Unifier.Term left2, Unifier.Term right2) {
        }
    }
}

