/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.hydromatic.morel.util.Unifier;

public abstract class Unifiers {
    public static void dump(PrintWriter pw, Iterable<Unifier.TermTerm> pairs) {
        new Dumper(pw).dumpAll(pairs);
    }

    private static class Dumper {
        final Map<Unifier.Term, String> terms = new HashMap<Unifier.Term, String>();
        final Set<String> names = new HashSet<String>();
        final PrintWriter pw;

        Dumper(PrintWriter pw) {
            this.pw = pw;
        }

        void dumpAll(Iterable<? extends Unifier.TermTerm> pairs) {
            this.pw.printf("List<Unifier.TermTerm> pairs = new ArrayList<>();%n", new Object[0]);
            for (Unifier.TermTerm termTerm : pairs) {
                String left = this.lookup(termTerm.left);
                String right = this.lookup(termTerm.right);
                this.pw.printf("pairs.add(new Unifier.TermTerm(%s, %s));\n", left, right);
            }
            this.pw.flush();
        }

        String var(String v) {
            if (v.isEmpty()) {
                v = "v";
            }
            if (Character.isUpperCase(v.charAt(0))) {
                v = v.toLowerCase(Locale.ROOT);
            }
            if (this.names.add(v)) {
                return v;
            }
            while (!v.isEmpty() && Character.isDigit(v.charAt(v.length() - 1))) {
                v = v.substring(0, v.length() - 1);
            }
            int i = 1;
            String v2;
            while (!this.names.add(v2 = v + i)) {
                ++i;
            }
            return v2;
        }

        String lookup(Unifier.Term term) {
            String s = this.terms.get(term);
            if (s != null) {
                return s;
            }
            this.terms.put(term, "");
            s = this.register(term);
            if (Character.isUpperCase(s.charAt(0))) {
                s = s.toLowerCase(Locale.ROOT);
            }
            this.terms.put(term, s);
            return s;
        }

        private String register(Unifier.Term term) {
            String v;
            if (term instanceof Unifier.Variable) {
                Unifier.Variable variable = (Unifier.Variable)term;
                v = this.var(variable.name);
                if (variable.name.matches("T[0-9]+")) {
                    this.pw.printf("final Unifier.Variable %s = unifier.variable(%d);%n", v, Integer.parseInt(variable.name.substring(1)));
                } else {
                    this.pw.printf("final Unifier.Variable %s = unifier.variable(\"%s\");%n", v, v);
                }
            } else {
                Unifier.Sequence sequence = (Unifier.Sequence)term;
                if (sequence.terms.isEmpty()) {
                    v = this.var(sequence.operator);
                    this.pw.printf("final Unifier.Term %s = unifier.atom(\"%s\");%n", v, sequence.operator);
                } else {
                    v = this.var(sequence.operator) + "1";
                    this.pw.printf("final Unifier.Sequence %s = unifier.apply(\"%s\", %s);%n", v, sequence.operator, sequence.terms.stream().map(this::lookup).collect(Collectors.joining(", ")));
                }
            }
            return v;
        }
    }
}

