/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.util.List;
import net.hydromatic.quidem.Quidem;
import org.checkerframework.checker.nullness.qual.Nullable;

class ChainingConnectionFactory
implements Quidem.ConnectionFactory {
    private final List<Quidem.ConnectionFactory> factories;

    ChainingConnectionFactory(Iterable<? extends Quidem.ConnectionFactory> factories) {
        this.factories = ImmutableList.copyOf(factories);
    }

    @Override
    public @Nullable Connection connect(String name, boolean reference) throws Exception {
        for (Quidem.ConnectionFactory factory : this.factories) {
            Connection c = factory.connect(name, reference);
            if (c == null) continue;
            return c;
        }
        return null;
    }
}

