/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.hydromatic.quidem.ChainingConnectionFactory;
import net.hydromatic.quidem.Quidem;
import net.hydromatic.quidem.SimpleConnectionFactory;
import net.hydromatic.quidem.UnsupportedConnectionFactory;

public abstract class ConnectionFactories {
    private ConnectionFactories() {
    }

    public static Quidem.ConnectionFactory unsupported() {
        return new UnsupportedConnectionFactory();
    }

    public static Quidem.ConnectionFactory simple(String name, String url, String user, String password) {
        return ConnectionFactories.simple(name, url, user, password, connection -> true, connection -> {});
    }

    public static Quidem.ConnectionFactory simple(String name, String url, String user, String password, Predicate<Connection> verifier, Consumer<Connection> loader) {
        return new SimpleConnectionFactory(name, url, user, password, verifier, loader);
    }

    public static Quidem.ConnectionFactory chain(Iterable<? extends Quidem.ConnectionFactory> factories) {
        return new ChainingConnectionFactory((Iterable<? extends Quidem.ConnectionFactory>)ImmutableList.copyOf(factories));
    }

    public static Quidem.ConnectionFactory chain(Quidem.ConnectionFactory ... connectionFactories) {
        return ConnectionFactories.chain((Iterable<? extends Quidem.ConnectionFactory>)ImmutableList.copyOf((Object[])connectionFactories));
    }

    public static Quidem.ConnectionFactory empty() {
        return new ChainingConnectionFactory((Iterable<? extends Quidem.ConnectionFactory>)ImmutableList.of());
    }
}

