/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.hydromatic.quidem.ChainingCommandHandler;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.ConnectionFactories;
import net.hydromatic.quidem.Quidem;

class Launcher {
    private static final String[] USAGE_LINES = new String[]{"Usage: quidem argument... inFile outFile", "", "Arguments:", "  --help", "           Print usage", "  --db name url user password", "           Add a database to the connection factory", "  --var name value", "           Assign a value to a variable", "  --factory className", "           Define a connection factory (must implement interface", "        " + Quidem.ConnectionFactory.class.getCanonicalName() + ")", "  --command-handler className", "           Define a command-handler (must implement interface", "        " + CommandHandler.class.getCanonicalName() + ")"};
    private final List<String> args;
    private final PrintWriter out;

    Launcher(List<String> args, PrintWriter out) {
        this.args = args;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int main2(PrintWriter out, PrintWriter err, List<String> args) {
        try {
            Quidem quidem;
            Launcher launcher = new Launcher(args, out);
            try {
                quidem = launcher.parse();
            }
            catch (ParseException e) {
                int n = e.code;
                out.flush();
                err.flush();
                return n;
            }
            quidem.execute();
            int n = 0;
            return n;
        }
        catch (Throwable e) {
            out.flush();
            e.printStackTrace(err);
            int n = 2;
            return n;
        }
        finally {
            out.flush();
            err.flush();
        }
    }

    public Quidem parse() throws ParseException {
        FileWriter writer;
        LineNumberReader reader;
        ArrayList<Quidem.ConnectionFactory> factories = new ArrayList<Quidem.ConnectionFactory>();
        ArrayList<CommandHandler> commandHandlers = new ArrayList<CommandHandler>();
        LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < this.args.size()) {
            CommandHandler commandHandler;
            Class<?> factoryClass;
            String className;
            String name;
            String arg = this.args.get(i);
            if (arg.equals("--help")) {
                this.usage();
                throw new ParseException(0);
            }
            if (arg.equals("--db")) {
                if (i + 4 >= this.args.size()) {
                    throw this.error("Insufficient arguments for --db");
                }
                name = this.args.get(i + 1);
                String url = this.args.get(i + 2);
                String user = this.args.get(i + 3);
                String password = this.args.get(i + 4);
                factories.add(ConnectionFactories.simple(name, url, user, password));
                i += 5;
                continue;
            }
            if (arg.equals("--var")) {
                if (i + 3 >= this.args.size()) {
                    throw this.error("Insufficient arguments for --var");
                }
                name = this.args.get(i + 1);
                String value = this.args.get(i + 2);
                envMap.put(name, value);
                i += 3;
                continue;
            }
            if (arg.equals("--factory")) {
                Quidem.ConnectionFactory factory;
                if (i + 1 >= this.args.size()) {
                    throw this.error("Insufficient arguments for --factory");
                }
                className = this.args.get(i + 1);
                try {
                    factoryClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw this.error("Factory class " + className + " not found");
                }
                try {
                    factory = (Quidem.ConnectionFactory)factoryClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw this.error("Error instantiating factory class " + className);
                }
                catch (IllegalAccessException e) {
                    throw this.error("Error instantiating factory class " + className);
                }
                catch (ClassCastException e) {
                    throw this.error("Error instantiating factory class " + className);
                }
                factories.add(factory);
                i += 2;
                continue;
            }
            if (!arg.equals("--command-handler")) break;
            if (i + 1 >= this.args.size()) {
                throw this.error("Insufficient arguments for --command-handler");
            }
            className = this.args.get(i + 1);
            try {
                factoryClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw this.error("Factory class " + className + " not found");
            }
            try {
                commandHandler = (CommandHandler)factoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw this.error("Error instantiating command-handler class " + className);
            }
            catch (IllegalAccessException e) {
                throw this.error("Error instantiating command-handler class " + className);
            }
            catch (ClassCastException e) {
                throw this.error("Error instantiating command-handler class " + className);
            }
            commandHandlers.add(commandHandler);
            i += 2;
        }
        if (i + 2 > this.args.size()) {
            throw this.error("Insufficient arguments: need inFile and outFile");
        }
        File inFile = new File(this.args.get(i));
        File outFile = new File(this.args.get(i + 1));
        try {
            reader = new LineNumberReader(new FileReader(inFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error opening input " + inFile, e);
        }
        try {
            writer = new FileWriter(outFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening output " + outFile, e);
        }
        factories.add(ConnectionFactories.unsupported());
        Quidem.ConnectionFactory connectionFactory = ConnectionFactories.chain(factories);
        ChainingCommandHandler commandHandler = new ChainingCommandHandler(commandHandlers);
        Function<String, Object> env = envMap::get;
        Quidem.Config config = Quidem.configBuilder().withReader(reader).withWriter(writer).withEnv(env).withConnectionFactory(connectionFactory).withCommandHandler(commandHandler).build();
        return new Quidem(config);
    }

    private ParseException error(String error) {
        this.out.println(error);
        this.out.println();
        this.usage();
        return new ParseException(1);
    }

    private void usage() {
        for (String line : USAGE_LINES) {
            this.out.println(line);
        }
    }

    static class ParseException
    extends Exception {
        private final int code;

        ParseException(int code) {
            this.code = code;
        }
    }
}

