/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.hydromatic.quidem.Quidem;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleConnectionFactory
implements Quidem.ConnectionFactory {
    private final String name;
    private final String url;
    private final String user;
    private final String password;
    private final Predicate<Connection> verifier;
    private final Consumer<Connection> loader;
    private final ReentrantLock lock = new ReentrantLock();
    private int verifyCount = 0;

    SimpleConnectionFactory(String name, String url, String user, String password, Predicate<Connection> verifier, Consumer<Connection> loader) {
        this.name = Objects.requireNonNull(name);
        this.url = Objects.requireNonNull(url);
        this.user = Objects.requireNonNull(user);
        this.password = Objects.requireNonNull(password);
        this.verifier = Objects.requireNonNull(verifier);
        this.loader = Objects.requireNonNull(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Connection connect(String name, boolean reference) throws Exception {
        if (reference || !name.equals(this.name)) {
            return null;
        }
        Connection connection = DriverManager.getConnection(this.url, this.user, this.password);
        try {
            boolean valid;
            this.lock.lock();
            if (this.verifyCount++ == 0 && !(valid = this.verifier.test(connection))) {
                this.loader.accept(connection);
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

