/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem.record;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.function.Consumer;

public abstract class JdbcUtils {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    private static final ThreadLocal<SimpleDateFormat> TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("hh:mm:ss"));
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd hh:mm:ss"));
    private static final BiMap<String, Integer> JDBC_TYPES;

    private JdbcUtils() {
    }

    static String typeString(int type) {
        String typeName = (String)JDBC_TYPES.inverse().get((Object)type);
        if (typeName != null) {
            return typeName;
        }
        return "type" + type;
    }

    static int stringType(String typeName) {
        Integer type = (Integer)JDBC_TYPES.get((Object)typeName);
        if (type != null) {
            return type;
        }
        return 12;
    }

    public static void write(StringBuilder b, ResultSet r) throws SQLException {
        int i;
        ResultSetMetaData metaData = r.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (i = 0; i < columnCount; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(metaData.getColumnName(i + 1));
            b.append(':');
            b.append(JdbcUtils.typeString(metaData.getColumnType(i + 1)));
        }
        b.append('\n');
        while (r.next()) {
            for (i = 0; i < columnCount; ++i) {
                String s;
                if (i > 0) {
                    b.append(",");
                }
                if ((s = r.getString(i + 1)) == null) continue;
                if (s.isEmpty()) {
                    b.append("''");
                    continue;
                }
                b.append(s);
            }
            b.append('\n');
        }
    }

    public static void parse(String[] fields, String s) {
        int f = 0;
        block0: for (int i = 0; i < s.length(); ++i) {
            char c2;
            int start;
            char c = s.charAt(i);
            if (c == ',') {
                fields[f++] = null;
                continue;
            }
            if (c == '\'') {
                char c3;
                boolean escape;
                block11: {
                    start = ++i;
                    escape = false;
                    while (true) {
                        if (i >= s.length()) {
                            throw new IllegalArgumentException("missing \"'\"");
                        }
                        char c22 = s.charAt(i);
                        ++i;
                        if (c22 != '\'') continue;
                        if (i >= s.length()) {
                            String field = s.substring(start, i - 1);
                            if (escape) {
                                field = field.replace("''", "'");
                            }
                            fields[f++] = field;
                            continue block0;
                        }
                        c3 = s.charAt(i);
                        if (c3 != '\'') break block11;
                        escape = true;
                        if (++i >= s.length()) break;
                    }
                    throw new IllegalArgumentException("missing \"'\" following escaped \"'\"");
                }
                if (c3 == ',') {
                    String field = s.substring(start, i - 1);
                    if (escape) {
                        field = field.replace("''", "'");
                    }
                    fields[f++] = field;
                    continue;
                }
                throw new IllegalArgumentException("quoted string must be followed by comma or line ending");
            }
            start = i;
            do {
                if (++i < s.length()) continue;
                fields[f++] = s.substring(start, i);
                continue block0;
            } while ((c2 = s.charAt(i)) != ',');
            fields[f++] = s.substring(start, i);
        }
        while (f < fields.length) {
            fields[f++] = null;
        }
    }

    static void read(String s, Consumer<ResultSet> consumer) throws IOException {
        String[] headers;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(s));
        final ArrayList<String> names = new ArrayList<String>();
        final ArrayList<String> typeNames = new ArrayList<String>();
        String line = bufferedReader.readLine();
        if (line == null) {
            return;
        }
        for (String header : headers = line.split(",")) {
            int colon = header.indexOf(58);
            if (colon < 0) {
                names.add(header);
                typeNames.add("VARCHAR");
                continue;
            }
            names.add(header.substring(0, colon));
            typeNames.add(header.substring(colon + 1));
        }
        final ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            lines.add(line);
        }
        NullResultSet resultSet = new NullResultSet(){
            private boolean wasNull;
            int line;
            final String[] fields;
            {
                this.line = -1;
                this.fields = new String[names.size()];
            }

            @Override
            public ResultSetMetaData getMetaData() {
                return new NullResultSetMetaData(){

                    @Override
                    public int getColumnCount() {
                        return names.size();
                    }

                    @Override
                    public String getColumnName(int column) {
                        return (String)names.get(column - 1);
                    }

                    @Override
                    public String getColumnTypeName(int column) {
                        return (String)typeNames.get(column - 1);
                    }

                    @Override
                    public int getColumnType(int column) {
                        String typeName = this.getColumnTypeName(column);
                        return JdbcUtils.stringType(typeName);
                    }
                };
            }

            @Override
            public boolean next() {
                ++this.line;
                if (this.line >= lines.size()) {
                    Arrays.fill(this.fields, null);
                    return false;
                }
                JdbcUtils.parse(this.fields, (String)lines.get(this.line));
                return true;
            }

            @Override
            public boolean wasNull() {
                return this.wasNull;
            }

            @Override
            public String getString(int columnIndex) {
                String s = this.fields[columnIndex - 1];
                this.wasNull = s == null;
                return s;
            }

            @Override
            public boolean getBoolean(int columnIndex) {
                String s = this.getString(columnIndex);
                return Boolean.parseBoolean(s);
            }

            @Override
            public short getShort(int columnIndex) {
                String s = this.getString(columnIndex);
                return s == null ? (short)0 : Short.parseShort(s);
            }

            @Override
            public int getInt(int columnIndex) {
                String s = this.getString(columnIndex);
                return s == null ? 0 : Integer.parseInt(s);
            }

            @Override
            public long getLong(int columnIndex) {
                String s = this.getString(columnIndex);
                return s == null ? 0L : Long.parseLong(s);
            }

            @Override
            public double getDouble(int columnIndex) {
                String s = this.getString(columnIndex);
                return s == null ? 0.0 : Double.parseDouble(s);
            }

            @Override
            public float getFloat(int columnIndex) {
                String s = this.getString(columnIndex);
                return s == null ? 0.0f : Float.parseFloat(s);
            }

            @Override
            public BigDecimal getBigDecimal(int columnIndex) {
                String s = this.getString(columnIndex);
                return s == null ? null : new BigDecimal(s);
            }

            @Override
            public Date getDate(int columnIndex) {
                String s = this.getString(columnIndex);
                if (s == null) {
                    return null;
                }
                try {
                    return new Date(((SimpleDateFormat)DATE_FORMAT.get()).parse(s).getTime());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("invalid date '%s'", s));
                }
            }

            @Override
            public Time getTime(int columnIndex) {
                String s = this.getString(columnIndex);
                if (s == null) {
                    return null;
                }
                try {
                    return new Time(((SimpleDateFormat)TIME_FORMAT.get()).parse(s).getTime());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("invalid time '%s'", s));
                }
            }

            @Override
            public Timestamp getTimestamp(int columnIndex) {
                String s = this.getString(columnIndex);
                if (s == null) {
                    return null;
                }
                try {
                    return new Timestamp(((SimpleDateFormat)TIMESTAMP_FORMAT.get()).parse(s).getTime());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("invalid timestamp '%s'", s));
                }
            }
        };
        consumer.accept(resultSet);
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Field field : Types.class.getFields()) {
            if ((field.getModifiers() & 8) == 0 || field.getType() != Integer.TYPE) continue;
            try {
                builder.put((Object)field.getName(), (Object)field.getInt(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        JDBC_TYPES = builder.build();
    }

    private static class NullResultSetMetaData
    implements ResultSetMetaData {
        private NullResultSetMetaData() {
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public boolean isAutoIncrement(int column) {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return false;
        }

        @Override
        public boolean isSearchable(int column) {
            return false;
        }

        @Override
        public boolean isCurrency(int column) {
            return false;
        }

        @Override
        public int isNullable(int column) {
            return 2;
        }

        @Override
        public boolean isSigned(int column) {
            return false;
        }

        @Override
        public int getColumnDisplaySize(int column) {
            return 0;
        }

        @Override
        public String getColumnLabel(int column) {
            return "";
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public String getSchemaName(int column) {
            return "";
        }

        @Override
        public int getPrecision(int column) {
            return 0;
        }

        @Override
        public int getScale(int column) {
            return 0;
        }

        @Override
        public String getTableName(int column) {
            return "";
        }

        @Override
        public String getCatalogName(int column) {
            return "";
        }

        @Override
        public int getColumnType(int column) {
            return 0;
        }

        @Override
        public String getColumnTypeName(int column) {
            return "";
        }

        @Override
        public boolean isReadOnly(int column) {
            return false;
        }

        @Override
        public boolean isWritable(int column) {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) {
            return false;
        }

        @Override
        public String getColumnClassName(int column) {
            return "";
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }
    }

    private static class NullResultSet
    implements ResultSet {
        private NullResultSet() {
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean wasNull() {
            return false;
        }

        @Override
        public String getString(int columnIndex) {
            return "";
        }

        @Override
        public boolean getBoolean(int columnIndex) {
            return false;
        }

        @Override
        public byte getByte(int columnIndex) {
            return 0;
        }

        @Override
        public short getShort(int columnIndex) {
            return 0;
        }

        @Override
        public int getInt(int columnIndex) {
            return 0;
        }

        @Override
        public long getLong(int columnIndex) {
            return 0L;
        }

        @Override
        public float getFloat(int columnIndex) {
            return 0.0f;
        }

        @Override
        public double getDouble(int columnIndex) {
            return 0.0;
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex, int scale) {
            return null;
        }

        @Override
        public byte[] getBytes(int columnIndex) {
            return new byte[0];
        }

        @Override
        public Date getDate(int columnIndex) {
            return null;
        }

        @Override
        public Time getTime(int columnIndex) {
            return null;
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) {
            return null;
        }

        @Override
        public InputStream getAsciiStream(int columnIndex) {
            return null;
        }

        @Override
        public InputStream getUnicodeStream(int columnIndex) {
            return null;
        }

        @Override
        public InputStream getBinaryStream(int columnIndex) {
            return null;
        }

        @Override
        public String getString(String columnLabel) {
            return "";
        }

        @Override
        public boolean getBoolean(String columnLabel) {
            return false;
        }

        @Override
        public byte getByte(String columnLabel) {
            return 0;
        }

        @Override
        public short getShort(String columnLabel) {
            return 0;
        }

        @Override
        public int getInt(String columnLabel) {
            return 0;
        }

        @Override
        public long getLong(String columnLabel) {
            return 0L;
        }

        @Override
        public float getFloat(String columnLabel) {
            return 0.0f;
        }

        @Override
        public double getDouble(String columnLabel) {
            return 0.0;
        }

        @Override
        public BigDecimal getBigDecimal(String columnLabel, int scale) {
            return null;
        }

        @Override
        public byte[] getBytes(String columnLabel) {
            return new byte[0];
        }

        @Override
        public Date getDate(String columnLabel) {
            return null;
        }

        @Override
        public Time getTime(String columnLabel) {
            return null;
        }

        @Override
        public Timestamp getTimestamp(String columnLabel) {
            return null;
        }

        @Override
        public InputStream getAsciiStream(String columnLabel) {
            return null;
        }

        @Override
        public InputStream getUnicodeStream(String columnLabel) {
            return null;
        }

        @Override
        public InputStream getBinaryStream(String columnLabel) {
            return null;
        }

        @Override
        public SQLWarning getWarnings() {
            return null;
        }

        @Override
        public void clearWarnings() {
        }

        @Override
        public String getCursorName() {
            return "";
        }

        @Override
        public ResultSetMetaData getMetaData() {
            return null;
        }

        @Override
        public Object getObject(int columnIndex) {
            return null;
        }

        @Override
        public Object getObject(String columnLabel) {
            return null;
        }

        @Override
        public int findColumn(String columnLabel) {
            return 0;
        }

        @Override
        public Reader getCharacterStream(int columnIndex) {
            return null;
        }

        @Override
        public Reader getCharacterStream(String columnLabel) {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) {
            return null;
        }

        @Override
        public BigDecimal getBigDecimal(String columnLabel) {
            return null;
        }

        @Override
        public boolean isBeforeFirst() {
            return false;
        }

        @Override
        public boolean isAfterLast() {
            return false;
        }

        @Override
        public boolean isFirst() {
            return false;
        }

        @Override
        public boolean isLast() {
            return false;
        }

        @Override
        public void beforeFirst() {
        }

        @Override
        public void afterLast() {
        }

        @Override
        public boolean first() {
            return false;
        }

        @Override
        public boolean last() {
            return false;
        }

        @Override
        public int getRow() {
            return 0;
        }

        @Override
        public boolean absolute(int row) {
            return false;
        }

        @Override
        public boolean relative(int rows) {
            return false;
        }

        @Override
        public boolean previous() {
            return false;
        }

        @Override
        public void setFetchDirection(int direction) {
        }

        @Override
        public int getFetchDirection() {
            return 1000;
        }

        @Override
        public void setFetchSize(int rows) {
        }

        @Override
        public int getFetchSize() {
            return 0;
        }

        @Override
        public int getType() {
            return 1003;
        }

        @Override
        public int getConcurrency() {
            return 1007;
        }

        @Override
        public boolean rowUpdated() {
            return false;
        }

        @Override
        public boolean rowInserted() {
            return false;
        }

        @Override
        public boolean rowDeleted() {
            return false;
        }

        @Override
        public void updateNull(int columnIndex) {
        }

        @Override
        public void updateBoolean(int columnIndex, boolean x) {
        }

        @Override
        public void updateByte(int columnIndex, byte x) {
        }

        @Override
        public void updateShort(int columnIndex, short x) {
        }

        @Override
        public void updateInt(int columnIndex, int x) {
        }

        @Override
        public void updateLong(int columnIndex, long x) {
        }

        @Override
        public void updateFloat(int columnIndex, float x) {
        }

        @Override
        public void updateDouble(int columnIndex, double x) {
        }

        @Override
        public void updateBigDecimal(int columnIndex, BigDecimal x) {
        }

        @Override
        public void updateString(int columnIndex, String x) {
        }

        @Override
        public void updateBytes(int columnIndex, byte[] x) {
        }

        @Override
        public void updateDate(int columnIndex, Date x) {
        }

        @Override
        public void updateTime(int columnIndex, Time x) {
        }

        @Override
        public void updateTimestamp(int columnIndex, Timestamp x) {
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, int length) {
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, int length) {
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, int length) {
        }

        @Override
        public void updateObject(int columnIndex, Object x, int scaleOrLength) {
        }

        @Override
        public void updateObject(int columnIndex, Object x) {
        }

        @Override
        public void updateNull(String columnLabel) {
        }

        @Override
        public void updateBoolean(String columnLabel, boolean x) {
        }

        @Override
        public void updateByte(String columnLabel, byte x) {
        }

        @Override
        public void updateShort(String columnLabel, short x) {
        }

        @Override
        public void updateInt(String columnLabel, int x) {
        }

        @Override
        public void updateLong(String columnLabel, long x) {
        }

        @Override
        public void updateFloat(String columnLabel, float x) {
        }

        @Override
        public void updateDouble(String columnLabel, double x) {
        }

        @Override
        public void updateBigDecimal(String columnLabel, BigDecimal x) {
        }

        @Override
        public void updateString(String columnLabel, String x) {
        }

        @Override
        public void updateBytes(String columnLabel, byte[] x) {
        }

        @Override
        public void updateDate(String columnLabel, Date x) {
        }

        @Override
        public void updateTime(String columnLabel, Time x) {
        }

        @Override
        public void updateTimestamp(String columnLabel, Timestamp x) {
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, int length) {
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, int length) {
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, int length) {
        }

        @Override
        public void updateObject(String columnLabel, Object x, int scaleOrLength) {
        }

        @Override
        public void updateObject(String columnLabel, Object x) {
        }

        @Override
        public void insertRow() {
        }

        @Override
        public void updateRow() {
        }

        @Override
        public void deleteRow() {
        }

        @Override
        public void refreshRow() {
        }

        @Override
        public void cancelRowUpdates() {
        }

        @Override
        public void moveToInsertRow() {
        }

        @Override
        public void moveToCurrentRow() {
        }

        @Override
        public Statement getStatement() {
            return null;
        }

        @Override
        public Object getObject(int columnIndex, Map<String, Class<?>> map) {
            return null;
        }

        @Override
        public Ref getRef(int columnIndex) {
            return null;
        }

        @Override
        public Blob getBlob(int columnIndex) {
            return null;
        }

        @Override
        public Clob getClob(int columnIndex) {
            return null;
        }

        @Override
        public Array getArray(int columnIndex) {
            return null;
        }

        @Override
        public Object getObject(String columnLabel, Map<String, Class<?>> map) {
            return null;
        }

        @Override
        public Ref getRef(String columnLabel) {
            return null;
        }

        @Override
        public Blob getBlob(String columnLabel) {
            return null;
        }

        @Override
        public Clob getClob(String columnLabel) {
            return null;
        }

        @Override
        public Array getArray(String columnLabel) {
            return null;
        }

        @Override
        public Date getDate(int columnIndex, Calendar cal) {
            return null;
        }

        @Override
        public Date getDate(String columnLabel, Calendar cal) {
            return null;
        }

        @Override
        public Time getTime(int columnIndex, Calendar cal) {
            return null;
        }

        @Override
        public Time getTime(String columnLabel, Calendar cal) {
            return null;
        }

        @Override
        public Timestamp getTimestamp(int columnIndex, Calendar cal) {
            return null;
        }

        @Override
        public Timestamp getTimestamp(String columnLabel, Calendar cal) {
            return null;
        }

        @Override
        public URL getURL(int columnIndex) {
            return null;
        }

        @Override
        public URL getURL(String columnLabel) {
            return null;
        }

        @Override
        public void updateRef(int columnIndex, Ref x) {
        }

        @Override
        public void updateRef(String columnLabel, Ref x) {
        }

        @Override
        public void updateBlob(int columnIndex, Blob x) {
        }

        @Override
        public void updateBlob(String columnLabel, Blob x) {
        }

        @Override
        public void updateClob(int columnIndex, Clob x) {
        }

        @Override
        public void updateClob(String columnLabel, Clob x) {
        }

        @Override
        public void updateArray(int columnIndex, Array x) {
        }

        @Override
        public void updateArray(String columnLabel, Array x) {
        }

        @Override
        public RowId getRowId(int columnIndex) {
            return null;
        }

        @Override
        public RowId getRowId(String columnLabel) {
            return null;
        }

        @Override
        public void updateRowId(int columnIndex, RowId x) {
        }

        @Override
        public void updateRowId(String columnLabel, RowId x) {
        }

        @Override
        public int getHoldability() {
            return 2;
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public void updateNString(int columnIndex, String nString) {
        }

        @Override
        public void updateNString(String columnLabel, String nString) {
        }

        @Override
        public void updateNClob(int columnIndex, NClob nClob) {
        }

        @Override
        public void updateNClob(String columnLabel, NClob nClob) {
        }

        @Override
        public NClob getNClob(int columnIndex) {
            return null;
        }

        @Override
        public NClob getNClob(String columnLabel) {
            return null;
        }

        @Override
        public SQLXML getSQLXML(int columnIndex) {
            return null;
        }

        @Override
        public SQLXML getSQLXML(String columnLabel) {
            return null;
        }

        @Override
        public void updateSQLXML(int columnIndex, SQLXML xmlObject) {
        }

        @Override
        public void updateSQLXML(String columnLabel, SQLXML xmlObject) {
        }

        @Override
        public String getNString(int columnIndex) {
            return "";
        }

        @Override
        public String getNString(String columnLabel) {
            return "";
        }

        @Override
        public Reader getNCharacterStream(int columnIndex) {
            return null;
        }

        @Override
        public Reader getNCharacterStream(String columnLabel) {
            return null;
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x, long length) {
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader, long length) {
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, long length) {
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, long length) {
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, long length) {
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, long length) {
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, long length) {
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, long length) {
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream, long length) {
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream, long length) {
        }

        @Override
        public void updateClob(int columnIndex, Reader reader, long length) {
        }

        @Override
        public void updateClob(String columnLabel, Reader reader, long length) {
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader, long length) {
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader, long length) {
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x) {
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader) {
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x) {
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x) {
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x) {
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x) {
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x) {
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader) {
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream) {
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream) {
        }

        @Override
        public void updateClob(int columnIndex, Reader reader) {
        }

        @Override
        public void updateClob(String columnLabel, Reader reader) {
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader) {
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader) {
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) {
            return null;
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) {
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }
    }
}

