/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem.record;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.hydromatic.quidem.ConnectionFactories;
import net.hydromatic.quidem.Quidem;
import net.hydromatic.quidem.record.Config;
import net.hydromatic.quidem.record.JdbcUtils;
import net.hydromatic.quidem.record.Mode;
import net.hydromatic.quidem.record.Recorder;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Recorders {
    private Recorders() {
    }

    public static Config config() {
        return ConfigImpl.EMPTY;
    }

    public static Recorder create(Config config_) {
        ConfigImpl config = (ConfigImpl)config_;
        switch (config.mode) {
            case RECORD: {
                return new RecordingRecorder(config);
            }
            case PLAY: {
                return new PlayingRecorder(config);
            }
            case PASS_THROUGH: {
                return new PassThroughRecorder(config);
            }
        }
        throw new AssertionError((Object)config.mode);
    }

    private static class ConfigImpl
    implements Config {
        static final ConfigImpl EMPTY = new ConfigImpl(null, Mode.PLAY, ConnectionFactories.unsupported());
        final @Nullable File file;
        final Mode mode;
        final Quidem.ConnectionFactory connectionFactory;

        private ConfigImpl(@Nullable File file, Mode mode, Quidem.ConnectionFactory connectionFactory) {
            this.file = file;
            this.mode = Objects.requireNonNull(mode);
            this.connectionFactory = Objects.requireNonNull(connectionFactory);
        }

        @Override
        public Config withFile(File file) {
            return new ConfigImpl(file, this.mode, this.connectionFactory);
        }

        @Override
        public Config withMode(Mode mode) {
            return new ConfigImpl(this.file, mode, this.connectionFactory);
        }

        @Override
        public Config withConnectionFactory(Quidem.ConnectionFactory connectionFactory) {
            return new ConfigImpl(this.file, this.mode, connectionFactory);
        }
    }

    private static class RecordingRecorder
    extends RecorderWithFile {
        final SortedMap<String, Section> sections = new TreeMap<String, Section>();

        RecordingRecorder(ConfigImpl config) {
            super(config);
        }

        @Override
        public void executeQuery(String db, String name, String sql, Consumer<ResultSet> consumer) {
            try (Connection connection = this.config.connectionFactory.connect(db, false);){
                if (connection == null) {
                    throw new IllegalStateException("unknown connection " + db);
                }
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(sql);){
                    StringBuilder b = new StringBuilder();
                    JdbcUtils.write(b, resultSet);
                    String resultSetString = b.toString();
                    b.setLength(0);
                    Section section = new Section(-1, name, db, sql, resultSetString);
                    this.sections.put(name, section);
                    section.toResultSet(consumer);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("while executing query [%s]", sql), e);
            }
        }

        @Override
        public void close() {
            try (FileOutputStream fos = new FileOutputStream(this.file);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charsets.ISO_8859_1);
                 BufferedWriter w = new BufferedWriter(osw);
                 PrintWriter pw = new PrintWriter(w);){
                this.sections.forEach((name, segment) -> segment.send(pw));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PlayingRecorder
    extends RecorderWithFile {
        final SortedMap<String, Section> sectionsByName;
        final ImmutableMap<StringPair, Section> sectionsBySql;

        PlayingRecorder(ConfigImpl config) {
            super(config);
            ImmutableSortedMap.Builder nameBuilder = ImmutableSortedMap.naturalOrder();
            ImmutableMap.Builder sqlBuilder = ImmutableMap.builder();
            this.populate(this.file, section -> {
                nameBuilder.put((Object)section.name, section);
                sqlBuilder.put((Object)new StringPair(section.db, section.sql), section);
            });
            this.sectionsByName = nameBuilder.build();
            this.sectionsBySql = sqlBuilder.build();
        }

        private void populate(File file, Consumer<Section> consumer) {
            try (FileReader fr = new FileReader(file);
                 BufferedReader br = new BufferedReader(fr);){
                SectionBuilder sectionBuilder = new SectionBuilder();
                sectionBuilder.parse(br, consumer);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("file parsing file '%s'", file), e);
            }
        }

        @Override
        public void executeQuery(String db, String name, String sql, Consumer<ResultSet> consumer) {
            Section section = (Section)this.sectionsBySql.get((Object)new StringPair(db, sql));
            if (section == null) {
                throw new IllegalArgumentException(String.format("sql [%s] is not in recording", sql));
            }
            section.toResultSet(consumer);
        }
    }

    private static class PassThroughRecorder
    extends RecorderImpl {
        PassThroughRecorder(ConfigImpl config) {
            super(config);
        }

        @Override
        public void executeQuery(String db, String name, String sql, Consumer<ResultSet> consumer) {
            try (Connection connection = this.config.connectionFactory.connect(db, false);){
                if (connection == null) {
                    throw new IllegalStateException("unknown connection " + db);
                }
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(sql);){
                    consumer.accept(resultSet);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class StringPair {
        final String left;
        final String right;

        StringPair(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return this.left + ":" + this.right;
        }

        public int hashCode() {
            return this.left.hashCode() * 37 + this.right.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StringPair && this.left.equals(((StringPair)obj).left) && this.right.equals(((StringPair)obj).right);
        }
    }

    private static class Section {
        final int offset;
        final String name;
        final String db;
        final String sql;
        final String result;

        private Section(int offset, String name, String db, String sql, String result) {
            this.offset = offset;
            this.name = name;
            this.db = db;
            this.sql = sql;
            this.result = result;
        }

        public void send(PrintWriter pw) {
            pw.print("# StartTest: " + this.name + "\n!use " + this.db + "\n" + this.sql + ";\n" + this.result + "!ok\n# EndTest: " + this.name + "\n");
        }

        public void toResultSet(Consumer<ResultSet> consumer) {
            try {
                JdbcUtils.read(this.result, consumer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SectionBuilder {
        int offset;
        int sectionStart;
        String name;
        String db;
        String sql;
        String result;

        private SectionBuilder() {
        }

        Section build() {
            return new Section(this.offset, this.name, this.db, this.sql, this.result);
        }

        private void clear() {
            this.result = null;
            this.sql = null;
            this.db = null;
            this.name = null;
            this.sectionStart = -1;
        }

        void end(Consumer<Section> consumer) {
            consumer.accept(this.build());
            this.clear();
        }

        public void parse(BufferedReader br, Consumer<Section> consumer) throws IOException {
            String line;
            StringBuilder b = new StringBuilder();
            while ((line = br.readLine()) != null) {
                this.offset += line.length() + 1;
                if (line.startsWith("# EndTest: ")) {
                    String sectionName = line.substring("# EndTest: ".length()).trim();
                    if (!Objects.equals(sectionName, this.name)) {
                        throw new IllegalArgumentException(String.format("end '%s' does not match start '%s'", sectionName, this.name));
                    }
                    this.end(consumer);
                    continue;
                }
                if (line.startsWith("# StartTest: ")) {
                    if (this.name != null) {
                        this.end(consumer);
                    }
                    this.name = line.substring("# StartTest: ".length()).trim();
                    continue;
                }
                if (line.startsWith("!use ")) {
                    this.db = line.substring("!use ".length()).trim();
                    continue;
                }
                if (line.endsWith(";")) {
                    b.append(line, 0, line.length() - 1);
                    this.sql = b.toString();
                    b.setLength(0);
                    continue;
                }
                if (line.equals("!ok")) {
                    this.result = b.toString();
                    b.setLength(0);
                    continue;
                }
                b.append(line);
                b.append("\n");
            }
        }
    }

    private static abstract class RecorderWithFile
    extends RecorderImpl {
        protected final File file;

        RecorderWithFile(ConfigImpl config) {
            super(config);
            if (config.file == null) {
                throw new IllegalStateException(String.format("mode '%s' requires a file", new Object[]{config.mode}));
            }
            this.file = Objects.requireNonNull(config.file);
        }
    }

    private static abstract class RecorderImpl
    implements Recorder {
        protected final ConfigImpl config;

        RecorderImpl(ConfigImpl config) {
            this.config = Objects.requireNonNull(config, "config");
        }

        @Override
        public void close() {
        }
    }
}

