/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Quidem {
    private static final Ordering<String[]> ORDERING = Ordering.natural().nullsLast().lexicographical().onResultOf((Function)new Function<String[], Iterable<Comparable>>(){

        public Iterable<Comparable> apply(String[] input) {
            return Arrays.asList(input);
        }
    });
    public static final boolean DEBUG = "true".equals(System.getProperties().getProperty("quidem.debug"));
    private static final String[] USAGE_LINES = new String[]{"Usage: quidem argument... inFile outFile", "", "Arguments:", "  --help", "           Print usage", "  --db name url user password", "           Add a database to the connection factory", "  --factory className", "           Define a factory class"};
    private BufferedReader reader;
    private Writer writer;
    private PrintWriter printWriter;
    private final Map<Property, Object> map = new HashMap<Property, Object>();
    private ResultSet resultSet;
    private boolean sort;
    private SQLException resultSetException;
    private final List<String> lines = new ArrayList<String>();
    private String pushedLine;
    private final StringBuilder buf = new StringBuilder();
    private Connection connection;
    private ConnectionFactory connectionFactory;
    private boolean execute = true;
    private boolean skip = false;

    public Quidem(BufferedReader reader, Writer writer) {
        this.reader = reader;
        this.writer = writer;
        this.map.put(Property.OUTPUTFORMAT, (Object)OutputFormat.CSV);
    }

    public static void main(String[] args) {
        PrintWriter pw = new PrintWriter(System.out);
        try {
            Quidem.main2(Arrays.asList(args), pw);
            pw.flush();
        }
        catch (Throwable e) {
            pw.flush();
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main2(List<String> args, PrintWriter out) throws Exception {
        FileWriter writer;
        LineNumberReader reader;
        ArrayList factories = Lists.newArrayList();
        int i = 0;
        while (i < args.size()) {
            ConnectionFactory factory;
            Class<?> factoryClass;
            String arg = args.get(i);
            if (arg.equals("--help")) {
                Quidem.usage(out, null);
                return;
            }
            if (arg.equals("--db")) {
                if (i + 4 >= args.size()) {
                    Quidem.usage(out, "Insufficient arguments for --db");
                    return;
                }
                String name = args.get(i + 1);
                String url = args.get(i + 2);
                String user = args.get(i + 3);
                String password = args.get(i + 4);
                factories.add(new SimpleConnectionFactory(name, url, user, password));
                i += 5;
                continue;
            }
            if (!arg.equals("--factory")) break;
            if (i + 1 >= args.size()) {
                Quidem.usage(out, "Insufficient arguments for --factory");
            }
            String className = args.get(i + 1);
            try {
                factoryClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Quidem.usage(out, "Factory class " + className + " not found");
                return;
            }
            try {
                factory = (ConnectionFactory)factoryClass.newInstance();
            }
            catch (InstantiationException e) {
                Quidem.usage(out, "Error instantiating factory class " + className);
                return;
            }
            catch (IllegalAccessException e) {
                Quidem.usage(out, "Error instantiating factory class " + className);
                return;
            }
            catch (ClassCastException e) {
                Quidem.usage(out, "Error instantiating factory class " + className);
                return;
            }
            factories.add(factory);
            i += 2;
        }
        if (i + 2 > args.size()) {
            Quidem.usage(out, "Insufficient arguments: need inFile and outFile");
            return;
        }
        File inFile = new File(args.get(i));
        File outFile = new File(args.get(i + 1));
        try {
            reader = new LineNumberReader(new FileReader(inFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error opening input " + inFile, e);
        }
        try {
            writer = new FileWriter(outFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening output " + outFile, e);
        }
        factories.add(new UnsupportedConnectionFactory());
        Quidem quidem = new Quidem(new BufferedReader(reader), writer);
        quidem.execute(new ChainingConnectionFactory(factories));
        ((Reader)reader).close();
        ((Writer)writer).close();
    }

    private static void usage(PrintWriter out, String error) {
        if (error != null) {
            out.println(error);
            out.println();
        }
        for (String line : USAGE_LINES) {
            out.println(line);
        }
    }

    private void close() throws SQLException {
        if (this.connection != null) {
            Connection c = this.connection;
            this.connection = null;
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.printWriter = new PrintWriter(this.writer);
        try {
            Command command = new Parser().parse();
            try {
                command.execute(this.execute);
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while executing command " + command, e);
            }
            catch (AssertionError e) {
                throw new RuntimeException("Error while executing command " + command, (Throwable)((Object)e));
            }
        }
        finally {
            this.printWriter.flush();
            try {
                this.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    Command of(List<Command> commands) {
        return commands.size() == 1 ? commands.get(0) : new CompositeCommand((List<Command>)ImmutableList.copyOf(commands));
    }

    private static String pad(String s, int width, boolean right) {
        int x;
        if (s == null) {
            s = "";
        }
        if ((x = width - s.length()) <= 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        if (right) {
            buf.append(Quidem.chars(' ', x)).append(s);
        } else {
            buf.append(s).append(Quidem.chars(' ', x));
        }
        return buf.toString();
    }

    private static CharSequence chars(final char c, final int length) {
        return new CharSequence(){

            @Override
            public String toString() {
                char[] chars = new char[length];
                Arrays.fill(chars, c);
                return new String(chars);
            }

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                return c;
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return Quidem.chars(c, end - start);
            }
        };
    }

    private static void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort, boolean mysql) throws SQLException {
        int i;
        int i2;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int n = metaData.getColumnCount();
        int[] widths = new int[n];
        ArrayList<String[]> rows = new ArrayList<String[]>();
        boolean[] rights = new boolean[n];
        for (i2 = 0; i2 < n; ++i2) {
            widths[i2] = metaData.getColumnLabel(i2 + 1).length();
        }
        while (resultSet.next()) {
            String[] row = new String[n];
            for (i = 0; i < n; ++i) {
                String value = resultSet.getString(i + 1);
                widths[i] = Math.max(widths[i], value == null ? 0 : value.length());
                row[i] = value;
            }
            rows.add(row);
        }
        for (i2 = 0; i2 < widths.length; ++i2) {
            switch (metaData.getColumnType(i2 + 1)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    rights[i2] = true;
                }
            }
        }
        if (sort) {
            Collections.sort(rows, ORDERING);
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < n; ++i) {
            buf.append(mysql || i > 0 ? "+" : "");
            buf.append(Quidem.chars('-', widths[i] + 2));
        }
        buf.append(mysql ? "+" : "");
        String hyphens = Quidem.flush(buf);
        if (mysql) {
            headerLines.add(hyphens);
        }
        for (int i3 = 0; i3 < n; ++i3) {
            buf.append(i3 > 0 ? " | " : (mysql ? "| " : " "));
            String label = metaData.getColumnLabel(i3 + 1);
            buf.append(mysql || i3 < n - 1 ? Quidem.pad(label, widths[i3], false) : label);
        }
        buf.append(mysql ? " |" : "");
        headerLines.add(Quidem.flush(buf));
        headerLines.add(hyphens);
        for (String[] row : rows) {
            for (int i4 = 0; i4 < n; ++i4) {
                buf.append(i4 > 0 ? " | " : (mysql ? "| " : " "));
                String s = !mysql && i4 == n - 1 && !rights[i4] ? row[i4] : Quidem.pad(row[i4], widths[i4], rights[i4]);
                buf.append(s);
            }
            buf.append(mysql ? " |" : "");
            bodyLines.add(Quidem.flush(buf));
        }
        if (mysql) {
            footerLines.add(hyphens);
        }
        footerLines.add(rows.size() == 1 ? "(1 row)" : "(" + rows.size() + " rows)");
        footerLines.add("");
    }

    private static String flush(StringBuilder buf) {
        String s = buf.toString();
        buf.setLength(0);
        return s;
    }

    class CompositeCommand
    extends AbstractCommand {
        private final List<Command> commands;

        public CompositeCommand(List<Command> commands) {
            this.commands = commands;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            for (Command command : this.commands) {
                boolean abort = false;
                Object e = null;
                try {
                    command.execute(execute && Quidem.this.execute);
                }
                catch (RuntimeException e0) {
                    e = e0;
                }
                catch (Exception e0) {
                    e = e0;
                }
                catch (AssertionError e0) {
                    e = e0;
                }
                catch (Throwable e0) {
                    e = e0;
                    abort = true;
                }
                if (e == null) continue;
                command.execute(false);
                Quidem.this.printWriter.println("Error while executing command " + command);
                ((Throwable)e).printStackTrace(Quidem.this.printWriter);
                if (!abort) continue;
                throw (Error)e;
            }
        }
    }

    class SkipCommand
    extends SimpleCommand {
        public SkipCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            Quidem.this.skip = true;
            Quidem.this.execute = false;
        }
    }

    class IfCommand
    extends AbstractCommand {
        private final List<String> ifLines;
        private final List<String> endLines;
        private final Command command;
        private final boolean enable;

        public IfCommand(List<String> ifLines, List<String> endLines, Command command, boolean enable) {
            this.enable = enable;
            this.ifLines = ImmutableList.copyOf(ifLines);
            this.endLines = ImmutableList.copyOf(endLines);
            this.command = command;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo(this.ifLines);
            boolean oldExecute = Quidem.this.execute;
            boolean newExecute = Quidem.this.skip ? oldExecute : this.enable;
            this.command.execute(newExecute);
            this.echo(this.endLines);
        }
    }

    class CommentCommand
    extends SimpleCommand {
        public CommentCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
        }
    }

    class SetCommand
    extends SimpleCommand {
        private final Property property;
        private final Object value;

        public SetCommand(List<String> lines, Property property, Object value) {
            super(lines);
            this.property = property;
            this.value = value;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            Quidem.this.map.put(this.property, this.value);
        }
    }

    static enum Property {
        OUTPUTFORMAT;

    }

    public static interface ConnectionFactory {
        public Connection connect(String var1) throws Exception;
    }

    private class SqlCommand
    extends SimpleCommand {
        private final String sql;

        protected SqlCommand(List<String> lines, String sql, List<String> output) {
            super(lines);
            this.sql = (String)Preconditions.checkNotNull((Object)sql);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
        }
    }

    class ExplainCommand
    extends SimpleCommand {
        private final SqlCommand sqlCommand;
        private final ImmutableList<String> content;

        public ExplainCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> content) {
            super(lines);
            this.sqlCommand = sqlCommand;
            this.content = content;
        }

        public String toString() {
            return "ExplainCommand [sql: " + this.sqlCommand.sql + "]";
        }

        @Override
        public void execute(boolean execute) throws Exception {
            if (execute) {
                Statement statement = Quidem.this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery("explain plan for " + this.sqlCommand.sql);
                StringBuffer buf = new StringBuffer();
                while (resultSet.next()) {
                    String line = resultSet.getString(1);
                    buf.append(line);
                    if (line.endsWith("\n")) continue;
                    buf.append("\n");
                }
                if (buf.length() == 0) {
                    throw new AssertionError((Object)"explain returned 0 records");
                }
                Quidem.this.printWriter.print(buf);
                Quidem.this.printWriter.flush();
            } else {
                this.echo((Iterable<String>)this.content);
            }
            this.echo((Iterable<String>)this.lines);
        }
    }

    class ErrorCommand
    extends CheckResultCommand {
        public ErrorCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> output) {
            super(lines, sqlCommand, output);
        }

        @Override
        protected void checkResultSet(SQLException resultSetException) {
            if (resultSetException == null) {
                Quidem.this.printWriter.println("Expected error, but SQL command did not give one");
            } else if (!this.output.isEmpty() && this.stack(resultSetException).contains(this.concat((List<String>)this.output))) {
                for (String line : this.output) {
                    Quidem.this.printWriter.println(line);
                }
            } else {
                super.checkResultSet(resultSetException);
            }
        }

        private String stack(Throwable e) {
            StringWriter buf = new StringWriter();
            e.printStackTrace(new PrintWriter(buf));
            return buf.toString();
        }

        private String concat(List<String> lines) {
            StringBuilder buf = new StringBuilder();
            for (String line : lines) {
                buf.append(line.trim());
                buf.append("\n");
            }
            return buf.toString();
        }
    }

    class CheckResultCommand
    extends SimpleCommand {
        private final SqlCommand sqlCommand;
        protected final ImmutableList<String> output;

        public CheckResultCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> output) {
            super(lines);
            this.sqlCommand = sqlCommand;
            this.output = output;
        }

        public String toString() {
            return "CheckResultCommand [sql: " + this.sqlCommand.sql + "]";
        }

        @Override
        public void execute(boolean execute) throws Exception {
            if (execute) {
                if (Quidem.this.connection == null) {
                    throw new RuntimeException("no connection");
                }
                Statement statement = Quidem.this.connection.createStatement();
                if (Quidem.this.resultSet != null) {
                    Quidem.this.resultSet.close();
                }
                try {
                    if (DEBUG) {
                        System.out.println("execute: " + this);
                    }
                    Quidem.this.resultSet = null;
                    Quidem.this.resultSetException = null;
                    Quidem.this.resultSet = statement.executeQuery(this.sqlCommand.sql);
                    Quidem.this.sort = !this.sqlCommand.sql.toUpperCase().contains("ORDER BY");
                }
                catch (SQLException e) {
                    Quidem.this.resultSetException = e;
                }
                if (Quidem.this.resultSet != null) {
                    OutputFormat format = (OutputFormat)((Object)Quidem.this.map.get((Object)Property.OUTPUTFORMAT));
                    ArrayList<String> headerLines = new ArrayList<String>();
                    ArrayList<String> bodyLines = new ArrayList<String>();
                    ArrayList<String> footerLines = new ArrayList<String>();
                    format.format(Quidem.this.resultSet, headerLines, bodyLines, footerLines, Quidem.this);
                    ArrayList<String> lines = new ArrayList<String>((Collection<String>)this.output);
                    for (String line : headerLines) {
                        if (lines.isEmpty()) continue;
                        lines.remove(0);
                    }
                    for (String line : footerLines) {
                        if (lines.isEmpty()) continue;
                        lines.remove(lines.size() - 1);
                    }
                    for (String line : headerLines) {
                        Quidem.this.printWriter.println(line);
                    }
                    for (String line : lines) {
                        if (Quidem.this.sort) {
                            if (!bodyLines.remove(line)) continue;
                            Quidem.this.printWriter.println(line);
                            continue;
                        }
                        if (bodyLines.isEmpty() || !((String)bodyLines.get(0)).equals(line)) continue;
                        bodyLines.remove(0);
                        Quidem.this.printWriter.println(line);
                    }
                    for (String line : bodyLines) {
                        Quidem.this.printWriter.println(line);
                    }
                    for (String line : footerLines) {
                        Quidem.this.printWriter.println(line);
                    }
                    Quidem.this.resultSet.close();
                }
                this.checkResultSet(Quidem.this.resultSetException);
                if (Quidem.this.resultSet == null && Quidem.this.resultSetException == null) {
                    throw new AssertionError((Object)"neither resultSet nor exception set");
                }
                Quidem.this.resultSet = null;
                Quidem.this.resultSetException = null;
            } else {
                this.echo((Iterable<String>)this.output);
            }
            this.echo((Iterable<String>)this.lines);
        }

        protected void checkResultSet(SQLException resultSetException) {
            if (resultSetException != null) {
                resultSetException.printStackTrace(Quidem.this.printWriter);
            }
        }
    }

    class UseCommand
    extends SimpleCommand {
        private final String name;

        public UseCommand(List<String> lines, String name) {
            super(lines);
            this.name = name;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            if (Quidem.this.connection != null) {
                Quidem.this.connection.close();
            }
            Quidem.this.connection = Quidem.this.connectionFactory.connect(this.name);
        }
    }

    abstract class SimpleCommand
    extends AbstractCommand {
        protected final ImmutableList<String> lines;

        public SimpleCommand(List<String> lines) {
            this.lines = ImmutableList.copyOf(lines);
        }
    }

    abstract class AbstractCommand
    implements Command {
        AbstractCommand() {
        }

        protected Command echo(Iterable<String> lines) {
            for (String line : lines) {
                try {
                    Quidem.this.printWriter.println(line);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while writing output", e);
                }
            }
            return this;
        }
    }

    static interface Command {
        public void execute(boolean var1) throws Exception;
    }

    static enum OutputFormat {
        CSV{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, Quidem run) throws Exception {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int n = metaData.getColumnCount();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(metaData.getColumnLabel(i + 1));
                }
                headerLines.add(buf.toString());
                buf.setLength(0);
                ArrayList lines = Lists.newArrayList();
                while (resultSet.next()) {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(resultSet.getString(i + 1));
                    }
                    lines.add(buf.toString());
                    buf.setLength(0);
                }
                if (run.sort) {
                    Collections.sort(lines);
                }
                bodyLines.addAll(lines);
            }
        }
        ,
        PSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, Quidem run) throws Exception {
                Quidem.format(resultSet, headerLines, bodyLines, footerLines, run.sort, false);
            }
        }
        ,
        MYSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, Quidem run) throws Exception {
                Quidem.format(resultSet, headerLines, bodyLines, footerLines, run.sort, true);
            }
        };


        public abstract void format(ResultSet var1, List<String> var2, List<String> var3, List<String> var4, Quidem var5) throws Exception;
    }

    private class Parser {
        final List<Command> commands = new ArrayList<Command>();

        private Parser() {
        }

        Command parse() {
            while (true) {
                Command command;
                try {
                    command = this.nextCommand();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading next command", e);
                }
                if (command == null) break;
                this.commands.add(command);
            }
            return Quidem.this.of(this.commands);
        }

        private Command nextCommand() throws IOException {
            boolean last;
            Quidem.this.lines.clear();
            ImmutableList content = ImmutableList.of();
            do {
                block16: {
                    String line;
                    if ((line = this.nextLine()) == null) {
                        return null;
                    }
                    if (line.startsWith("#") || line.isEmpty()) {
                        return new CommentCommand(Quidem.this.lines);
                    }
                    if (line.startsWith("!")) {
                        line = line.substring(1);
                        while (line.startsWith(" ")) {
                            line = line.substring(1);
                        }
                        if (line.startsWith("use")) {
                            String[] parts = line.split(" ");
                            return new UseCommand(Quidem.this.lines, parts[1]);
                        }
                        if (line.startsWith("ok")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new CheckResultCommand(Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("plan")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new ExplainCommand(Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("error")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new ErrorCommand(Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("skip")) {
                            return new SkipCommand(Quidem.this.lines);
                        }
                        if (line.startsWith("set outputformat")) {
                            String[] parts = line.split(" ");
                            OutputFormat outputFormat = OutputFormat.valueOf(parts[2].toUpperCase());
                            return new SetCommand(Quidem.this.lines, Property.OUTPUTFORMAT, (Object)outputFormat);
                        }
                        if (line.equals("if (false) {")) {
                            ImmutableList ifLines = ImmutableList.copyOf((Collection)Quidem.this.lines);
                            Quidem.this.lines.clear();
                            Command command = new Parser().parse();
                            return new IfCommand((List<String>)ifLines, Quidem.this.lines, command, false);
                        }
                        if (line.equals("if (true) {")) {
                            ImmutableList ifLines = ImmutableList.copyOf((Collection)Quidem.this.lines);
                            Quidem.this.lines.clear();
                            Command command = new Parser().parse();
                            return new IfCommand((List<String>)ifLines, Quidem.this.lines, command, true);
                        }
                        if (line.equals("}")) {
                            return null;
                        }
                        throw new RuntimeException("Unknown command: " + line);
                    }
                    Quidem.this.buf.setLength(0);
                    last = false;
                    do {
                        if (line.endsWith(";")) {
                            last = true;
                            line = line.substring(0, line.length() - 1);
                        }
                        Quidem.this.buf.append(line).append("\n");
                        if (last) break block16;
                        line = this.nextLine();
                        if (line != null) continue;
                        throw new RuntimeException("end of file reached before end of SQL command");
                    } while (!line.startsWith("!") && !line.startsWith("#"));
                    this.pushLine();
                }
                content = ImmutableList.copyOf((Collection)Quidem.this.lines);
                Quidem.this.lines.clear();
            } while (!last);
            String sql = Quidem.this.buf.toString();
            return new SqlCommand((List<String>)content, sql, null);
        }

        private SqlCommand previousSqlCommand() {
            for (int i = this.commands.size() - 1; i >= 0; --i) {
                Command command = this.commands.get(i);
                if (!(command instanceof SqlCommand)) continue;
                return (SqlCommand)command;
            }
            throw new AssertionError((Object)"no previous SQL command");
        }

        private void pushLine() {
            if (Quidem.this.pushedLine != null) {
                throw new AssertionError((Object)"cannot push two lines");
            }
            if (Quidem.this.lines.size() == 0) {
                throw new AssertionError((Object)"no line has been read");
            }
            Quidem.this.pushedLine = (String)Quidem.this.lines.get(Quidem.this.lines.size() - 1);
            Quidem.this.lines.remove(Quidem.this.lines.size() - 1);
        }

        private String nextLine() throws IOException {
            String line;
            if (Quidem.this.pushedLine != null) {
                line = Quidem.this.pushedLine;
                Quidem.this.pushedLine = null;
            } else {
                line = Quidem.this.reader.readLine();
                if (line == null) {
                    return null;
                }
            }
            Quidem.this.lines.add(line);
            return line;
        }
    }

    private static class ChainingConnectionFactory
    implements ConnectionFactory {
        private final List<ConnectionFactory> factories;

        public ChainingConnectionFactory(List<ConnectionFactory> factories) {
            this.factories = ImmutableList.copyOf(factories);
        }

        @Override
        public Connection connect(String name) throws Exception {
            for (ConnectionFactory factory : this.factories) {
                Connection c = factory.connect(name);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }

    private static class UnsupportedConnectionFactory
    implements ConnectionFactory {
        private UnsupportedConnectionFactory() {
        }

        @Override
        public Connection connect(String name) {
            throw new RuntimeException("Unknown database: " + name);
        }
    }

    private static class SimpleConnectionFactory
    implements ConnectionFactory {
        private final String name;
        private final String url;
        private final String user;
        private final String password;

        public SimpleConnectionFactory(String name, String url, String user, String password) {
            this.name = name;
            this.url = url;
            this.user = user;
            this.password = password;
        }

        @Override
        public Connection connect(String name) throws Exception {
            if (name.equals(this.name)) {
                return DriverManager.getConnection(this.url, this.user, this.password);
            }
            return null;
        }
    }
}

