/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.hydromatic.quidem.ChainingConnectionFactory;
import net.hydromatic.quidem.Launcher;
import net.hydromatic.quidem.LimitWriter;

public class Quidem {
    private static final Ordering<String[]> ORDERING = Ordering.natural().nullsLast().lexicographical().onResultOf((Function)new Function<String[], Iterable<Comparable>>(){

        public Iterable<Comparable> apply(String[] input) {
            return Arrays.asList(input);
        }
    });
    public static final boolean DEBUG = "true".equals(System.getProperties().getProperty("quidem.debug"));
    private static final int DEFAULT_MAX_STACK_LENGTH = 16384;
    public static final Function<String, Object> EMPTY_ENV = new Function<String, Object>(){

        public Object apply(String name) {
            return null;
        }
    };
    public static final ConnectionFactory EMPTY_CONNECTION_FACTORY = new ChainingConnectionFactory((List<ConnectionFactory>)ImmutableList.of());
    public static final PropertyHandler EMPTY_PROPERTY_HANDLER = new PropertyHandler(){

        @Override
        public void onSet(String propertyName, Object value) {
        }
    };
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final Map<String, List<Object>> map = new HashMap<String, List<Object>>();
    private final Reader rawReader;
    private final Writer rawWriter;
    private final Function<String, Object> rawEnv;
    private PropertyHandler propertyHandler;
    private ResultSet resultSet;
    private boolean sort;
    private Throwable resultSetException;
    private final List<String> lines = new ArrayList<String>();
    private String pushedLine;
    private final StringBuilder buf = new StringBuilder();
    private Connection connection;
    private Connection refConnection;
    private final ConnectionFactory connectionFactory;
    private boolean execute = true;
    private boolean skip = false;
    private int stackLimit = 16384;
    private final Function<String, Object> env;

    public Quidem(Reader reader, Writer writer) {
        this(reader, writer, EMPTY_ENV, EMPTY_CONNECTION_FACTORY);
    }

    public Quidem(Reader reader, Writer writer, Function<String, Object> env, ConnectionFactory connectionFactory) {
        this(reader, writer, env, connectionFactory, EMPTY_PROPERTY_HANDLER);
    }

    private Quidem(Reader reader, Writer writer, Function<String, Object> env, ConnectionFactory connectionFactory, PropertyHandler propertyHandler) {
        this.rawReader = reader;
        this.rawWriter = writer;
        this.rawEnv = env;
        this.propertyHandler = propertyHandler;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.connectionFactory = connectionFactory;
        ArrayList<OutputFormat> list = new ArrayList<OutputFormat>();
        list.add(OutputFormat.CSV);
        this.map.put(Property.OUTPUTFORMAT.propertyName(), list);
        this.env = new TopEnv(env);
    }

    public Quidem withConnectionFactory(ConnectionFactory connectionFactory) {
        return new Quidem(this.rawReader, this.rawWriter, this.rawEnv, connectionFactory, this.propertyHandler);
    }

    public Quidem withPropertyHandler(PropertyHandler propertyHandler) {
        return new Quidem(this.rawReader, this.rawWriter, this.rawEnv, this.connectionFactory, propertyHandler);
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter err = new PrintWriter(System.err);
        int code = Launcher.main2(out, err, Arrays.asList(args));
        System.exit(code);
    }

    private void close() throws SQLException {
        Connection c;
        if (this.connection != null) {
            c = this.connection;
            this.connection = null;
            c.close();
        }
        if (this.refConnection != null) {
            c = this.refConnection;
            this.refConnection = null;
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            Command command = new Parser().parse();
            try {
                command.execute(this.execute);
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while executing command " + command, e);
            }
            catch (AssertionError e) {
                throw new RuntimeException("Error while executing command " + command, (Throwable)((Object)e));
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.writer.close();
            try {
                this.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    Command of(List<Command> commands) {
        return commands.size() == 1 ? commands.get(0) : new CompositeCommand((List<Command>)ImmutableList.copyOf(commands));
    }

    private static String pad(String s, int width, boolean right) {
        int x;
        if (s == null) {
            s = "";
        }
        if ((x = width - s.length()) <= 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        if (right) {
            buf.append(Quidem.chars(' ', x)).append(s);
        } else {
            buf.append(s).append(Quidem.chars(' ', x));
        }
        return buf.toString();
    }

    <E> Iterator<String> stringIterator(final Enumeration<E> enumeration) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public String next() {
                return enumeration.nextElement().toString();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static CharSequence chars(final char c, final int length) {
        return new CharSequence(){

            @Override
            public String toString() {
                char[] chars = new char[length];
                Arrays.fill(chars, c);
                return new String(chars);
            }

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                return c;
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return Quidem.chars(c, end - start);
            }
        };
    }

    public void setStackLimit(int stackLimit) {
        this.stackLimit = stackLimit;
    }

    private boolean getBoolean(List<String> names) {
        if (names.size() == 1) {
            if (names.get(0).equals("true")) {
                return true;
            }
            if (names.get(0).equals("false")) {
                return false;
            }
        }
        Function e = this.env;
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Object value = e.apply((Object)name);
            if (value instanceof Function) {
                e = (Function)value;
                continue;
            }
            if (i != names.size() - 1) continue;
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return value != null && value.toString().equalsIgnoreCase("true");
        }
        return false;
    }

    public boolean isProbablyDeterministic(String sql) {
        int openCount;
        String upperSql = sql.toUpperCase();
        if (!upperSql.contains("ORDER BY")) {
            return false;
        }
        int i = upperSql.lastIndexOf("ORDER BY");
        String tail = upperSql.substring(i);
        int closeCount = tail.length() - tail.replace(")", "").length();
        return closeCount <= (openCount = tail.length() - tail.replace("(", "").length());
    }

    private static void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, boolean sort, boolean mysql) throws SQLException {
        int i;
        int i2;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int n = metaData.getColumnCount();
        int[] widths = new int[n];
        ArrayList<String[]> rows = new ArrayList<String[]>();
        boolean[] rights = new boolean[n];
        for (i2 = 0; i2 < n; ++i2) {
            widths[i2] = metaData.getColumnLabel(i2 + 1).length();
        }
        while (resultSet.next()) {
            String[] row = new String[n];
            for (i = 0; i < n; ++i) {
                String value = resultSet.getString(i + 1);
                widths[i] = Math.max(widths[i], value == null ? 0 : value.length());
                row[i] = value;
            }
            rows.add(row);
        }
        for (i2 = 0; i2 < widths.length; ++i2) {
            switch (metaData.getColumnType(i2 + 1)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    rights[i2] = true;
                }
            }
        }
        if (sort) {
            Collections.sort(rows, ORDERING);
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < n; ++i) {
            buf.append(mysql || i > 0 ? "+" : "");
            buf.append(Quidem.chars('-', widths[i] + 2));
        }
        buf.append(mysql ? "+" : "");
        String hyphens = Quidem.flush(buf);
        if (mysql) {
            headerLines.add(hyphens);
        }
        for (int i3 = 0; i3 < n; ++i3) {
            buf.append(i3 > 0 ? " | " : (mysql ? "| " : " "));
            String label = metaData.getColumnLabel(i3 + 1);
            buf.append(mysql || i3 < n - 1 ? Quidem.pad(label, widths[i3], false) : label);
        }
        buf.append(mysql ? " |" : "");
        headerLines.add(Quidem.flush(buf));
        headerLines.add(hyphens);
        for (String[] row : rows) {
            for (int i4 = 0; i4 < n; ++i4) {
                buf.append(i4 > 0 ? " | " : (mysql ? "| " : " "));
                String s = !mysql && i4 == n - 1 && !rights[i4] ? row[i4] : Quidem.pad(row[i4], widths[i4], rights[i4]);
                buf.append(s);
            }
            buf.append(mysql ? " |" : "");
            bodyLines.add(Quidem.flush(buf));
        }
        if (mysql) {
            footerLines.add(hyphens);
        }
        footerLines.add(rows.size() == 1 ? "(1 row)" : "(" + rows.size() + " rows)");
        footerLines.add("");
    }

    private static String flush(StringBuilder buf) {
        String s = buf.toString();
        buf.setLength(0);
        return s;
    }

    private String stack(Throwable e) {
        StringWriter buf = new StringWriter();
        this.stack(e, buf);
        return buf.toString();
    }

    private void stack(Throwable e, Writer w) {
        if (this.stackLimit >= 0) {
            w = new LimitWriter(w, this.stackLimit);
        }
        PrintWriter pw = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        e.printStackTrace(pw);
        if (this.stackLimit >= 0) {
            assert (w instanceof LimitWriter);
            ((LimitWriter)w).ellipsis(" (stack truncated)\n");
        }
    }

    public static interface PropertyHandler {
        public void onSet(String var1, Object var2);
    }

    private class TopEnv
    implements Function<String, Object> {
        private final Function<String, Object> env;

        TopEnv(Function<String, Object> env) {
            this.env = env;
        }

        public Object apply(String s) {
            List list = (List)Quidem.this.map.get(s);
            if (list == null || list.isEmpty()) {
                return this.env.apply((Object)s);
            }
            return list.get(list.size() - 1);
        }
    }

    class CompositeCommand
    extends AbstractCommand {
        private final List<Command> commands;

        public CompositeCommand(List<Command> commands) {
            this.commands = commands;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            for (Command command : this.commands) {
                boolean abort = false;
                Object e = null;
                try {
                    command.execute(execute && Quidem.this.execute);
                }
                catch (RuntimeException e0) {
                    e = e0;
                }
                catch (Exception e0) {
                    e = e0;
                }
                catch (AssertionError e0) {
                    e = e0;
                }
                catch (Throwable e0) {
                    e = e0;
                    abort = true;
                }
                if (e == null) continue;
                command.execute(false);
                Quidem.this.writer.println("Error while executing command " + command);
                Quidem.this.stack((Throwable)e, Quidem.this.writer);
                if (!abort) continue;
                throw (Error)e;
            }
        }
    }

    class SkipCommand
    extends SimpleCommand {
        public SkipCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            Quidem.this.skip = true;
            Quidem.this.execute = false;
        }
    }

    class IfCommand
    extends AbstractCommand {
        private final List<String> ifLines;
        private final List<String> endLines;
        private final Command command;
        private final List<String> variables;

        public IfCommand(List<String> ifLines, List<String> endLines, Command command, List<String> variables) {
            this.variables = ImmutableList.copyOf(variables);
            this.ifLines = ImmutableList.copyOf(ifLines);
            this.endLines = ImmutableList.copyOf(endLines);
            this.command = command;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo(this.ifLines);
            boolean oldExecute = Quidem.this.execute;
            boolean newExecute = Quidem.this.skip ? oldExecute : Quidem.this.getBoolean(this.variables);
            this.command.execute(newExecute);
            this.echo(this.endLines);
        }
    }

    class CommentCommand
    extends SimpleCommand {
        public CommentCommand(List<String> lines) {
            super(lines);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
        }
    }

    class ShowCommand
    extends SimpleCommand {
        private final Property property;
        private final String propertyName;

        ShowCommand(List<String> lines, Property property, String propertyName) {
            super(lines);
            this.property = (Property)((Object)Preconditions.checkNotNull((Object)((Object)property)));
            this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName);
            Preconditions.checkArgument((property == Property.OTHER || propertyName.equals(property.propertyName()) ? 1 : 0) != 0);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            Object value = Quidem.this.env.apply((Object)this.propertyName);
            Quidem.this.writer.println(this.propertyName + " " + value);
            this.echo((Iterable<String>)this.lines);
        }
    }

    class PopCommand
    extends SimpleCommand {
        private final Property property;
        private final String propertyName;

        PopCommand(List<String> lines, Property property, String propertyName) {
            super(lines);
            this.property = (Property)((Object)Preconditions.checkNotNull((Object)((Object)property)));
            this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName);
            Preconditions.checkArgument((property == Property.OTHER || propertyName.equals(property.propertyName()) ? 1 : 0) != 0);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            List list = (List)Quidem.this.map.get(this.propertyName);
            if (list == null || list.isEmpty()) {
                Quidem.this.writer.println("Cannot pop " + this.propertyName + ": stack is empty");
            } else {
                list.remove(list.size() - 1);
            }
            Object newValue = Quidem.this.env.apply((Object)this.propertyName);
            Quidem.this.propertyHandler.onSet(this.propertyName, newValue);
        }
    }

    class PushCommand
    extends SetCommand {
        PushCommand(List<String> lines, Property property, String propertyName, Object value) {
            super(lines, property, propertyName, value);
        }
    }

    class SetCommand
    extends SimpleCommand {
        private final Property property;
        private final String propertyName;
        private final Object value;

        SetCommand(List<String> lines, Property property, String propertyName, Object value) {
            super(lines);
            this.property = (Property)((Object)Preconditions.checkNotNull((Object)((Object)property)));
            this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName);
            Preconditions.checkArgument((property == Property.OTHER || propertyName.equals(property.propertyName()) ? 1 : 0) != 0);
            this.value = value;
            Preconditions.checkArgument((value == null || value instanceof Boolean || value instanceof BigDecimal || value instanceof String || value instanceof OutputFormat ? 1 : 0) != 0);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            ArrayList<Object> list = (ArrayList<Object>)Quidem.this.map.get(this.propertyName);
            if (list == null) {
                list = new ArrayList<Object>();
                Quidem.this.map.put(this.propertyName, list);
            }
            if (list.isEmpty() || this instanceof PushCommand) {
                list.add(this.value);
            } else {
                list.set(list.size() - 1, this.value);
            }
            Quidem.this.propertyHandler.onSet(this.propertyName, this.value);
        }
    }

    static enum Property {
        OUTPUTFORMAT,
        OTHER;


        String propertyName() {
            return this.name().toLowerCase();
        }
    }

    @Deprecated
    public static interface NewConnectionFactory
    extends ConnectionFactory {
    }

    public static interface ConnectionFactory {
        public Connection connect(String var1, boolean var2) throws Exception;
    }

    private class SqlCommand
    extends SimpleCommand {
        private final String sql;

        protected SqlCommand(List<String> lines, String sql, List<String> output) {
            super(lines);
            this.sql = (String)Preconditions.checkNotNull((Object)sql);
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
        }
    }

    class TypeCommand
    extends SimpleCommand {
        private final SqlCommand sqlCommand;
        private final ImmutableList<String> content;

        TypeCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> content) {
            super(lines);
            this.sqlCommand = sqlCommand;
            this.content = content;
        }

        public String toString() {
            return "TypeCommand [sql: " + this.sqlCommand.sql + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(boolean execute) throws Exception {
            if (execute) {
                PreparedStatement statement = Quidem.this.connection.prepareStatement(this.sqlCommand.sql);
                try {
                    ResultSetMetaData metaData = statement.getMetaData();
                    StringBuilder buf = new StringBuilder();
                    int n = metaData.getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        int nullable;
                        String label = metaData.getColumnLabel(i);
                        String typeName = metaData.getColumnTypeName(i);
                        buf.append(label).append(' ').append(typeName);
                        int precision = metaData.getPrecision(i);
                        if (precision > 0) {
                            buf.append("(").append(precision);
                            int scale = metaData.getScale(i);
                            if (scale > 0) {
                                buf.append(", ").append(scale);
                            }
                            buf.append(")");
                        }
                        if ((nullable = metaData.isNullable(i)) == 0) {
                            buf.append(" NOT NULL");
                        }
                        buf.append("\n");
                    }
                    Quidem.this.writer.print(buf);
                    Quidem.this.writer.flush();
                }
                finally {
                    statement.close();
                }
            } else {
                this.echo((Iterable<String>)this.content);
            }
            this.echo((Iterable<String>)this.lines);
        }
    }

    class ExplainCommand
    extends SimpleCommand {
        private final SqlCommand sqlCommand;
        private final ImmutableList<String> content;

        ExplainCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> content) {
            super(lines);
            this.sqlCommand = sqlCommand;
            this.content = content;
        }

        public String toString() {
            return "ExplainCommand [sql: " + this.sqlCommand.sql + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(boolean execute) throws Exception {
            block9: {
                if (execute) {
                    Statement statement = Quidem.this.connection.createStatement();
                    try {
                        ResultSet resultSet = statement.executeQuery("explain plan for " + this.sqlCommand.sql);
                        try {
                            StringBuilder buf = new StringBuilder();
                            while (resultSet.next()) {
                                String line = resultSet.getString(1);
                                buf.append(line);
                                if (line.endsWith("\n")) continue;
                                buf.append("\n");
                            }
                            if (buf.length() == 0) {
                                throw new AssertionError((Object)"explain returned 0 records");
                            }
                            Quidem.this.writer.print(buf);
                            Quidem.this.writer.flush();
                            break block9;
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    finally {
                        statement.close();
                    }
                }
                this.echo((Iterable<String>)this.content);
            }
            this.echo((Iterable<String>)this.lines);
        }
    }

    class ErrorCommand
    extends OkCommand {
        ErrorCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> output) {
            super(lines, sqlCommand, output);
        }

        @Override
        protected void checkResultSet(Throwable resultSetException) {
            String expected;
            String actual;
            if (resultSetException == null) {
                Quidem.this.writer.println("Expected error, but SQL command did not give one");
                return;
            }
            if (!this.output.isEmpty() && (actual = this.squash(Quidem.this.stack(resultSetException))).contains(expected = this.squash(this.concat((List<String>)this.output, false)))) {
                for (String line : this.output) {
                    Quidem.this.writer.println(line);
                }
                return;
            }
            super.checkResultSet(resultSetException);
        }

        private String squash(String s) {
            return s.replace("\r\n", "\n").replaceAll("[ \t]+", " ").replaceAll("\n ", "\n").replaceAll("^ ", "").replaceAll(" \n", "\n").replaceAll(" $", "\n");
        }

        private String concat(List<String> lines, boolean trailing) {
            StringBuilder buf = new StringBuilder();
            for (String line : lines) {
                buf.append(line).append("\n");
            }
            if (!trailing && buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            return buf.toString();
        }
    }

    class UpdateCommand
    extends SimpleCommand {
        private final SqlCommand sqlCommand;
        protected final ImmutableList<String> output;

        UpdateCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> output) {
            super(lines);
            this.sqlCommand = sqlCommand;
            this.output = output;
        }

        public String toString() {
            return "UpdateCommand [sql: " + this.sqlCommand.sql + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(boolean execute) throws Exception {
            if (execute) {
                if (Quidem.this.connection == null) {
                    throw new RuntimeException("no connection");
                }
                Statement statement = Quidem.this.connection.createStatement();
                if (Quidem.this.resultSet != null) {
                    Quidem.this.resultSet.close();
                }
                try {
                    if (DEBUG) {
                        System.out.println("execute: " + this);
                    }
                    Quidem.this.resultSet = null;
                    Quidem.this.resultSetException = null;
                    int updateCount = statement.executeUpdate(this.sqlCommand.sql);
                    Quidem.this.writer.println("(" + updateCount + (updateCount == 1 ? " row" : " rows") + " modified)");
                    String sql = this.sqlCommand.sql;
                    Quidem.this.sort = !Quidem.this.isProbablyDeterministic(sql);
                }
                catch (SQLException e) {
                    Quidem.this.resultSetException = e;
                }
                catch (Throwable e) {
                    System.out.println("Warning: JDBC driver threw non-SQLException");
                    Quidem.this.resultSetException = e;
                }
                finally {
                    statement.close();
                }
                this.checkResultSet(Quidem.this.resultSetException);
                Quidem.this.writer.println();
                Quidem.this.resultSet = null;
                Quidem.this.resultSetException = null;
            } else {
                this.echo((Iterable<String>)this.output);
            }
            this.echo((Iterable<String>)this.lines);
        }

        protected void checkResultSet(Throwable resultSetException) {
            if (resultSetException != null) {
                Quidem.this.stack(resultSetException, Quidem.this.writer);
            }
        }
    }

    class VerifyCommand
    extends CheckResultCommand {
        VerifyCommand(List<String> lines, SqlCommand sqlCommand) {
            super(lines, sqlCommand, false);
        }

        public String toString() {
            return "VerifyCommand [sql: " + this.sqlCommand.sql + "]";
        }

        @Override
        protected List<String> getOutput() throws Exception {
            if (Quidem.this.refConnection == null) {
                throw new IllegalArgumentException("no reference connection");
            }
            Statement statement = Quidem.this.refConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.sqlCommand.sql);
            try {
                OutputFormat format = (OutputFormat)((Object)Quidem.this.env.apply((Object)Property.OUTPUTFORMAT.propertyName()));
                ArrayList<String> headerLines = new ArrayList<String>();
                ArrayList<String> bodyLines = new ArrayList<String>();
                ArrayList<String> footerLines = new ArrayList<String>();
                format.format(resultSet, headerLines, bodyLines, footerLines, Quidem.this);
                return ImmutableList.builder().addAll(headerLines).addAll(bodyLines).addAll(footerLines).build();
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("reference threw", e);
            }
        }
    }

    class OkCommand
    extends CheckResultCommand {
        protected final ImmutableList<String> output;

        OkCommand(List<String> lines, SqlCommand sqlCommand, ImmutableList<String> output) {
            super(lines, sqlCommand, true);
            this.output = output;
        }

        public String toString() {
            return "OkCommand [sql: " + this.sqlCommand.sql + "]";
        }

        @Override
        protected List<String> getOutput() {
            return this.output;
        }
    }

    abstract class CheckResultCommand
    extends SimpleCommand {
        protected final SqlCommand sqlCommand;
        protected final boolean output;

        CheckResultCommand(List<String> lines, SqlCommand sqlCommand, boolean output) {
            super(lines);
            this.sqlCommand = sqlCommand;
            this.output = output;
        }

        protected abstract List<String> getOutput() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(boolean execute) throws Exception {
            if (execute) {
                if (Quidem.this.connection == null) {
                    throw new RuntimeException("no connection");
                }
                Statement statement = Quidem.this.connection.createStatement();
                if (Quidem.this.resultSet != null) {
                    Quidem.this.resultSet.close();
                }
                try {
                    try {
                        if (DEBUG) {
                            System.out.println("execute: " + this);
                        }
                        Quidem.this.resultSet = null;
                        Quidem.this.resultSetException = null;
                        Quidem.this.resultSet = statement.executeQuery(this.sqlCommand.sql);
                        String sql = this.sqlCommand.sql;
                        Quidem.this.sort = !Quidem.this.isProbablyDeterministic(sql);
                    }
                    catch (SQLException e) {
                        Quidem.this.resultSetException = e;
                    }
                    catch (Throwable e) {
                        System.out.println("Warning: JDBC driver threw non-SQLException");
                        Quidem.this.resultSetException = e;
                    }
                    if (Quidem.this.resultSet != null) {
                        OutputFormat format = (OutputFormat)((Object)Quidem.this.env.apply((Object)Property.OUTPUTFORMAT.propertyName()));
                        ArrayList<String> headerLines = new ArrayList<String>();
                        ArrayList<String> bodyLines = new ArrayList<String>();
                        ArrayList<String> footerLines = new ArrayList<String>();
                        format.format(Quidem.this.resultSet, headerLines, bodyLines, footerLines, Quidem.this);
                        List<String> expectedLines = this.getOutput();
                        ArrayList<String> lines = new ArrayList<String>(expectedLines);
                        ImmutableList actualLines = ImmutableList.builder().addAll(headerLines).addAll(bodyLines).addAll(footerLines).build();
                        for (String line : headerLines) {
                            if (lines.isEmpty()) continue;
                            lines.remove(0);
                        }
                        for (String line : footerLines) {
                            if (lines.isEmpty()) continue;
                            lines.remove(lines.size() - 1);
                        }
                        for (String line : headerLines) {
                            if (!this.output) continue;
                            Quidem.this.writer.println(line);
                        }
                        for (String line : lines) {
                            if (Quidem.this.sort) {
                                if (!bodyLines.remove(line) || !this.output) continue;
                                Quidem.this.writer.println(line);
                                continue;
                            }
                            if (bodyLines.isEmpty() || !((String)bodyLines.get(0)).equals(line)) continue;
                            bodyLines.remove(0);
                            if (!this.output) continue;
                            Quidem.this.writer.println(line);
                        }
                        for (String line : bodyLines) {
                            if (!this.output) continue;
                            Quidem.this.writer.println(line);
                        }
                        for (String line : footerLines) {
                            if (!this.output) continue;
                            Quidem.this.writer.println(line);
                        }
                        Quidem.this.resultSet.close();
                        if (!this.output && !actualLines.equals(expectedLines)) {
                            StringWriter buf = new StringWriter();
                            PrintWriter w = new PrintWriter(buf);
                            w.println("Reference query returned different results.");
                            w.println("expected:");
                            for (String line : expectedLines) {
                                w.println(line);
                            }
                            w.println("actual:");
                            for (String line : actualLines) {
                                w.println(line);
                            }
                            w.close();
                            throw new IllegalArgumentException(buf.toString());
                        }
                    }
                    this.checkResultSet(Quidem.this.resultSetException);
                    if (Quidem.this.resultSet == null && Quidem.this.resultSetException == null) {
                        throw new AssertionError((Object)"neither resultSet nor exception set");
                    }
                    Quidem.this.resultSet = null;
                    Quidem.this.resultSetException = null;
                }
                finally {
                    statement.close();
                }
            }
            if (this.output) {
                this.echo(this.getOutput());
            }
            this.echo((Iterable<String>)this.lines);
        }

        protected void checkResultSet(Throwable resultSetException) {
            if (resultSetException != null) {
                Quidem.this.stack(resultSetException, Quidem.this.writer);
            }
        }
    }

    class UseCommand
    extends SimpleCommand {
        private final String name;

        UseCommand(List<String> lines, String name) {
            super(lines);
            this.name = name;
        }

        @Override
        public void execute(boolean execute) throws Exception {
            this.echo((Iterable<String>)this.lines);
            if (Quidem.this.connection != null) {
                Quidem.this.connection.close();
            }
            if (Quidem.this.refConnection != null) {
                Quidem.this.refConnection.close();
            }
            Quidem.this.connection = Quidem.this.connectionFactory.connect(this.name, false);
            Quidem.this.refConnection = Quidem.this.connectionFactory.connect(this.name, true);
        }
    }

    abstract class SimpleCommand
    extends AbstractCommand {
        protected final ImmutableList<String> lines;

        SimpleCommand(List<String> lines) {
            this.lines = ImmutableList.copyOf(lines);
        }
    }

    abstract class AbstractCommand
    implements Command {
        AbstractCommand() {
        }

        protected Command echo(Iterable<String> lines) {
            for (String line : lines) {
                try {
                    Quidem.this.writer.println(line);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while writing output", e);
                }
            }
            return this;
        }
    }

    static interface Command {
        public void execute(boolean var1) throws Exception;
    }

    static enum OutputFormat {
        CSV{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, Quidem run) throws Exception {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int n = metaData.getColumnCount();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(metaData.getColumnLabel(i + 1));
                }
                headerLines.add(buf.toString());
                buf.setLength(0);
                ArrayList lines = Lists.newArrayList();
                while (resultSet.next()) {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(resultSet.getString(i + 1));
                    }
                    lines.add(buf.toString());
                    buf.setLength(0);
                }
                if (run.sort) {
                    Collections.sort(lines);
                }
                bodyLines.addAll(lines);
            }
        }
        ,
        PSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, Quidem run) throws Exception {
                Quidem.format(resultSet, headerLines, bodyLines, footerLines, run.sort, false);
            }
        }
        ,
        MYSQL{

            @Override
            public void format(ResultSet resultSet, List<String> headerLines, List<String> bodyLines, List<String> footerLines, Quidem run) throws Exception {
                Quidem.format(resultSet, headerLines, bodyLines, footerLines, run.sort, true);
            }
        };


        public abstract void format(ResultSet var1, List<String> var2, List<String> var3, List<String> var4, Quidem var5) throws Exception;
    }

    private class Parser {
        final List<Command> commands = new ArrayList<Command>();

        private Parser() {
        }

        Command parse() {
            while (true) {
                Command command;
                try {
                    command = this.nextCommand();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading next command", e);
                }
                if (command == null) break;
                this.commands.add(command);
            }
            return Quidem.this.of(this.commands);
        }

        private Command nextCommand() throws IOException {
            boolean last;
            Quidem.this.lines.clear();
            ImmutableList content = ImmutableList.of();
            do {
                block22: {
                    String line;
                    if ((line = this.nextLine()) == null) {
                        return null;
                    }
                    if (line.startsWith("#") || line.isEmpty()) {
                        return new CommentCommand(Quidem.this.lines);
                    }
                    if (line.startsWith("!")) {
                        line = line.substring(1);
                        while (line.startsWith(" ")) {
                            line = line.substring(1);
                        }
                        if (line.startsWith("use")) {
                            String[] parts = line.split(" ");
                            return new UseCommand(Quidem.this.lines, parts[1]);
                        }
                        if (line.startsWith("ok")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new OkCommand((List<String>)Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("verify")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new VerifyCommand(Quidem.this.lines, command);
                        }
                        if (line.startsWith("update")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new UpdateCommand(Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("plan")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new ExplainCommand(Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("type")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new TypeCommand(Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("error")) {
                            SqlCommand command = this.previousSqlCommand();
                            return new ErrorCommand((List<String>)Quidem.this.lines, command, (ImmutableList<String>)content);
                        }
                        if (line.startsWith("skip")) {
                            return new SkipCommand(Quidem.this.lines);
                        }
                        if (line.startsWith("pop")) {
                            String[] parts = line.split(" ");
                            String propertyName = parts[1];
                            Property property = propertyName.equals("outputformat") ? Property.OUTPUTFORMAT : Property.OTHER;
                            return new PopCommand(Quidem.this.lines, property, propertyName);
                        }
                        if (line.startsWith("set ") || line.startsWith("push ")) {
                            Object value;
                            Property property;
                            String[] parts = line.split(" ");
                            String propertyName = parts[1];
                            String valueString = parts[2];
                            if (propertyName.equals("outputformat")) {
                                property = Property.OUTPUTFORMAT;
                                value = OutputFormat.valueOf(parts[2].toUpperCase());
                            } else {
                                property = Property.OTHER;
                                value = valueString.equals("null") ? null : (valueString.equals("true") ? Boolean.TRUE : (valueString.equals("false") ? Boolean.FALSE : (valueString.matches("-?[0-9]+") ? new BigDecimal(valueString) : valueString)));
                            }
                            return line.startsWith("push ") ? new PushCommand(Quidem.this.lines, property, propertyName, value) : new SetCommand(Quidem.this.lines, property, propertyName, value);
                        }
                        if (line.startsWith("show ")) {
                            String[] parts = line.split(" ");
                            String propertyName = parts[1];
                            Property property = propertyName.equals("outputformat") ? Property.OUTPUTFORMAT : Property.OTHER;
                            return new ShowCommand(Quidem.this.lines, property, propertyName);
                        }
                        if (line.matches("if \\([A-Za-z-][A-Za-z_0-9.]*\\) \\{")) {
                            ImmutableList ifLines = ImmutableList.copyOf((Collection)Quidem.this.lines);
                            Quidem.this.lines.clear();
                            Command command = new Parser().parse();
                            String variable = line.substring("if (".length(), line.length() - ") {".length());
                            ImmutableList variables = ImmutableList.copyOf(Quidem.this.stringIterator(new StringTokenizer(variable, ".")));
                            return new IfCommand((List<String>)ifLines, Quidem.this.lines, command, (List<String>)variables);
                        }
                        if (line.equals("}")) {
                            return null;
                        }
                        throw new RuntimeException("Unknown command: " + line);
                    }
                    Quidem.this.buf.setLength(0);
                    last = false;
                    do {
                        if (line.endsWith(";")) {
                            last = true;
                            line = line.substring(0, line.length() - 1);
                        }
                        Quidem.this.buf.append(line).append("\n");
                        if (last) break block22;
                        line = this.nextLine();
                        if (line != null) continue;
                        throw new RuntimeException("end of file reached before end of SQL command");
                    } while (!line.startsWith("!") && !line.startsWith("#"));
                    this.pushLine();
                }
                content = ImmutableList.copyOf((Collection)Quidem.this.lines);
                Quidem.this.lines.clear();
            } while (!last);
            String sql = Quidem.this.buf.toString();
            return new SqlCommand((List<String>)content, sql, null);
        }

        private SqlCommand previousSqlCommand() {
            for (int i = this.commands.size() - 1; i >= 0; --i) {
                Command command = this.commands.get(i);
                if (!(command instanceof SqlCommand)) continue;
                return (SqlCommand)command;
            }
            throw new AssertionError((Object)"no previous SQL command");
        }

        private void pushLine() {
            if (Quidem.this.pushedLine != null) {
                throw new AssertionError((Object)"cannot push two lines");
            }
            if (Quidem.this.lines.size() == 0) {
                throw new AssertionError((Object)"no line has been read");
            }
            Quidem.this.pushedLine = (String)Quidem.this.lines.get(Quidem.this.lines.size() - 1);
            Quidem.this.lines.remove(Quidem.this.lines.size() - 1);
        }

        private String nextLine() throws IOException {
            String line;
            if (Quidem.this.pushedLine != null) {
                line = Quidem.this.pushedLine;
                Quidem.this.pushedLine = null;
            } else {
                line = Quidem.this.reader.readLine();
                if (line == null) {
                    return null;
                }
            }
            Quidem.this.lines.add(line);
            return line;
        }
    }
}

