/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.scott.data.hsqldb;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

class CompositeIterator<E>
implements Iterator<E> {
    private final Iterator<Iterable<E>> iterableIterator;
    private Iterator<E> iterator;
    private E next;

    private CompositeIterator(Iterable<Iterable<E>> iterableIterator) {
        this.iterableIterator = iterableIterator.iterator();
        this.advance();
    }

    @SafeVarargs
    static <E> Iterable<E> concat(Iterable<E> ... iterables) {
        return () -> new CompositeIterator(Arrays.asList(iterables));
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.advance();
        return result;
    }

    private void advance() {
        this.next = null;
        while (this.next == null) {
            if (this.iterator != null && this.iterator.hasNext()) {
                this.next = this.iterator.next();
                return;
            }
            if (!this.iterableIterator.hasNext()) {
                return;
            }
            this.iterator = this.iterableIterator.next().iterator();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

