/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.scott.data.hsqldb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class StatementGenerator
implements Iterator<String> {
    private final String tableName;
    private final BufferedReader reader;
    private final List<String> columnNames;
    private final List<String> quotedColumnNames;
    private String nextStatement;

    StatementGenerator(Class<?> resourceClass, String tableName, String[] quotedColumnNames) {
        this.tableName = tableName;
        this.quotedColumnNames = Arrays.asList(quotedColumnNames);
        String csvPath = "/csv/" + tableName.toLowerCase() + ".csv";
        try {
            InputStream is = resourceClass.getResourceAsStream(csvPath);
            if (is == null) {
                throw new RuntimeException("CSV file not found: " + csvPath);
            }
            this.reader = new BufferedReader(new InputStreamReader(is));
            String headerLine = this.reader.readLine();
            this.columnNames = StatementGenerator.parseCsvLine(headerLine);
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read CSV file: " + csvPath, e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextStatement != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String result = this.nextStatement;
        this.advance();
        return result;
    }

    private void advance() {
        this.nextStatement = null;
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                this.nextStatement = this.generateInsertStatement(line);
                return;
            }
            this.reader.close();
        }
        catch (IOException e) {
            this.closeReader();
            throw new RuntimeException("Error reading CSV file", e);
        }
    }

    private String generateInsertStatement(String line) {
        StringBuilder insert = new StringBuilder("INSERT INTO \"");
        insert.append(this.tableName).append("\" VALUES(");
        List<String> values = StatementGenerator.parseCsvLine(line);
        for (int i = 0; i < values.size(); ++i) {
            String value;
            if (i > 0) {
                insert.append(",");
            }
            if ((value = values.get(i)).isEmpty()) {
                insert.append("NULL");
                continue;
            }
            if (this.quotedColumnNames.contains(this.columnNames.get(i))) {
                insert.append("'").append(value.replace("'", "''")).append("'");
                continue;
            }
            insert.append(value);
        }
        insert.append(")");
        return insert.toString();
    }

    private void closeReader() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static List<String> parseCsvLine(String line) {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ',' && !inQuotes) {
                values.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        values.add(current.toString());
        return values;
    }
}

