/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.hydromatic.sqllogictest.executors.SqlSltTestExecutor;
import net.hydromatic.sqllogictest.util.Utilities;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExecutionOptions {
    final Map<String, OptionDescription> knownOptions;
    final List<String> optionOrder;
    public final PrintStream out;
    public final PrintStream err;
    String binaryName;
    final List<String> directories;
    final Map<String, Supplier<SqlSltTestExecutor>> executorFactories;
    final boolean exit;
    public boolean stopAtFirstError = false;
    public boolean doNotExecute = false;
    public String executor = "";
    public String bugsFile = "";
    public int verbosity = 0;

    public Set<String> readBugsFile() throws IOException {
        HashSet<String> bugs = new HashSet<String>();
        if (this.bugsFile.isEmpty()) {
            return bugs;
        }
        File file = new File(this.bugsFile);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//")) continue;
                bugs.add(line);
            }
        }
        return bugs;
    }

    void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
    }

    int abort(boolean abort, @Nullable String message) {
        if (message != null) {
            this.err.println(message);
        }
        this.usage();
        if (abort) {
            System.exit(1);
        }
        return 1;
    }

    private int abort(@Nullable String message) {
        return this.abort(this.exit, message);
    }

    public List<String> getDirectories() {
        if (this.directories.isEmpty()) {
            this.directories.add(".");
        }
        return this.directories;
    }

    public ExecutionOptions(boolean exit, PrintStream out, PrintStream err) {
        this.exit = exit;
        this.out = out;
        this.err = err;
        this.knownOptions = new HashMap<String, OptionDescription>();
        this.binaryName = "";
        this.optionOrder = new ArrayList<String>();
        this.directories = new ArrayList<String>();
        this.executorFactories = new HashMap<String, Supplier<SqlSltTestExecutor>>();
        this.registerDefaultOptions();
    }

    boolean setExecutor(String executor) {
        if (!this.executor.isEmpty()) {
            this.err.println("Executor already set to " + this.executor);
            return false;
        }
        this.executor = executor;
        return true;
    }

    boolean setBugsFile(String filename) {
        if (!this.bugsFile.isEmpty()) {
            this.err.println("Bugs file already set to " + this.bugsFile);
            return false;
        }
        this.bugsFile = filename;
        return true;
    }

    void registerDefaultOptions() {
        this.registerOption("-h", null, "Show this help message and exit", o -> false);
        this.registerOption("-x", null, "Stop at the first encountered query error", o -> {
            this.stopAtFirstError = true;
            return true;
        });
        this.registerOption("-n", null, "Do not execute, just parse the test files", o -> {
            this.doNotExecute = true;
            return true;
        });
        this.registerOption("-e", "executor", "Executor to use", this::setExecutor);
        this.registerOption("-b", "filename", "Load a list of buggy commands to skip from this file", this::setBugsFile);
        this.registerOption("-v", null, "Increase verbosity", o -> {
            ++this.verbosity;
            return true;
        });
    }

    public void registerExecutor(String executorName, Supplier<SqlSltTestExecutor> executor) {
        if (this.executorFactories.containsKey(executorName)) {
            throw new RuntimeException("Executor for " + Utilities.singleQuote(executorName) + " already registered");
        }
        this.executorFactories.put(executorName, executor);
    }

    public @Nullable SqlSltTestExecutor getExecutor() {
        if (this.executor == null || this.executor.isEmpty()) {
            this.abort("Please supply an executor name using the -e flag");
            return null;
        }
        Supplier<SqlSltTestExecutor> supplier = this.executorFactories.get(this.executor);
        if (supplier == null) {
            this.err.println("Executor for " + Utilities.singleQuote(this.executor) + " not registered using 'registerExecutor");
            this.err.println("Registered executors:");
            for (String s : this.executorFactories.keySet()) {
                this.err.println("\t" + s);
            }
            this.abort(null);
            return null;
        }
        return supplier.get();
    }

    public void registerOption(String option, @Nullable String argName, String description, Function<String, Boolean> optionArgProcessor) {
        OptionDescription o = new OptionDescription(option, argName, description, optionArgProcessor);
        if (this.knownOptions.containsKey(option)) {
            this.error("Option " + Utilities.singleQuote(option) + " already registered");
            return;
        }
        this.optionOrder.add(option);
        this.knownOptions.put(option, o);
    }

    void error(String message) {
        this.err.println(message);
    }

    public void error(Throwable ex) {
        this.err.println("EXCEPTION: " + ex.getMessage());
    }

    public void message(String message, int importance) {
        if (this.verbosity >= importance) {
            this.out.println(message);
        }
    }

    int parse(String ... argv) {
        if (argv.length == 0) {
            return this.abort("No arguments to process");
        }
        for (int i = 0; i < argv.length; ++i) {
            boolean success;
            String opt = argv[i];
            String arg = null;
            OptionDescription option = null;
            if (opt.startsWith("--")) {
                option = this.knownOptions.get(opt);
                if (option == null) {
                    return this.abort("Unknown option " + Utilities.singleQuote(opt));
                }
            } else if (opt.startsWith("-")) {
                option = this.knownOptions.get(opt);
                if (option == null && opt.length() > 2) {
                    arg = opt.substring(2);
                    opt = opt.substring(0, 2);
                    option = this.knownOptions.get(opt);
                }
                if (option == null) {
                    return this.abort("Unknown option " + Utilities.singleQuote(opt));
                }
            }
            if (option == null) {
                this.directories.add(opt);
                continue;
            }
            if (option.argName != null && arg == null) {
                if (i == argv.length - 1) {
                    return this.abort("Option " + Utilities.singleQuote(opt) + " is missing required argument " + option.argName);
                }
                arg = argv[++i];
            }
            if (success = option.optionArgProcessor.apply(arg).booleanValue()) continue;
            return this.abort(null);
        }
        return 0;
    }

    void usage() {
        this.out.println(this.binaryName + " [options] files_or_directories_with_tests");
        this.out.println("Executes the SQL Logic Tests using a SQL execution engine");
        this.out.println("See https://www.sqlite.org/sqllogictest/doc/trunk/about.wiki");
        this.out.println("Options:");
        int labelLen = 0;
        for (String o : this.optionOrder) {
            int len = o.length();
            OptionDescription option = this.knownOptions.get(o);
            if (option.argName != null) {
                len += 1 + option.argName.length();
            }
            if (labelLen >= len) continue;
            labelLen = len;
        }
        labelLen += 3;
        for (String o : this.optionOrder) {
            OptionDescription option = this.knownOptions.get(o);
            int len = o.length();
            this.out.print(option.option);
            if (option.argName != null) {
                this.out.print(" " + option.argName);
                len += 1 + option.argName.length();
            }
            for (String line : option.description.split("\n")) {
                for (int i = 0; i < labelLen - len; ++i) {
                    this.out.print(" ");
                }
                this.out.println(line);
                len = 0;
            }
        }
        this.out.println("Registered executors:");
        for (String e : this.executorFactories.keySet()) {
            this.out.println("\t" + e);
        }
    }

    public String toString() {
        return "ExecutionOptions{tests=" + this.directories + ", execute=" + !this.doNotExecute + ", executor=" + this.executor + ", stopAtFirstError=" + this.stopAtFirstError + '}';
    }

    static class OptionDescription {
        final String option;
        final @Nullable String argName;
        final String description;
        final Function<String, Boolean> optionArgProcessor;

        OptionDescription(String option, @Nullable String argName, String description, Function<String, Boolean> optionArgProcessor) {
            this.option = option;
            this.argName = argName;
            this.description = description;
            this.optionArgProcessor = optionArgProcessor;
        }
    }
}

