/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.hydromatic.sqllogictest.ExecutionOptions;
import net.hydromatic.sqllogictest.TestLoader;
import net.hydromatic.sqllogictest.executors.HsqldbExecutor;
import net.hydromatic.sqllogictest.executors.NoExecutor;
import net.hydromatic.sqllogictest.executors.PostgresExecutor;

public class Main {
    private Main() {
    }

    public static void main(String[] argv) throws IOException {
        Main.execute(true, System.out, System.err, argv);
    }

    public static int execute(boolean exit, PrintStream out, PrintStream err, String ... argv) throws IOException {
        ExecutionOptions options = new ExecutionOptions(exit, out, err);
        options.setBinaryName("slt");
        NoExecutor.Factory.INSTANCE.register(options);
        HsqldbExecutor.Factory.INSTANCE.register(options);
        PostgresExecutor.Factory.INSTANCE.register(options);
        int parse = options.parse(argv);
        if (parse != 0) {
            return parse;
        }
        URL r = Thread.currentThread().getContextClassLoader().getResource("test");
        if (r == null) {
            out.println("Cannot find resources");
            return 1;
        }
        TestLoader loader = new TestLoader(options);
        for (String file : options.getDirectories()) {
            Path path = Paths.get(r.getPath(), file);
            Files.walkFileTree(path, loader);
        }
        out.println("Files that could not be not parsed: " + loader.errors);
        loader.statistics.printStatistics(out);
        return 0;
    }
}

