/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.sqllogictest.ExecutionOptions;
import net.hydromatic.sqllogictest.SltSqlStatement;
import net.hydromatic.sqllogictest.SqlTestQuery;
import net.hydromatic.sqllogictest.executors.ISqlTestOperation;
import net.hydromatic.sqllogictest.util.Utilities;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SltTestFile {
    private int lineno;
    public final List<ISqlTestOperation> fileContents;
    private final BufferedReader reader;
    private @Nullable String nextLine;
    private final String testFile;
    private boolean done;
    private int testCount;

    public SltTestFile(String testFile) throws IOException {
        File file = new File(testFile);
        this.reader = new BufferedReader(new FileReader(file));
        this.fileContents = new ArrayList<ISqlTestOperation>();
        this.lineno = 0;
        this.testFile = testFile;
        this.done = false;
        this.testCount = 0;
    }

    void error(String message) {
        throw new RuntimeException("File " + this.testFile + "\nError at line " + this.lineno + ": " + message);
    }

    private void undoRead(String line) {
        if (this.nextLine != null) {
            throw new RuntimeException("Only one undoRead allowed");
        }
        this.nextLine = line;
    }

    String getNextLine(boolean nullOk) throws IOException {
        String line;
        if (this.nextLine != null) {
            line = this.nextLine;
            this.nextLine = null;
        } else {
            ++this.lineno;
            line = this.reader.readLine();
            if (!nullOk && line == null) {
                this.error("Test file ends prematurely");
            }
            if (line == null) {
                this.done = true;
                line = "";
            }
        }
        return line.trim();
    }

    String nextLine(boolean nullOk) throws IOException {
        String line;
        int sharp;
        do {
            line = this.getNextLine(nullOk);
            if (this.done) {
                return line;
            }
            sharp = line.indexOf("#");
            if (sharp <= 0) continue;
            return line.substring(0, sharp - 1);
        } while (sharp >= 0);
        return line;
    }

    private @Nullable SqlTestQuery parseTestQuery() throws IOException {
        @Nullable String line = this.nextLine(true);
        if (this.done) {
            return null;
        }
        assert (line != null);
        while (line.isEmpty()) {
            line = this.nextLine(false);
        }
        if (!line.startsWith("query")) {
            this.error("Unexpected line: " + Utilities.singleQuote(line));
        }
        @Nullable SqlTestQuery result = new SqlTestQuery(this.testFile);
        if ((line = line.substring("query".length()).trim()).isEmpty()) {
            this.error("Malformed query description " + line);
        }
        if ((line = result.outputDescription.parseType(line)) == null) {
            this.error("Could not parse output column types");
        }
        assert (line != null);
        if ((line = line.trim()).isEmpty()) {
            this.error("Malformed query description " + line);
        }
        if ((line = result.outputDescription.parseOrder(line)) == null) {
            this.error("Did not understand sort order");
        }
        assert (line != null);
        if (!(line = line.trim()).isEmpty()) {
            result.setName(line);
        }
        line = this.nextLine(false);
        StringBuilder query = new StringBuilder();
        if (!this.done) {
            while (!this.done && !line.startsWith("----")) {
                query.append(" ");
                query.append(line);
                line = this.nextLine(true);
            }
        }
        String q = query.toString().trim();
        result.setQuery(q, this.lineno);
        String vht = "values hashing to";
        if (!this.done) {
            line = this.nextLine(true);
            if (!this.done) {
                if (line.contains("values hashing to")) {
                    int vi = line.indexOf("values hashing to");
                    String number = line.substring(0, vi - 1);
                    int values = Integer.parseInt(number);
                    result.outputDescription.setValueCount(values);
                    line = line.substring(vi + "values hashing to".length()).trim();
                    result.outputDescription.setHash(line);
                    line = this.nextLine(true);
                    if (!this.done && !line.isEmpty()) {
                        this.error("Expected an empty line between tests: " + Utilities.singleQuote(line));
                    }
                } else {
                    result.outputDescription.clearResults();
                    while (!line.isEmpty()) {
                        result.outputDescription.addResultLine(line);
                        line = this.getNextLine(true);
                    }
                }
            } else {
                result.outputDescription.clearResults();
            }
        }
        return result;
    }

    public void parse(ExecutionOptions options) throws IOException {
        PostgresPolicy policy = new PostgresPolicy();
        while (!this.done) {
            String line = this.nextLine(true);
            if (this.done) {
                return;
            }
            if (line.isEmpty() || line.startsWith("hash-threshold")) continue;
            ArrayList<String> skip = new ArrayList<String>();
            ArrayList<String> only = new ArrayList<String>();
            while (line.startsWith("onlyif") || line.startsWith("skipif")) {
                boolean sk = line.startsWith("skipif");
                String cond = line.substring("onlyif".length()).trim();
                if (sk) {
                    skip.add(cond);
                } else {
                    only.add(cond);
                }
                line = this.nextLine(false);
            }
            if (line.startsWith("halt")) {
                if (!policy.accept(skip, only)) continue;
                break;
            }
            if (line.startsWith("statement")) {
                boolean ok = line.startsWith("statement ok");
                line = this.nextLine(false);
                StringBuilder statement = new StringBuilder();
                while (!this.done && !line.isEmpty()) {
                    statement.append(line);
                    line = this.nextLine(true);
                }
                String command = statement.toString();
                SltSqlStatement stat = new SltSqlStatement(command, ok);
                if (!policy.accept(skip, only)) continue;
                this.add(stat, options);
                continue;
            }
            this.undoRead(line);
            SqlTestQuery test = this.parseTestQuery();
            if (test == null || !policy.accept(skip, only)) continue;
            this.add(test, options);
        }
    }

    private void add(ISqlTestOperation operation, ExecutionOptions options) {
        options.message("Operation added " + operation.toString(), 2);
        this.fileContents.add(operation);
        if (operation.is(SqlTestQuery.class)) {
            ++this.testCount;
        }
    }

    public int getTestCount() {
        return this.testCount;
    }

    public String toString() {
        return this.testFile;
    }

    static class PostgresPolicy {
        PostgresPolicy() {
        }

        public boolean accept(List<String> skip, List<String> only) {
            if (only.contains("postgresql")) {
                return true;
            }
            if (!only.isEmpty()) {
                return false;
            }
            return !skip.contains("postgresql");
        }
    }
}

