/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import net.hydromatic.sqllogictest.ExecutionOptions;
import net.hydromatic.sqllogictest.SltTestFile;
import net.hydromatic.sqllogictest.TestStatistics;
import net.hydromatic.sqllogictest.executors.SqlSltTestExecutor;
import net.hydromatic.sqllogictest.util.Utilities;

class TestLoader
extends SimpleFileVisitor<Path> {
    int errors = 0;
    final TestStatistics statistics;
    public final ExecutionOptions options;

    TestLoader(ExecutionOptions options) {
        this.statistics = new TestStatistics(options.stopAtFirstError);
        this.options = options;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        SqlSltTestExecutor executor = this.options.getExecutor();
        if (executor == null) {
            return FileVisitResult.TERMINATE;
        }
        String extension = Utilities.getFileExtension(file.toString());
        if (attrs.isRegularFile() && extension != null && extension.equals("test")) {
            SltTestFile test = null;
            try {
                this.options.message("Running " + file, 1);
                test = new SltTestFile(file.toString());
                test.parse(this.options);
            }
            catch (Exception ex) {
                this.options.err.println("Error while executing test " + file + ": " + ex.getMessage());
                ++this.errors;
            }
            if (test != null) {
                try {
                    TestStatistics stats = executor.execute(test, this.options);
                    if (!stats.failures.isEmpty() && this.options.verbosity > 0) {
                        this.options.out.println(stats.failed + " failures");
                    }
                    this.statistics.add(stats);
                    if (this.statistics.stopAtFirstErrror && !this.statistics.failures.isEmpty()) {
                        return FileVisitResult.TERMINATE;
                    }
                }
                catch (NoSuchAlgorithmException | SQLException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

