/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.executors;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.hydromatic.sqllogictest.ExecutionOptions;
import net.hydromatic.sqllogictest.executors.ExecutorFactory;
import net.hydromatic.sqllogictest.executors.JdbcExecutor;

public class HsqldbExecutor
extends JdbcExecutor {
    private static final AtomicLong HSQLDB_CONNECTION_ID = new AtomicLong(0L);

    public HsqldbExecutor(ExecutionOptions options) {
        super(options, "jdbc:hsqldb:mem:db" + HSQLDB_CONNECTION_ID.getAndIncrement(), "", "");
    }

    @Override
    List<String> getTableList() throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        assert (this.connection != null);
        DatabaseMetaData md = this.connection.getMetaData();
        ResultSet rs = md.getTables(null, null, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString(3);
            if (tableName.equals("PUBLIC")) continue;
            result.add(tableName);
        }
        rs.close();
        return result;
    }

    @Override
    List<String> getViewList() throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        assert (this.connection != null);
        DatabaseMetaData md = this.connection.getMetaData();
        ResultSet rs = md.getTables(null, null, "%", new String[]{"VIEW"});
        while (rs.next()) {
            String tableName = rs.getString(3);
            result.add(tableName);
        }
        rs.close();
        return result;
    }

    @Override
    public void establishConnection() throws SQLException {
        super.establishConnection();
        assert (this.connection != null);
        try (Statement statement = this.connection.createStatement();){
            statement.execute("SET DATABASE SQL SYNTAX PGS TRUE");
        }
    }

    public static class Factory
    extends ExecutorFactory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public void register(ExecutionOptions options) {
            options.registerExecutor("hsql", () -> {
                HsqldbExecutor result = new HsqldbExecutor(options);
                try {
                    Set<String> bugs = options.readBugsFile();
                    result.avoid(bugs);
                    return result;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

