/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest.executors;

import net.hydromatic.sqllogictest.ExecutionOptions;
import net.hydromatic.sqllogictest.SltTestFile;
import net.hydromatic.sqllogictest.TestStatistics;
import net.hydromatic.sqllogictest.executors.ExecutorFactory;
import net.hydromatic.sqllogictest.executors.SqlSltTestExecutor;

public class NoExecutor
extends SqlSltTestExecutor {
    NoExecutor(ExecutionOptions options) {
        super(options);
    }

    @Override
    public TestStatistics execute(SltTestFile testFile, ExecutionOptions options) {
        TestStatistics result = new TestStatistics(options.stopAtFirstError);
        this.startTest();
        result.setFailed(0);
        result.setIgnored(testFile.getTestCount());
        result.setPassed(0);
        options.message(this.elapsedTime(testFile.getTestCount()), 1);
        return result;
    }

    public static class Factory
    extends ExecutorFactory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public void register(ExecutionOptions execOptions) {
            execOptions.registerExecutor("none", () -> new NoExecutor(execOptions));
        }
    }
}

