/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.sqllogictest;

import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import net.hydromatic.sqllogictest.OptionsParser;
import net.hydromatic.sqllogictest.SltTestFile;
import net.hydromatic.sqllogictest.TestStatistics;
import net.hydromatic.sqllogictest.executors.SqlSltTestExecutor;

public class TestLoader {
    public final TestStatistics statistics;
    public final OptionsParser.SuppliedOptions options;

    public TestLoader(OptionsParser.SuppliedOptions options) {
        this.statistics = new TestStatistics(options.stopAtFirstError, options.verbosity);
        this.options = options;
    }

    public boolean visitFile(String file) {
        SqlSltTestExecutor executor = this.options.getExecutor();
        if (executor == null) {
            return false;
        }
        SltTestFile test = null;
        try {
            this.options.message("Running " + file, 1);
            test = new SltTestFile(file);
            test.parse(this.options);
        }
        catch (Exception ex) {
            this.options.err.println("Error while executing test " + file + ": " + ex.getMessage());
            this.statistics.incFilesNotParsed();
        }
        if (test != null) {
            try {
                TestStatistics stats = executor.execute(test, this.options);
                if (!stats.failures.isEmpty() && this.options.verbosity > 0) {
                    this.options.out.println(stats.getFailedTestCount() + " failures");
                }
                this.statistics.add(stats);
                if (this.statistics.stopAtFirstErrror && !this.statistics.failures.isEmpty()) {
                    return false;
                }
            }
            catch (NoSuchAlgorithmException | SQLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return true;
    }
}

