/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.toolbox.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.util.List;

public class HydromaticFileSetCheck
extends AbstractFileSetCheck {
    boolean isProto(File file) {
        return file.getAbsolutePath().contains("/proto/") || file.getName().endsWith("Base64.java");
    }

    static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    void afterFile(File file, List<String> lines) {
        if (file.getName().matches(".*\\.java$")) {
            String b = file.getName().replaceAll(".*/", "");
            String line = "// End " + b;
            if (!HydromaticFileSetCheck.last(lines).equals(line) && !this.isProto(file)) {
                this.log(lines.size(), "Last line should be ''{0}''", new Object[]{line});
            }
        }
    }

    protected void processFiltered(File file, List<String> list) {
        try {
            this.processFiltered2(file, list);
        }
        catch (StackOverflowError e) {
            System.out.println(file);
            throw e;
        }
    }

    protected void processFiltered2(File file, List<String> list) {
        boolean off = false;
        int endCount = 0;
        int maxLineLength = 80;
        if (file.getAbsolutePath().matches(".*/calcite/.*")) {
            maxLineLength = 100;
        }
        int i = 0;
        for (String line : list) {
            String s;
            ++i;
            if (line.contains("\t")) {
                this.log(i, "Tab", new Object[0]);
            }
            if (line.contains("CHECKSTYLE: ON")) {
                off = false;
            }
            if (line.contains("CHECKSTYLE: OFF")) {
                off = true;
            }
            if (off) continue;
            if (line.startsWith("// End ") && endCount++ > 0) {
                this.log(i, "End seen more than once", new Object[0]);
            }
            if (line.matches(".*\\\\n\".*")) {
                this.log(i, "Newline in string should be at end of line", new Object[0]);
            }
            if (line.contains("{@link") && !line.contains("}")) {
                this.log(i, "Split @link", new Object[0]);
            }
            if (line.endsWith("@Override")) {
                this.log(i, "@Override should not be on its own line", new Object[0]);
            }
            if (line.endsWith("<p>") && !this.isProto(file)) {
                this.log(i, "Orphan <p>. Make it the first line of a paragraph", new Object[0]);
            }
            if (line.contains("@") && !line.contains("@see") && line.length() > maxLineLength && !(s = line.replaceAll("^ *\\* *", "").replaceAll(" \\*\\/$", "").replaceAll("[;.,]$", "").replaceAll("<li>", "")).matches("^\\{@link .*\\}$") && !file.getName().endsWith("CalciteResource.java")) {
                this.log(i, "Javadoc line too long ({0} chars)", new Object[]{line.length()});
            }
            if (line.matches(".*\\@param +[^ ]+ *$")) {
                this.log(i, "Parameter with no description", new Object[0]);
            }
            if (line.matches(".* href=.*CALCITE-.*") && !line.matches(".*<a href=\"https://issues.apache.org/jira/browse/CALCITE-[0-9]+\">\\[CALCITE-[0-9]+\\].*")) {
                this.log(i, "Bad JIRA reference", new Object[0]);
            }
            if (!file.getName().endsWith(".java") || !line.contains("(") && !line.contains(")")) continue;
            s = HydromaticFileSetCheck.deString(line);
            int o = 0;
            for (int j = 0; j < s.length(); ++j) {
                char c = s.charAt(j);
                if (c == '(' && j > 0 && Character.isJavaIdentifierPart(s.charAt(j - 1))) {
                    ++o;
                    continue;
                }
                if (c != ')') continue;
                --o;
            }
            if (o <= true) continue;
            this.log(i, "Open parentheses exceed closes by 2 or more", new Object[0]);
        }
        this.afterFile(file, list);
    }

    static String deString(String line) {
        if (!line.contains("\"")) {
            return line;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        block4: while (true) {
            int j;
            if ((j = line.indexOf(34, i)) < 0) {
                b.append(line, i, line.length());
                return b.toString();
            }
            b.append(line, i, j);
            int k = j + 1;
            while (true) {
                if (k >= line.length()) {
                    b.append("string");
                    i = line.length();
                    continue block4;
                }
                char c = line.charAt(k++);
                switch (c) {
                    case '\\': {
                        ++k;
                        break;
                    }
                    case '\"': {
                        b.append("string");
                        i = k;
                        continue block4;
                    }
                }
            }
            break;
        }
    }

    public void fireErrors2(File fileName) {
        this.fireErrors(fileName.getAbsolutePath());
    }
}

