/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.toolbox.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;

public class HydromaticFileSetCheck
extends AbstractFileSetCheck {
    private static final Pattern PATTERN1 = Pattern.compile(".*\\\\n\" \\+ .*");
    private static final Pattern PATTERN2 = Pattern.compile("^\\{@link .*\\}$");
    private static final Pattern PATTERN3 = Pattern.compile(".*@param +[^ ]+ *$");
    private static final Pattern PATTERN4 = Pattern.compile(".* href=.*CALCITE-.*");
    private static final Pattern PATTERN5 = Pattern.compile(".*<a href=\"https://issues.apache.org/jira/browse/CALCITE-[0-9]+\">\\[CALCITE-[0-9]+\\].*");

    boolean isProto(File file) {
        return file.getAbsolutePath().contains("/proto/") || file.getName().endsWith("Base64.java");
    }

    static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    void afterFile(File file, List<String> lines) {
        if (file.getName().endsWith(".java")) {
            String b = file.getName().replaceAll(".*/", "");
            String line = "// End " + b;
            if (!HydromaticFileSetCheck.last(lines).equals(line) && !this.isProto(file)) {
                this.log(lines.size(), "Last line should be ''{0}''", new Object[]{line});
            }
        }
    }

    protected void processFiltered(File file, List<String> list) {
        boolean off = false;
        int endCount = 0;
        int maxLineLength = 80;
        String path = file.getAbsolutePath().replace('\\', '/');
        if (path.contains("/calcite/")) {
            maxLineLength = 100;
        }
        int i = 0;
        for (String line : list) {
            String s;
            ++i;
            if (line.contains("\t")) {
                this.log(i, "Tab", new Object[0]);
            }
            if (line.contains("CHECKSTYLE: ON")) {
                off = false;
            }
            if (line.contains("CHECKSTYLE: OFF")) {
                off = true;
            }
            if (off) continue;
            if (line.startsWith("// End ") && endCount++ > 0) {
                this.log(i, "End seen more than once", new Object[0]);
            }
            if (this.isMatches(PATTERN1, line)) {
                this.log(i, "Newline in string should be at end of line", new Object[0]);
            }
            if (line.contains("{@link") && !line.contains("}")) {
                this.log(i, "Split @link", new Object[0]);
            }
            if (line.endsWith("@Override")) {
                this.log(i, "@Override should not be on its own line", new Object[0]);
            }
            if (line.endsWith("<p>") && !this.isProto(file)) {
                this.log(i, "Orphan <p>. Make it the first line of a paragraph", new Object[0]);
            }
            if (line.contains("@") && !line.contains("@see") && line.length() > maxLineLength && !this.isMatches(PATTERN2, s = line.replaceAll("^ *\\* *", "").replaceAll(" \\*/$", "").replaceAll("[;.,]$", "").replaceAll("<li>", "")) && !file.getName().endsWith("CalciteResource.java")) {
                this.log(i, "Javadoc line too long ({0} chars)", new Object[]{line.length()});
            }
            if (this.isMatches(PATTERN3, line)) {
                this.log(i, "Parameter with no description", new Object[0]);
            }
            if (this.isMatches(PATTERN4, line) && !this.isMatches(PATTERN5, line)) {
                this.log(i, "Bad JIRA reference", new Object[0]);
            }
            if (!file.getName().endsWith(".java") || !line.contains("(") && !line.contains(")")) continue;
            s = HydromaticFileSetCheck.deString(line);
            int o = 0;
            for (int j = 0; j < s.length(); ++j) {
                char c = s.charAt(j);
                if (c == '(' && j > 0 && Character.isJavaIdentifierPart(s.charAt(j - 1))) {
                    ++o;
                    continue;
                }
                if (c != ')') continue;
                --o;
            }
            if (o <= true) continue;
            this.log(i, "Open parentheses exceed closes by 2 or more", new Object[0]);
        }
        this.afterFile(file, list);
    }

    private boolean isMatches(Pattern pattern, String line) {
        return pattern.matcher(line).matches();
    }

    static String deString(String line) {
        if (!line.contains("\"")) {
            return line;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        block4: while (true) {
            int j;
            if ((j = line.indexOf(34, i)) < 0) {
                b.append(line, i, line.length());
                return b.toString();
            }
            b.append(line, i, j);
            int k = j + 1;
            while (true) {
                if (k >= line.length()) {
                    b.append("string");
                    i = line.length();
                    continue block4;
                }
                char c = line.charAt(k++);
                switch (c) {
                    case '\\': {
                        ++k;
                        break;
                    }
                    case '\"': {
                        b.append("string");
                        i = k;
                        continue block4;
                    }
                }
            }
            break;
        }
    }

    public void fireErrors2(File fileName) {
        this.fireErrors(fileName.getAbsolutePath());
    }
}

