package net.wysistat.sdk.operation

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

internal open class Operation(
    var actionBlock: (suspend () -> Unit)? = null,
    var completionBlock: (suspend () -> Unit)? = null
) {
    suspend fun execute() = withContext(Dispatchers.Default) {
        actionBlock?.invoke()
        completionBlock?.invoke()
    }
}

/**
 * Custom operation used only for cancelling operations in OperationQueue
 */
internal class CancellingOperation: Operation()