package net.wysistat.sdk.utils

import android.app.UiModeManager
import android.content.Context
import android.content.res.Configuration
import java.io.File

@Volatile private var uiModeManager: UiModeManager? = null

internal fun Context.getUiModeManager() = uiModeManager ?: synchronized(this) {
    uiModeManager ?: (applicationContext.getSystemService(Context.UI_MODE_SERVICE) as? UiModeManager).also { uiModeManager = it }
}

internal fun Context.getDeviceType(): String {
    return if(isTelevision()) {
        "television"
    } else if(isWatch()) {
        "watch"
    } else if(isCar()) {
        "car"
    } else if(isDesk()) {
        "desk"
    } else if(isAppliance()) {
        "appliance"
    } else if(isSmartphone()) {
        "mobile"
    } else if(isTablet()) {
        "tablet"
    } else return "unkonwn"
}

internal fun Context.isTelevision(): Boolean {
    return getUIModeValue() == Configuration.UI_MODE_TYPE_TELEVISION
}

@android.annotation.TargetApi(android.os.Build.VERSION_CODES.KITKAT_WATCH)
internal fun Context.isWatch(): Boolean {
    return getUIModeValue() == Configuration.UI_MODE_TYPE_WATCH
}

internal fun Context.isCar(): Boolean {
    return getUIModeValue() == Configuration.UI_MODE_TYPE_CAR
}

internal fun Context.isDesk(): Boolean {
    return getUIModeValue() == Configuration.UI_MODE_TYPE_DESK
}

internal fun Context.isAppliance(): Boolean {
    return getUIModeValue() == Configuration.UI_MODE_TYPE_APPLIANCE
}

internal fun Context.isSmartphone(): Boolean {
    val smallDeviceWith = resources.configuration.smallestScreenWidthDp
    return getUIModeValue() == Configuration.UI_MODE_TYPE_NORMAL && smallDeviceWith < 600
}

internal fun Context.isTablet(): Boolean {
    val smallDeviceWith = resources.configuration.smallestScreenWidthDp
    return getUIModeValue() == Configuration.UI_MODE_TYPE_NORMAL && smallDeviceWith >= 600
}

internal fun Context.getUIModeValue(): Int {
    return when (getUiModeManager()?.currentModeType) {
        Configuration.UI_MODE_TYPE_DESK -> Configuration.UI_MODE_TYPE_DESK
        Configuration.UI_MODE_TYPE_CAR -> Configuration.UI_MODE_TYPE_CAR
        Configuration.UI_MODE_TYPE_TELEVISION -> Configuration.UI_MODE_TYPE_TELEVISION
        Configuration.UI_MODE_TYPE_APPLIANCE -> Configuration.UI_MODE_TYPE_APPLIANCE
        6 -> 6
        7 -> 7
        else -> Configuration.UI_MODE_TYPE_NORMAL
    }
}

internal fun Context.clearSecurePrefs() {
    val dir = File("${filesDir.parent}/shared_prefs/")
    if(dir.exists()) {
        val children: Array<String> = dir.list() ?: emptyArray()

        if(children.contains("wysitat_prefs.xml")) {
            getSharedPreferences("wysitat_prefs", Context.MODE_PRIVATE).edit().clear().commit()
            File(dir, "wysitat_prefs.xml").delete()
        }
    }
}






