/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.File;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BarePluginsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBarePlugin() throws Exception {
        File tmp = org.scijava.test.TestUtils.createTemporaryDirectory((String)"bare-plugins-");
        File plugins = new File(tmp, "plugins");
        Assert.assertTrue((boolean)plugins.mkdir());
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        CtClass clazz = pool.makeClass("Bare_Test_Plugin");
        clazz.addField(CtField.make((String)"public static java.lang.String value;", (CtClass)clazz));
        clazz.addInterface(pool.get("ij.plugin.PlugIn"));
        clazz.addMethod(CtMethod.make((String)"public void run(java.lang.String arg) {  value = \"bare \" + ij.Macro.getOptions().trim();}", (CtClass)clazz));
        clazz.addMethod(CtMethod.make((String)"public static java.lang.String get() {  return value;}", (CtClass)clazz));
        clazz.writeFile(plugins.getPath());
        String pluginsDir = System.getProperty("plugins.dir");
        try {
            System.setProperty("plugins.dir", plugins.getPath());
            LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
            ij1.noPluginClassLoader();
            String message = "Yep, that's the bare plugin alright!";
            ij1.run("Bare Test Plugin", "Yep, that's the bare plugin alright!");
            ClassLoader loader = (ClassLoader)TestUtils.invokeStatic(ij1.getClassLoader(), "ij.IJ", "getClassLoader", new Object[0]);
            Assert.assertEquals((Object)"bare Yep, that's the bare plugin alright!", TestUtils.invokeStatic(loader, "Bare_Test_Plugin", "get", new Object[0]));
        }
        finally {
            if (pluginsDir == null) {
                System.clearProperty("plugins.dir");
            } else {
                System.setProperty("plugins.dir", pluginsDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleExtraFileTypes() throws Exception {
        File tmp = org.scijava.test.TestUtils.createTemporaryDirectory((String)"handle-extra-file-types-");
        File plugins = new File(tmp, "plugins");
        Assert.assertTrue((boolean)plugins.mkdir());
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        CtClass clazz = pool.makeClass("HandleExtraFileTypes");
        clazz.addMethod(CtMethod.make((String)"public java.lang.String toString() {  return \"It works!\";}", (CtClass)clazz));
        clazz.writeFile(plugins.getPath());
        String pluginsDir = System.getProperty("plugins.dir");
        try {
            System.setProperty("plugins.dir", plugins.getPath());
            LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
            ij1.noPluginClassLoader();
            Object handleExtraFileTypes = ij1.runPlugIn("HandleExtraFileTypes", "");
            Assert.assertNotNull((Object)handleExtraFileTypes);
            Assert.assertEquals((Object)"It works!", (Object)handleExtraFileTypes.toString());
        }
        finally {
            if (pluginsDir == null) {
                System.clearProperty("plugins.dir");
            } else {
                System.setProperty("plugins.dir", pluginsDir);
            }
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

