/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import imagej.patcher.LegacyClassLoader;
import imagej.patcher.LegacyHooks;
import imagej.patcher.LegacyInjector;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class LegacyEnvironment {
    private final ClassLoader loader;
    private final Method setOptions;
    private final Method run;
    private final Method runMacro;
    private final Method runPlugIn;
    private final Method main;

    public LegacyEnvironment(ClassLoader loader, boolean headless) throws ClassNotFoundException {
        if (loader != null) {
            new LegacyInjector().injectHooks(loader, headless);
        }
        this.loader = loader != null ? loader : new LegacyClassLoader(headless);
        Class<?> ij = this.loader.loadClass("ij.IJ");
        Class<?> imagej = this.loader.loadClass("ij.ImageJ");
        Class<?> macro = this.loader.loadClass("ij.Macro");
        try {
            this.setOptions = macro.getMethod("setOptions", String.class);
            this.run = ij.getMethod("run", String.class, String.class);
            this.runMacro = ij.getMethod("runMacro", String.class, String.class);
            this.runPlugIn = ij.getMethod("runPlugIn", String.class, String.class);
            this.main = imagej.getMethod("main", String[].class);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Found incompatible ij.IJ class", e);
        }
    }

    public void addPluginClasspath(ClassLoader fromClassLoader) {
        if (fromClassLoader == null) {
            return;
        }
        for (ClassLoader loader = fromClassLoader; loader != null && loader != this.loader && loader != this.loader.getParent(); loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) {
                if (loader != fromClassLoader) continue;
                throw new IllegalArgumentException("Cannot add class path from ClassLoader of type " + fromClassLoader.getClass().getName());
            }
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                if (!"file".equals(url.getProtocol())) {
                    throw new RuntimeException("Not a file URL! " + url);
                }
                this.addPluginClasspath(new File(url.getPath()));
                String path = url.getPath();
                if (!path.matches(".*/target/surefire/surefirebooter[0-9]*\\.jar")) continue;
                try {
                    String classPath;
                    JarFile jar = new JarFile(path);
                    Manifest manifest = jar.getManifest();
                    if (manifest == null || (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String element : classPath.split(" +")) {
                        try {
                            URL url2 = new URL(element);
                            if (!"file".equals(url2.getProtocol())) continue;
                            this.addPluginClasspath(new File(url2.getPath()));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Warning: could not add plugin class path due to ");
                    e.printStackTrace();
                }
            }
        }
    }

    public void addPluginClasspath(File ... classpathEntries) {
        try {
            LegacyHooks hooks = (LegacyHooks)this.loader.loadClass("ij.IJ").getField("_hooks").get(null);
            for (File file : classpathEntries) {
                hooks._pluginClasspath.add(file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setMacroOptions(String options) {
        try {
            this.setOptions.invoke(null, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run(String command, String options) {
        Thread thread = Thread.currentThread();
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.run.invoke(null, command, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(savedLoader);
        }
    }

    public void runMacro(String macro, String arg) {
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.runMacro.invoke(null, macro, arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setName(savedName);
            thread.setContextClassLoader(savedLoader);
        }
    }

    public Object runPlugIn(String className, String arg) {
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            Object object = this.runPlugIn.invoke(null, className, arg);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setName(savedName);
            thread.setContextClassLoader(savedLoader);
        }
    }

    public void main(String ... args) {
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            this.main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static LegacyEnvironment getPatchedImageJ1() throws ClassNotFoundException {
        boolean headless = GraphicsEnvironment.isHeadless();
        return new LegacyEnvironment(new LegacyClassLoader(headless), headless);
    }
}

