/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.EssentialLegacyHooks;
import net.imagej.patcher.LegacyClassLoader;
import net.imagej.patcher.LegacyHooks;
import net.imagej.patcher.LegacyInjector;

public class LegacyEnvironment {
    private final boolean headless;
    private final LegacyInjector injector;
    private Throwable initializationStackTrace;
    private ClassLoader loader;
    private Method setOptions;
    private Method run;
    private Method runMacro;
    private Method runPlugIn;
    private Method main;
    private Field _hooks;

    public LegacyEnvironment(ClassLoader loader, boolean headless) throws ClassNotFoundException {
        this(loader, headless, new LegacyInjector());
    }

    LegacyEnvironment(ClassLoader loader, boolean headless, LegacyInjector injector) throws ClassNotFoundException {
        this.headless = headless;
        this.loader = loader;
        this.injector = injector;
    }

    private boolean isInitialized() {
        return this._hooks != null;
    }

    private synchronized void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.initializationStackTrace = new Throwable("Initialized here:");
        if (this.loader != null) {
            this.injector.injectHooks(this.loader, this.headless);
        }
        try {
            this.loader = this.loader != null ? this.loader : new LegacyClassLoader(this.headless, this.injector);
            Class<?> ij = this.loader.loadClass("ij.IJ");
            Class<?> imagej = this.loader.loadClass("ij.ImageJ");
            Class<?> macro = this.loader.loadClass("ij.Macro");
            this._hooks = ij.getField("_hooks");
            this.setOptions = macro.getMethod("setOptions", String.class);
            this.run = ij.getMethod("run", String.class, String.class);
            this.runMacro = ij.getMethod("runMacro", String.class, String.class);
            this.runPlugIn = ij.getMethod("runPlugIn", String.class, String.class);
            this.main = imagej.getMethod("main", String[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Found incompatible ij.IJ class", e);
        }
    }

    private void ensureUninitialized() {
        if (this.isInitialized()) {
            StringWriter string = new StringWriter();
            PrintWriter writer = new PrintWriter(string);
            this.initializationStackTrace.printStackTrace(writer);
            writer.close();
            throw new RuntimeException("LegacyEnvironment was already initialized:\n\n" + string.toString().replaceAll("(?m)^", "\t"));
        }
    }

    public void disableIJ1PluginDirs() {
        this.ensureUninitialized();
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                hacker.insertAtBottomOfMethod(EssentialLegacyHooks.class.getName(), "public <init>()", "enableIJ1PluginDirs(false);");
            }
        });
    }

    public void addPluginClasspath(ClassLoader fromClassLoader) {
        if (fromClassLoader == null) {
            return;
        }
        this.ensureUninitialized();
        for (ClassLoader loader = fromClassLoader; !(loader == null || loader == this.loader || this.loader != null && loader == this.loader.getParent() || this.loader == null && loader == this.getClass().getClassLoader().getParent()); loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) {
                if (loader != fromClassLoader) continue;
                throw new IllegalArgumentException("Cannot add class path from ClassLoader of type " + fromClassLoader.getClass().getName());
            }
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                if (!"file".equals(url.getProtocol())) {
                    throw new RuntimeException("Not a file URL! " + url);
                }
                this.addPluginClasspath(new File(url.getPath()));
                String path = url.getPath();
                if (!path.matches(".*/target/surefire/surefirebooter[0-9]*\\.jar")) continue;
                try {
                    String classPath;
                    JarFile jar = new JarFile(path);
                    Manifest manifest = jar.getManifest();
                    if (manifest == null || (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String element : classPath.split(" +")) {
                        try {
                            URL url2 = new URL(element);
                            if (!"file".equals(url2.getProtocol())) continue;
                            this.addPluginClasspath(new File(url2.getPath()));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Warning: could not add plugin class path due to ");
                    e.printStackTrace();
                }
            }
        }
    }

    public void addPluginClasspath(File ... classpathEntries) {
        if (classpathEntries.length == 0) {
            return;
        }
        this.ensureUninitialized();
        final StringBuilder builder = new StringBuilder();
        for (File file : classpathEntries) {
            String quoted = file.getPath().replaceAll("[\\\"\\\\]", "\\\\$0").replaceAll("\n", "\\n");
            builder.append("addPluginClasspath(new java.io.File(\"").append(quoted).append("\"));");
        }
        this.injector.after.add(new LegacyInjector.Callback(){

            @Override
            public void call(CodeHacker hacker) {
                hacker.insertAtBottomOfMethod(EssentialLegacyHooks.class.getName(), "public <init>()", builder.toString());
            }
        });
    }

    public void setMacroOptions(String options) {
        this.initialize();
        try {
            this.setOptions.invoke(null, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run(String command, String options) {
        this.initialize();
        Thread thread = Thread.currentThread();
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.run.invoke(null, command, options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(savedLoader);
        }
    }

    public void runMacro(String macro, String arg) {
        this.initialize();
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.runMacro.invoke(null, macro, arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setName(savedName);
            thread.setContextClassLoader(savedLoader);
        }
    }

    public Object runPlugIn(String className, String arg) {
        this.initialize();
        Thread thread = Thread.currentThread();
        String savedName = thread.getName();
        thread.setName("Run$_" + savedName);
        ClassLoader savedLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            Object object = this.runPlugIn.invoke(null, className, arg);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setName(savedName);
            thread.setContextClassLoader(savedLoader);
        }
    }

    public void main(String ... args) {
        this.initialize();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            this.main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        this.initialize();
        return this.loader;
    }

    public Map<String, String> getMenuStructure() {
        this.initialize();
        try {
            LegacyHooks hooks = (LegacyHooks)this._hooks.get(null);
            return hooks.getMenuStructure();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LegacyEnvironment getPatchedImageJ1() throws ClassNotFoundException {
        boolean headless = GraphicsEnvironment.isHeadless();
        return new LegacyEnvironment(new LegacyClassLoader(headless), headless);
    }
}

