/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class LegacyHooks {
    private boolean enableIJ1PluginDirs = true;
    private final Collection<File> pluginClasspath = new LinkedHashSet<File>();
    private Map<String, String> menuStructure = new LinkedHashMap<String, String>();

    public boolean isLegacyMode() {
        return true;
    }

    public Object getContext() {
        return null;
    }

    public boolean quit() {
        return true;
    }

    public void installed() {
    }

    public void dispose() {
    }

    public Object interceptRunPlugIn(String className, String arg) {
        return null;
    }

    public void showProgress(double progress) {
    }

    public void showProgress(int currentIndex, int finalIndex) {
    }

    public void showStatus(String status) {
    }

    public void log(String message) {
    }

    public void registerImage(Object image) {
    }

    public void unregisterImage(Object image) {
    }

    public void debug(String string) {
        System.err.println(string);
    }

    public void error(Throwable t) {
    }

    public String getAppName() {
        return "ImageJ";
    }

    public URL getIconURL() {
        return null;
    }

    public boolean openInEditor(String path) {
        return false;
    }

    public boolean createInEditor(String fileName, String content) {
        return false;
    }

    protected void enableIJ1PluginDirs(boolean enable) {
        this.enableIJ1PluginDirs = enable;
    }

    protected void addPluginClasspath(File file) {
        this.pluginClasspath.add(file);
    }

    public List<File> handleExtraPluginJars() {
        File dir;
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(this.pluginClasspath);
        if (!this.enableIJ1PluginDirs) {
            return result;
        }
        String extraPluginDirs = System.getProperty("ij1.plugin.dirs");
        if (extraPluginDirs != null) {
            for (String dir2 : extraPluginDirs.split(File.pathSeparator)) {
                File directory = new File(dir2);
                if (!directory.isDirectory()) continue;
                result.add(directory);
                this.handleExtraPluginJars(directory, result);
            }
            return result;
        }
        String userHome = System.getProperty("user.home");
        if (userHome != null && (dir = new File(userHome, ".plugins")).isDirectory()) {
            result.add(dir);
            this.handleExtraPluginJars(dir, result);
        }
        return result;
    }

    private void handleExtraPluginJars(File directory, List<File> result) {
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        for (File file : list) {
            if (file.isDirectory()) {
                this.handleExtraPluginJars(file, result);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            result.add(file);
        }
    }

    public void runAfterRefreshMenus() {
    }

    public boolean handleNoSuchMethodError(NoSuchMethodError e) {
        return false;
    }

    public void newPluginClassLoader(ClassLoader loader) {
    }

    public String[] addPluginDirectory(File directory, String[] names) {
        if (names != null) {
            Pattern pattern = Pattern.compile("(batik|jython|jruby)(-[0-9].*)?\\.jar");
            Arrays.sort(names, new FatJarNameComparator(pattern));
        }
        return names;
    }

    public void initialized() {
    }

    public InputStream autoGenerateConfigFile(File directory) {
        if (new File(directory, "IJ_Props.txt").exists()) {
            return null;
        }
        return new ByteArrayInputStream(this.autoGenerateConfigFile(directory, directory, "Plugins", "", new StringBuilder()).toString().getBytes());
    }

    protected StringBuilder autoGenerateConfigFile(File topLevelDirectory, File directory, String menuPath, String packageName, StringBuilder builder) {
        Object[] list = directory.listFiles();
        if (list == null) {
            return builder;
        }
        Arrays.sort(list);
        for (Object file : list) {
            String name = ((File)file).getName();
            if (name.startsWith("_")) continue;
            if (((File)file).isDirectory()) {
                this.autoGenerateConfigFile(topLevelDirectory, (File)file, menuPath + ">" + name.replace('_', ' '), packageName + name + ".", builder);
                continue;
            }
            if (!name.endsWith(".class") || !name.contains("_") || name.contains("$") || topLevelDirectory == directory && Character.isLowerCase(name.charAt(0))) continue;
            String className = packageName + name.substring(0, name.length() - 6);
            name = name.substring(0, name.length() - 6).replace('_', ' ');
            builder.append(menuPath + ", \"" + name + "\", " + className + "\n");
        }
        return builder;
    }

    public void addMenuItem(String menuPath, String command) {
        if (menuPath == null) {
            this.menuStructure.clear();
        } else if (menuPath.endsWith(">-")) {
            int i = 1;
            while (this.menuStructure.containsKey(menuPath + i)) {
                ++i;
            }
            this.menuStructure.put(menuPath + i, command);
        } else {
            this.menuStructure.put(menuPath, command);
        }
    }

    public Map<String, String> getMenuStructure() {
        return Collections.unmodifiableMap(this.menuStructure);
    }

    public Object interceptOpen(String path, int planeIndex, boolean display) {
        return null;
    }

    public static final class FatJarNameComparator
    implements Comparator<String> {
        private final Pattern pattern;

        private FatJarNameComparator(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public int compare(String a, String b) {
            return (this.pattern.matcher(a).matches() ? 1 : 0) - (this.pattern.matcher(b).matches() ? 1 : 0);
        }
    }
}

