/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.ImagePlus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import net.imagej.patcher.EssentialLegacyHooks;
import net.imagej.patcher.HeadlessGenericDialog;
import net.imagej.patcher.LegacyHooks;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Utils;

public class LegacyClassLoader
extends URLClassLoader {
    private final Class<?>[] knownClasses = new Class[]{LegacyHooks.class, LegacyHooks.FatJarNameComparator.class, EssentialLegacyHooks.class, HeadlessGenericDialog.class};
    private final int sharedClassCount = 2;

    public LegacyClassLoader(boolean headless) throws ClassNotFoundException {
        this();
        new LegacyInjector().injectHooks(this, headless);
    }

    public LegacyClassLoader() throws ClassNotFoundException {
        super(LegacyClassLoader.getImageJ1Jar(), LegacyClassLoader.determineParent());
    }

    @Override
    public URL getResource(String name) {
        if (name.startsWith("net/imagej/patcher/")) {
            for (Class<?> clazz : this.knownClasses) {
                if (!name.equals(clazz.getName().replace('.', '/') + ".class")) continue;
                return clazz.getResource("/" + name);
            }
        }
        return super.getResource(name);
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        for (int i = 0; i < this.knownClasses.length; ++i) {
            if (!this.knownClasses[i].getName().equals(className)) continue;
            try {
                int count;
                if (i < 2) {
                    return this.knownClasses[i];
                }
                ProtectionDomain domain = this.knownClasses[i].getProtectionDomain();
                InputStream in = this.knownClasses[i].getResourceAsStream("/" + className.replace('.', '/') + ".class");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[65536];
                while ((count = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, count);
                }
                in.close();
                buffer = out.toByteArray();
                out.close();
                return this.defineClass(className, buffer, 0, buffer.length, domain);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Could not read bytecode for " + className, e);
            }
        }
        return super.findClass(className);
    }

    private static ClassLoader determineParent() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            do {
                if (loader.loadClass("ij.IJ") != null) continue;
                return loader;
            } while ((loader = loader.getParent()) != null);
            throw new RuntimeException("Cannot find bootstrap class loader");
        }
        catch (ClassNotFoundException e) {
            return loader;
        }
    }

    private static URL[] getImageJ1Jar() {
        return new URL[]{Utils.getLocation(ImagePlus.class)};
    }
}

