/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.Macro;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.CtClass;
import net.imagej.patcher.Headless_Example_Plugin;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Set_Property;
import net.imagej.patcher.TestUtils;
import net.imagej.patcher.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class HeadlessEnvironmentTest {
    private String threadName;
    private ClassLoader threadLoader;
    private File tmpDir;

    @Before
    public void saveThreadName() {
        this.threadName = Thread.currentThread().getName();
        this.threadLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void restoreThreadName() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        if (this.threadLoader != null) {
            Thread.currentThread().setContextClassLoader(this.threadLoader);
        }
    }

    @Test
    public void testMacro() throws Exception {
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
        String propertyName = "headless.test.property" + Math.random();
        String propertyValue = "Hello, world!";
        System.setProperty(propertyName, "(unset)");
        Assert.assertFalse((boolean)"Hello, world!".equals(System.getProperty(propertyName)));
        ij1.runMacro("call(\"java.lang.System.setProperty\", \"" + propertyName + "\", getArgument());", "Hello, world!");
        Assert.assertEquals((Object)"Hello, world!", (Object)System.getProperty(propertyName));
    }

    @Test
    public void testEncapsulation() throws Exception {
        Thread.currentThread().setName("Run$_" + this.threadName);
        Macro.setOptions((String)"(unset)");
        Assert.assertEquals((Object)"(unset) ", (Object)Macro.getOptions());
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
        ij1.runMacro("call(\"ij.Macro.setOptions\", \"Hello, world!\");", null);
        Assert.assertEquals((Object)"(unset) ", (Object)Macro.getOptions());
        Method getOptions = ij1.getClassLoader().loadClass("ij.Macro").getMethod("getOptions", new Class[0]);
        Assert.assertEquals((Object)"Hello, world! ", (Object)getOptions.invoke(null, new Object[0]));
    }

    @Test
    public void testHeadless() throws Exception {
        Assert.assertTrue((boolean)HeadlessEnvironmentTest.runExampleDialogPlugin(true));
    }

    @Test
    public void testPatchIsRequired() throws Exception {
        Assume.assumeTrue((boolean)GraphicsEnvironment.isHeadless());
        Assert.assertFalse((boolean)HeadlessEnvironmentTest.runExampleDialogPlugin(false));
    }

    @Test
    public void saveDialog() throws Exception {
        Assert.assertTrue((boolean)HeadlessEnvironmentTest.runExamplePlugin(true, "SaveDialog", "file=README.txt", "true"));
    }

    @Test
    public void booleanTest() throws Exception {
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key", "This is the key! true");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key ", "This is the key! true");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key=1", "This is the key! false");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key1", "This is the key! false");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the next key!]", "This is the next key! false");
    }

    @Test
    public void testIJInit() throws Exception {
        LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
        ClassLoader loader = ij1.getClassLoader();
        Method runPlugIn = loader.loadClass("ij.IJ").getMethod("runPlugIn", String.class, String.class);
        runPlugIn.invoke(null, "ij.IJ.init", "");
        Method getCommands = loader.loadClass("ij.Menus").getMethod("getCommands", new Class[0]);
        Assert.assertNotNull((Object)getCommands.invoke(null, new Object[0]));
    }

    @Test
    public void testWithoutPluginClassLoader() throws Exception {
        this.tmpDir = org.scijava.test.TestUtils.createTemporaryDirectory((String)"class-loader-");
        File jarFile = new File(this.tmpDir, "Set_Property.jar");
        TestUtils.makeJar(jarFile, Set_Property.class.getName());
        URL jarURL = jarFile.toURI().toURL();
        URL ij1URL = Utils.getLocation(Class.forName("ij.IJ"));
        URL ij1PatcherURL = Utils.getLocation(LegacyEnvironment.class);
        URL javassistURL = Utils.getLocation(CtClass.class);
        URL[] urls = new URL[]{ij1PatcherURL, javassistURL, ij1URL, jarURL};
        ClassLoader parent = this.getClass().getClassLoader().getParent();
        URLClassLoader loader = new URLClassLoader(urls, parent);
        Class<?> envClass = loader.loadClass(LegacyEnvironment.class.getName());
        Object env = envClass.getConstructor(ClassLoader.class, Boolean.TYPE).newInstance(loader, true);
        envClass.getMethod("disableIJ1PluginDirs", new Class[0]).invoke(env, new Object[0]);
        envClass.getMethod("disableInitializer", new Class[0]).invoke(env, new Object[0]);
        envClass.getMethod("noPluginClassLoader", new Class[0]).invoke(env, new Object[0]);
        Method ij1Run = envClass.getMethod("run", String.class, String.class);
        String key = "random-" + Math.random();
        System.setProperty(key, "must be overridden");
        ij1Run.invoke(env, "Set Property", "key=" + key + " value=overridden");
        Assert.assertEquals((Object)"overridden", (Object)System.getProperty(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonOverriddenMethods() throws Exception {
        Object result;
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(true, false);
        ClassLoader loader = ij1.getClassLoader();
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        try {
            ij1.setMacroOptions("Booh!");
            if (!threadName.startsWith("Run$_")) {
                thread.setName("Run$_" + threadName);
            }
            Object dialog = TestUtils.construct(loader, "ij.gui.GenericDialog", "Test parseDouble");
            result = TestUtils.invoke(dialog, "parseDouble", "2.182859");
        }
        finally {
            thread.setName(threadName);
        }
        Assert.assertNotNull(result);
        Assert.assertTrue((String)("Not a Double: " + result.getClass()), (boolean)(result instanceof Double));
        Assert.assertEquals((double)2.182859, (double)((Double)result), (double)1.0E-6);
    }

    private static boolean runExampleDialogPlugin(boolean patchHeadless) throws Exception {
        return HeadlessEnvironmentTest.runExamplePlugin(patchHeadless, "the argument", "prefix=[*** ]", "*** the argument");
    }

    private static boolean runExamplePlugin(boolean patchHeadless, String arg, String macroOptions, String expectedValue) throws Exception {
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(patchHeadless, false);
        ij1.addPluginClasspath(HeadlessEnvironmentTest.class.getClassLoader());
        try {
            ij1.setMacroOptions(macroOptions);
            String value = ij1.runPlugIn(Headless_Example_Plugin.class.getName(), arg).toString();
            Assert.assertEquals((Object)expectedValue, (Object)value);
            return true;
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            while ((t instanceof InvocationTargetException || t instanceof RuntimeException) && t.getCause() != null) {
                t = t.getCause();
            }
            if (!(t instanceof HeadlessException)) {
                t.printStackTrace();
            }
            return false;
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

