/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.net.URL;
import java.util.HashSet;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;
import net.imagej.patcher.EssentialLegacyHooks;
import net.imagej.patcher.HeadlessGenericDialog;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Utils;
import org.junit.Assert;
import org.junit.Test;

public class ImageJ1EncapsulationTest {
    @Test
    public void verifyEncapsulation() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        HashSet<String> exceptions = new HashSet<String>();
        exceptions.add(EssentialLegacyHooks.class.getName());
        exceptions.add(HeadlessGenericDialog.class.getName());
        exceptions.add(imagej.patcher.EssentialLegacyHooks.class.getName());
        exceptions.add(imagej.patcher.HeadlessGenericDialog.class.getName());
        URL directory = Utils.getLocation(Utils.class);
        int prefixLength = directory.toString().length();
        for (URL url : Utils.listContents((URL)directory)) {
            String path = url.toString().substring(prefixLength);
            if (!path.endsWith(".class")) continue;
            String className = path.substring(0, path.length() - 6).replace('/', '.');
            if (exceptions.contains(className)) {
                exceptions.remove(className);
                continue;
            }
            try {
                CtClass clazz = pool.get(className);
                clazz.instrument((ExprEditor)new ImageJ1UsageTester());
            }
            catch (Exception e) {
                throw new RuntimeException("Problem with class " + className, e);
            }
        }
        Assert.assertEquals((String)((Object)exceptions).toString(), (long)0L, (long)exceptions.size());
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }

    private final class ImageJ1UsageTester
    extends ExprEditor {
        private ImageJ1UsageTester() {
        }

        private void test(CtClass c) {
            if (c != null && c.getName().startsWith("ij.")) {
                throw new RuntimeException("ImageJ 1.x class used: " + c.getName());
            }
        }

        public void edit(Cast c) {
            try {
                this.test(c.getType());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(ConstructorCall c) {
            try {
                this.test(c.getConstructor().getDeclaringClass());
                CtConstructor c2 = c.getConstructor();
                for (CtClass c3 : c2.getExceptionTypes()) {
                    this.test(c3);
                }
                for (CtClass c3 : c2.getParameterTypes()) {
                    this.test(c3);
                }
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(FieldAccess f) {
            try {
                CtField field = f.getField();
                this.test(field.getDeclaringClass());
                this.test(field.getType());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(Handler h) {
            try {
                this.test(h.getType());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(Instanceof i) {
            try {
                this.test(i.getType());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(MethodCall m) {
            try {
                CtMethod m2 = m.getMethod();
                this.test(m2.getDeclaringClass());
                this.test(m2.getReturnType());
                for (CtClass c2 : m2.getExceptionTypes()) {
                    this.test(c2);
                }
                for (CtClass c2 : m2.getParameterTypes()) {
                    this.test(c2);
                }
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(NewArray a) {
            try {
                this.test(a.getComponentType());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void edit(NewExpr e) {
            try {
                CtConstructor c = e.getConstructor();
                for (CtClass c2 : c.getExceptionTypes()) {
                    this.test(c2);
                }
                for (CtClass c2 : c.getParameterTypes()) {
                    this.test(c2);
                }
            }
            catch (NotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

