/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;

public class TestUtils {
    public static void makeJar(File jarFile, String ... classNames) throws IOException {
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));
        byte[] buffer = new byte[16384];
        StringBuilder pluginsConfig = new StringBuilder();
        for (String className : classNames) {
            int count;
            String path = className.replace('.', '/') + ".class";
            InputStream in = TestUtils.class.getResourceAsStream("/" + path);
            ZipEntry entry = new ZipEntry(path);
            jar.putNextEntry(entry);
            while ((count = in.read(buffer)) >= 0) {
                jar.write(buffer, 0, count);
            }
            if (className.indexOf(95) >= 0) {
                String name = className.substring(className.lastIndexOf(46) + 1).replace('_', ' ');
                pluginsConfig.append("Plugins, \"").append(name).append("\", ").append(className).append("\n");
            }
            in.close();
        }
        if (pluginsConfig.length() > 0) {
            ZipEntry entry = new ZipEntry("plugins.config");
            jar.putNextEntry(entry);
            jar.write(pluginsConfig.toString().getBytes());
        }
        jar.close();
    }

    public static <T> T construct(ClassLoader loader, String className, Object ... parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Class<?> clazz = loader.loadClass(className);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!TestUtils.doParametersMatch(constructor.getParameterTypes(), parameters)) continue;
            return (T)constructor.newInstance(parameters);
        }
        throw new NoSuchMethodException("No matching method found");
    }

    public static <T> T invokeStatic(ClassLoader loader, String className, String methodName, Object ... parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = loader.loadClass(className);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !TestUtils.doParametersMatch(method.getParameterTypes(), parameters)) continue;
            return (T)method.invoke(null, parameters);
        }
        throw new NoSuchMethodException("No matching method found");
    }

    public static <T> T invoke(Object object, String methodName, Object ... parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = object.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !TestUtils.doParametersMatch(method.getParameterTypes(), parameters)) continue;
            return (T)method.invoke(object, parameters);
        }
        throw new NoSuchMethodException("No matching method found");
    }

    private static boolean doParametersMatch(Class<?>[] types, Object[] parameters) {
        if (types.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (parameters[i] == null) continue;
            Class<?> clazz = parameters[i].getClass();
            if (types[i].isPrimitive()) {
                if (types[i] != Long.TYPE && types[i] != Integer.TYPE && types[i] != Boolean.TYPE) {
                    throw new RuntimeException("unsupported primitive type " + clazz);
                }
                if (types[i] == Long.TYPE && clazz != Long.class) {
                    return false;
                }
                if (types[i] == Integer.TYPE && clazz != Integer.class) {
                    return false;
                }
                if (types[i] != Boolean.TYPE || clazz == Boolean.class) continue;
                return false;
            }
            if (types[i].isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    public static LegacyEnvironment getTestEnvironment() throws ClassNotFoundException {
        return TestUtils.getTestEnvironment(true, false);
    }

    public static LegacyEnvironment getTestEnvironment(boolean headless, boolean enableIJ1PluginDirs) throws ClassNotFoundException {
        boolean debugMenus = false;
        LegacyInjector injector = new LegacyInjector();
        LegacyEnvironment result = new LegacyEnvironment(null, headless, injector);
        if (!enableIJ1PluginDirs) {
            result.disableIJ1PluginDirs();
        }
        return result;
    }
}

