/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilterRunner;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class HeadlessGenericDialog {
    protected List<Double> numbers;
    protected List<String> strings;
    protected List<Boolean> checkboxes;
    protected List<String> choices;
    protected List<Integer> choiceIndices;
    protected String textArea1;
    protected String textArea2;
    protected List<String> radioButtons;
    protected int numberfieldIndex = 0;
    protected int stringfieldIndex = 0;
    protected int checkboxIndex = 0;
    protected int choiceIndex = 0;
    protected int textAreaIndex = 0;
    protected int radioButtonIndex = 0;
    protected boolean invalidNumber;
    protected String errorMessage;
    protected DialogListener listener;

    public HeadlessGenericDialog() {
        if (Macro.getOptions() == null) {
            throw new RuntimeException("Cannot instantiate headless dialog except in macro mode");
        }
        this.numbers = new ArrayList<Double>();
        this.strings = new ArrayList<String>();
        this.checkboxes = new ArrayList<Boolean>();
        this.choices = new ArrayList<String>();
        this.choiceIndices = new ArrayList<Integer>();
        this.radioButtons = new ArrayList<String>();
    }

    public void addCheckbox(String label, boolean defaultValue) {
        this.checkboxes.add(HeadlessGenericDialog.getMacroParameter(label, defaultValue));
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues) {
        for (int i = 0; i < labels.length; ++i) {
            this.addCheckbox(labels[i], defaultValues[i]);
        }
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues, String[] headings) {
        this.addCheckboxGroup(rows, columns, labels, defaultValues);
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        String item = HeadlessGenericDialog.getMacroParameter(label, defaultItem);
        int index = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(item)) continue;
            index = i;
            break;
        }
        this.choiceIndices.add(index);
        this.choices.add(items[index]);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        this.numbers.add(HeadlessGenericDialog.getMacroParameter(label, defaultValue));
    }

    public void addNumericField(String label, double defaultValue, int digits, int columns, String units) {
        this.addNumericField(label, defaultValue, digits);
    }

    public void addSlider(String label, double minValue, double maxValue, double defaultValue) {
        this.numbers.add(HeadlessGenericDialog.getMacroParameter(label, defaultValue));
    }

    public void addSlider(String label, double minValue, double maxValue, double defaultValue, double stepSize) {
        this.addSlider(label, minValue, maxValue, defaultValue);
    }

    public void addStringField(String label, String defaultText) {
        this.strings.add(HeadlessGenericDialog.getMacroParameter(label, defaultText));
    }

    public void addStringField(String label, String defaultText, int columns) {
        this.addStringField(label, defaultText);
    }

    public void addTextAreas(String text1, String text2, int rows, int columns) {
        this.textArea1 = text1;
        this.textArea2 = text2;
    }

    public boolean getNextBoolean() {
        return this.checkboxes.get(this.checkboxIndex++);
    }

    public String getNextChoice() {
        return this.choices.get(this.choiceIndex++);
    }

    public int getNextChoiceIndex() {
        return this.choiceIndices.get(this.choiceIndex++);
    }

    public double getNextNumber() {
        return this.numbers.get(this.numberfieldIndex++);
    }

    public String getNextString() {
        return this.strings.get(this.stringfieldIndex++);
    }

    public String getNextText() {
        switch (this.textAreaIndex++) {
            case 0: {
                return this.textArea1;
            }
            case 1: {
                return this.textArea2;
            }
        }
        return null;
    }

    public void addRadioButtonGroup(String label, String[] items, int rows, int columns, String defaultItem) {
        this.radioButtons.add(HeadlessGenericDialog.getMacroParameter(label, defaultItem));
    }

    public Vector<String> getRadioButtonGroups() {
        return new Vector<String>(this.radioButtons);
    }

    public String getNextRadioButton() {
        return this.radioButtons.get(this.radioButtonIndex++);
    }

    public boolean invalidNumber() {
        boolean wasInvalid = this.invalidNumber;
        this.invalidNumber = false;
        return wasInvalid;
    }

    public void showDialog() {
        if (Macro.getOptions() == null) {
            throw new RuntimeException("Cannot run dialog headlessly");
        }
        this.resetCounters();
        if (this.listener != null) {
            this.listener.dialogItemChanged((GenericDialog)this, null);
            this.resetCounters();
        }
    }

    private void resetCounters() {
        this.numberfieldIndex = 0;
        this.stringfieldIndex = 0;
        this.checkboxIndex = 0;
        this.choiceIndex = 0;
        this.textAreaIndex = 0;
    }

    public boolean wasCanceled() {
        return false;
    }

    public boolean wasOKed() {
        return true;
    }

    public void dispose() {
    }

    public void addDialogListener(DialogListener dl) {
        if (this.listener != null) {
            return;
        }
        this.listener = dl;
    }

    public void addHelp(String url) {
    }

    public void addImage(ImagePlus image) {
    }

    public void addMessage(String text) {
    }

    public void addMessage(String text, Font font) {
    }

    public void addMessage(String text, Font font, Color color) {
    }

    public void addPanel(Panel panel) {
    }

    public void addPanel(Panel panel, int contraints, Insets insets) {
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr) {
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr, String label) {
    }

    public void centerDialog(boolean b) {
    }

    public void setSmartRecording(boolean smartRecording) {
    }

    public void enableYesNoCancel() {
    }

    public void enableYesNoCancel(String yesLabel, String noLabel) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public Button[] getButtons() {
        return null;
    }

    public Vector<?> getCheckboxes() {
        return null;
    }

    public Vector<?> getChoices() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Insets getInsets() {
        return null;
    }

    public Component getMessage() {
        return null;
    }

    public Vector<?> getNumericFields() {
        return null;
    }

    public Checkbox getPreviewCheckbox() {
        return null;
    }

    public Vector<?> getSliders() {
        return null;
    }

    public Vector<?> getStringFields() {
        return null;
    }

    public TextArea getTextArea1() {
        return null;
    }

    public TextArea getTextArea2() {
        return null;
    }

    public void hideCancelButton() {
    }

    public void previewRunning(boolean isRunning) {
    }

    public void setEchoChar(char echoChar) {
    }

    public void setHelpLabel(String label) {
    }

    public void setInsets(int top, int left, int bottom) {
    }

    public void setOKLabel(String label) {
    }

    protected void setup() {
    }

    public void accessTextFields() {
    }

    public void showHelp() {
    }

    public void setLocation(int x, int y) {
    }

    public void setDefaultString(int index, String str) {
    }

    public boolean isPreviewActive() {
        return false;
    }

    private static boolean getMacroParameter(String label, boolean defaultValue) {
        return HeadlessGenericDialog.findBooleanMacroParameter(label);
    }

    private static boolean findBooleanMacroParameter(String labelString) {
        String optionsString = Macro.getOptions();
        if (optionsString == null) {
            return false;
        }
        char[] options = optionsString.toCharArray();
        char[] label = Macro.trimKey((String)labelString).toCharArray();
        for (int i = 0; i < options.length; ++i) {
            boolean match = true;
            for (char c : label) {
                if (c != options[i]) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match && (i >= options.length || options[i] == ' ')) {
                return true;
            }
            while (i < options.length && options[i] != ' ') {
                if (options[i] == '[') {
                    while (i < options.length && options[i] != ']') {
                        ++i;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static double getMacroParameter(String label, double defaultValue) {
        String value = Macro.getValue((String)Macro.getOptions(), (String)label, null);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    private static String getMacroParameter(String label, String defaultValue) {
        return Macro.getValue((String)Macro.getOptions(), (String)label, (String)defaultValue);
    }
}

