/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.NotFoundException;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.LegacyClassLoader;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyExtensions;
import net.imagej.patcher.LegacyHeadless;
import net.imagej.patcher.LegacyHooks;
import net.imagej.patcher.Utils;

public class LegacyInjector {
    static final String ESSENTIAL_LEGACY_HOOKS_CLASS = "net.imagej.patcher.EssentialLegacyHooks";
    List<Callback> before = new ArrayList<Callback>();
    List<Callback> after = new ArrayList<Callback>();

    public void injectHooks(ClassLoader classLoader) {
        this.injectHooks(classLoader, GraphicsEnvironment.isHeadless());
    }

    public static String getImageJ1Version(CodeHacker hacker) {
        try {
            return hacker.getConstant("ij.ImageJ", "VERSION");
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isImageJ1VersionAtLeast(CodeHacker hacker, String minimalVersion) {
        String imagej1Version = LegacyInjector.getImageJ1Version(hacker);
        if (imagej1Version == null) {
            return false;
        }
        return Utils.ij1VersionCompare(imagej1Version, minimalVersion) >= 0;
    }

    public void injectHooks(ClassLoader classLoader, boolean headless) {
        if (LegacyInjector.alreadyPatched(classLoader)) {
            return;
        }
        CodeHacker hacker = this.inject(classLoader, headless);
        for (Callback callback : this.after) {
            callback.call(hacker);
        }
        hacker.loadClasses();
    }

    private CodeHacker inject(ClassLoader classLoader, boolean headless) {
        CodeHacker hacker = new CodeHacker(classLoader, new ClassPool(false));
        if (hacker.hasField("ij.IJ", "_hooks")) {
            return hacker;
        }
        for (Callback callback : this.before) {
            callback.call(hacker);
        }
        hacker.insertPublicStaticField("ij.IJ", LegacyHooks.class, "_hooks", null);
        hacker.commitClass(LegacyHooks.class);
        hacker.commitClass(LegacyHooks.FatJarNameComparator.class);
        hacker.commitClass(ESSENTIAL_LEGACY_HOOKS_CLASS);
        String legacyHooksClass = LegacyHooks.class.getName();
        StringBuilder builder = new StringBuilder();
        for (Field field : LegacyHooks.class.getDeclaredFields()) {
            builder.append("try {").append("java.lang.reflect.Field field = ").append(legacyHooksClass).append(".class.getDeclaredField(\")").append(field.getName()).append("\"); ").append("field.setAccessible(true);").append("field.set(hooks, field.get(_hooks));").append("} catch (Throwable t) {").append("if (ij.IJ.debugMode) t.printStackTrace();").append("}");
        }
        String essentialHooksClass = ESSENTIAL_LEGACY_HOOKS_CLASS;
        hacker.insertNewMethod("ij.IJ", "public static " + legacyHooksClass + " _hooks(" + legacyHooksClass + " hooks)", legacyHooksClass + " previous = _hooks;if (previous != null && hooks != null) {" + builder + "}if (previous != null) previous.dispose();_hooks = $1 == null ? new " + ESSENTIAL_LEGACY_HOOKS_CLASS + "() : $1;_hooks.installed();return previous;");
        hacker.addToClassInitializer("ij.IJ", "_hooks(null);");
        if (headless) {
            new LegacyHeadless(hacker).patch();
        }
        hacker.insertAtTopOfMethod("ij.ImageJ", "public void quit()", "if (!ij.IJ._hooks.quit()) return;");
        hacker.insertAtTopOfMethod("ij.ImageJ", "public void keyPressed(java.awt.event.KeyEvent e)", "if (ij.IJ._hooks.interceptKeyPressed($1)) return;");
        hacker.insertAtBottomOfMethod("ij.IJ", "public static void showProgress(double progress)", "ij.IJ._hooks.showProgress($1);");
        hacker.insertAtBottomOfMethod("ij.IJ", "public static void showProgress(int currentIndex, int finalIndex)", "ij.IJ._hooks.showProgress($1, $2);");
        hacker.insertAtBottomOfMethod("ij.IJ", "public static void showStatus(java.lang.String status)", "ij.IJ._hooks.showStatus($1);");
        hacker.insertAtTopOfMethod("ij.IJ", "public static Object runPlugIn(java.lang.String commandName, java.lang.String className, java.lang.String arg)", " if (classLoader != null) Thread.currentThread().setContextClassLoader(classLoader);Object o = _hooks.interceptRunPlugIn($2, $3);if (o != null) return o;if (\"ij.IJ.init\".equals($2)) { ij.IJ.init(); return null;}");
        hacker.insertAtTopOfMethod("ij.IJ", "public static void log(java.lang.String message)", "ij.IJ._hooks.log($1);");
        hacker.insertAtTopOfMethod("ij.IJ", "static java.lang.Object runUserPlugIn(java.lang.String commandName, java.lang.String className, java.lang.String arg, boolean createNewLoader)", "if (classLoader != null) Thread.currentThread().setContextClassLoader(classLoader);");
        hacker.insertAtBottomOfMethod("ij.IJ", "static void init()", "ij.IJ._hooks.initialized();");
        hacker.insertAtBottomOfMethod("ij.IJ", "static void init(ij.ImageJ imagej, java.applet.Applet theApplet)", "ij.IJ._hooks.initialized();");
        hacker.insertAtBottomOfMethod("ij.ImagePlus", "public void updateAndDraw()", "ij.IJ._hooks.registerImage(this);");
        hacker.insertAtBottomOfMethod("ij.ImagePlus", "public void repaintWindow()", "ij.IJ._hooks.registerImage(this);");
        hacker.insertAtBottomOfMethod("ij.ImagePlus", "public void show(java.lang.String statusMessage)", "ij.IJ._hooks.registerImage(this);");
        hacker.insertAtBottomOfMethod("ij.ImagePlus", "public void hide()", "ij.IJ._hooks.unregisterImage(this);");
        hacker.insertAtBottomOfMethod("ij.ImagePlus", "public void close()", "ij.IJ._hooks.unregisterImage(this);");
        hacker.insertNewMethod("ij.gui.ImageWindow", "public void setVisible(boolean vis)", "if ($1) ij.IJ._hooks.registerImage(this.getImagePlus());if (ij.IJ._hooks.isLegacyMode()) { super.setVisible($1); }");
        hacker.insertNewMethod("ij.gui.ImageWindow", "public void show()", "ij.IJ._hooks.registerImage(this.getImagePlus());if (ij.IJ._hooks.isLegacyMode()) { super.show(); }");
        hacker.insertAtTopOfMethod("ij.gui.ImageWindow", "public void close()", "ij.IJ._hooks.unregisterImage(this.getImagePlus());");
        hacker.insertNewMethod("ij.io.PluginClassLoader", "void addRecursively(java.io.File directory)", "java.lang.String[] list = ij.IJ._hooks.addPluginDirectory($1, $1.list());if (list == null) return;for (int i = 0; i < list.length; i++) {  java.io.File file = new java.io.File($1, list[i]);  if (file.isDirectory()) addRecursively(file);  else if (file.getName().endsWith(\".jar\")) addURL(file.toURI().toURL());}");
        hacker.insertAtTopOfMethod("ij.io.PluginClassLoader", "void init(java.lang.String path)", "java.io.File plugins = new java.io.File($1);if (plugins.getName().equals(\"plugins\")) {  java.io.File root = plugins.getParentFile();  if (root != null) addRecursively(new java.io.File(root, \"jars\"));}final java.util.Iterator iter = ij.IJ._hooks.handleExtraPluginJars().iterator();while (iter.hasNext()) {  addURL(((java.io.File) iter.next()).toURL());}");
        hacker.insertAtBottomOfMethod("ij.io.PluginClassLoader", "void init(java.lang.String path)", "ij.IJ._hooks.newPluginClassLoader(this);");
        hacker.replaceCallInMethod("ij.io.PluginClassLoader", "private void addDirectory(java.io.File f)", "java.io.File", "list", "$_ = ij.IJ._hooks.addPluginDirectory($0, $proceed($$));");
        hacker.replaceCallInMethod("ij.Menus", "void installJarPlugin(java.lang.String jar, java.lang.String s)", "java.lang.String", "startsWith", "if ($1 == null) $_ = false;else $_ = $proceed($$);");
        hacker.insertAtTopOfMethod("ij.Menus", "void installJarPlugins()", "if (jarFiles != null) {  java.util.HashSet seen = new java.util.HashSet();  for (java.util.Iterator iter = jarFiles.iterator(); iter.hasNext(); ) {    Object jar = iter.next();    if (seen.contains(jar)) iter.remove();    else seen.add(jar);  }  seen = null;}");
        if (Utils.hasClass("com.apple.eawt.ApplicationListener")) {
            hacker.insertAtTopOfMethod("MacAdapter", "public void run(java.lang.String arg)", "if (!ij.IJ._hooks.isLegacyMode()) return;");
        }
        hacker.insertNewMethod("ij.plugin.frame.RoiManager", "public void show()", "if (ij.IJ._hooks.isLegacyMode()) { super.show(); }");
        hacker.insertNewMethod("ij.plugin.frame.RoiManager", "public void setVisible(boolean b)", "if (ij.IJ._hooks.isLegacyMode()) { super.setVisible($1); }");
        hacker.replaceCallInMethod("ij.Prefs", "public static void savePreferences()", "ij.ImageJ", "savePreferences", "if ($0 != null) $_ = $proceed($$);");
        LegacyExtensions.injectHooks(hacker, headless);
        hacker.guardCast("ij.ImagePlus", "public void setStack(java.lang.String title, ij.ImageStack newStack)", "ij.gui.StackWindow");
        hacker.replaceCallInMethod("ij.ImagePlus", "public void setStack(java.lang.String title, ij.ImageStack newStack)", "ij.gui.StackWindow", "validDimensions", "$_ = $0 == null ? false : $proceed($$);");
        hacker.replaceCallInMethod("ij.gui.StackWindow", "public <init>(ij.ImagePlus imp, ij.gui.ImageCanvas ic)", "ij.gui.StackWindow", "show", "if (!ij.macro.Interpreter.batchMode) show();");
        if (!headless) {
            hacker.replaceCallInMethod("ij.Menus", "static synchronized void addWindowMenuItem(ij.ImagePlus imp)", "java.awt.Menu", "add", "$0.insert($1, WINDOW_MENU_ITEMS + windowMenuItems2  + ij.WindowManager.getWindowCount() - 1);$_ = $1;");
        }
        return hacker;
    }

    public static void writeJar(File outputJar, boolean headless, boolean fullIJJar) throws ClassNotFoundException, IOException, NotFoundException {
        File parentDirectory = outputJar.getParentFile();
        if (parentDirectory != null && !parentDirectory.isDirectory() && !parentDirectory.mkdirs()) {
            throw new IOException("Could not make directory: " + parentDirectory);
        }
        LegacyInjector injector = new LegacyInjector();
        LegacyClassLoader loader = new LegacyClassLoader(headless);
        CodeHacker hacker = injector.inject(loader, headless);
        if (!fullIJJar) {
            hacker.writeJar(outputJar);
        } else {
            URL location = Utils.getLocation(loader.loadClass("ij.IJ"));
            if (location.getPath().endsWith(".jar")) {
                location = new URL("jar:" + location.toString() + "!/");
            }
            hacker.writeJar(location, outputJar);
        }
    }

    public static void preinit() {
        LegacyInjector.preinit(Thread.currentThread().getContextClassLoader());
    }

    public static void preinit(ClassLoader classLoader) {
        ClassLoader parent;
        if (LegacyInjector.alreadyPatched(classLoader)) {
            return;
        }
        while ((parent = classLoader.getParent()) != null && parent.getResource("ij/IJ.class") != null) {
            classLoader = parent;
        }
        boolean headless = GraphicsEnvironment.isHeadless();
        try {
            LegacyEnvironment ij1 = new LegacyEnvironment(classLoader, headless);
            ij1.disableInitializer();
            ij1.noPluginClassLoader();
            ij1.suppressIJ1ScriptDiscovery();
            ij1.applyPatches();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean alreadyPatched(ClassLoader classLoader) {
        Class ij = null;
        try {
            Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClass.setAccessible(true);
            for (ClassLoader loader = classLoader; loader != null && (ij = (Class)findLoadedClass.invoke((Object)loader, "ij.IJ")) == null; loader = loader.getParent()) {
            }
            if (ij == null) {
                return false;
            }
        }
        catch (Exception findLoadedClass) {
            // empty catch block
        }
        if (ij == null) {
            try {
                ij = classLoader.loadClass("ij.IJ");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Did not find ij.IJ in " + classLoader);
            }
        }
        try {
            Field hooks = ij.getField("_hooks");
            if (hooks.getType() != LegacyHooks.class) {
                throw new RuntimeException("Unexpected type of ij.IJ._hooks: " + hooks.getType() + " (loader: " + hooks.getType().getClassLoader() + ")");
            }
            return true;
        }
        catch (Exception e) {
            throw CodeHacker.javaAgentHint("No _hooks field found in ij.IJ", e);
        }
    }

    public static LegacyHooks installHooks(ClassLoader classLoader, LegacyHooks hooks) throws UnsupportedOperationException {
        try {
            Method hooksSetter = classLoader.loadClass("ij.IJ").getMethod("_hooks", LegacyHooks.class);
            return (LegacyHooks)hooksSetter.invoke(null, hooks);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t);
        }
    }

    static interface Callback {
        public void call(CodeHacker var1);
    }
}

