/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.ClassPool;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.util.FileUtils;

public class FatJarTest {
    private String threadName;
    private ClassLoader threadLoader;

    @After
    public void after() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        if (this.threadLoader != null) {
            Thread.currentThread().setContextClassLoader(this.threadLoader);
        }
    }

    @Before
    public void before() throws IOException {
        this.threadName = Thread.currentThread().getName();
        this.threadLoader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFatJars() throws Exception {
        File tmp = org.scijava.test.TestUtils.createTemporaryDirectory((String)"fat-jars-");
        File plugins = new File(tmp, "plugins");
        Assert.assertTrue((plugins.exists() || plugins.mkdir() ? 1 : 0) != 0);
        File jars = new File(tmp, "jars");
        if (jars.exists()) {
            FileUtils.deleteRecursively((File)jars);
        }
        Assert.assertTrue((boolean)jars.mkdir());
        CodeHacker hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
        hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"1\";");
        hacker.writeJar(new File(jars, "batik.jar"));
        hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
        hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"xalan0\";");
        hacker.writeJar(new File(jars, "xalan0.jar"));
        String expect = "xalan0";
        int count = 0;
        while (!jars.list()[0].equals("batik.jar")) {
            Assert.assertTrue((boolean)new File(jars, expect + ".jar").delete());
            if (count++ > 20) {
                Assert.fail((String)"Failed to force batik.jar first after 20 tries.");
            }
            expect = "xalan" + count;
            hacker = new CodeHacker((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), new ClassPool(true));
            hacker.insertNewMethod(this.getClass().getName(), "public java.lang.String toString()", "return \"" + expect + "\";");
            hacker.writeJar(new File(jars, expect + ".jar"));
        }
        Assert.assertEquals((Object)"batik.jar", (Object)jars.list()[0]);
        String savedPluginsDir = System.getProperty("plugins.dir");
        try {
            System.setProperty("plugins.dir", tmp.getAbsolutePath());
            LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
            Assert.assertEquals((Object)expect, (Object)ij1.runPlugIn(this.getClass().getName(), "").toString());
        }
        finally {
            if (savedPluginsDir == null) {
                System.clearProperty("plugins.dir");
            } else {
                System.setProperty("plugins.dir", savedPluginsDir);
            }
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

