/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.HeadlessGenericDialog;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Set_Property;
import net.imagej.patcher.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class HeadlessCompletenessTest {
    private File tmpDir;
    private String threadName;
    private ClassLoader threadLoader;

    @Before
    public void before() throws IOException {
        this.threadName = Thread.currentThread().getName();
        this.threadLoader = Thread.currentThread().getContextClassLoader();
        this.tmpDir = org.scijava.test.TestUtils.createTemporaryDirectory((String)"legacy-");
    }

    @After
    public void after() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        if (this.threadLoader != null) {
            Thread.currentThread().setContextClassLoader(this.threadLoader);
        }
    }

    @Test
    public void missingGenericDialogMethods() throws Exception {
        String name;
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        String originalName = "ij.gui.GenericDialog";
        CtClass original = pool.get("ij.gui.GenericDialog");
        String headlessName = HeadlessGenericDialog.class.getName();
        CtClass headless = pool.get(headlessName);
        HashMap<String, CtMethod> methods = new HashMap<String, CtMethod>();
        for (CtMethod ctMethod : headless.getMethods()) {
            if (headless != ctMethod.getDeclaringClass()) continue;
            name = ctMethod.getLongName();
            Assert.assertTrue((boolean)name.startsWith(headlessName + "."));
            name = name.substring(headlessName.length() + 1);
            methods.put(name, ctMethod);
        }
        for (String string : new String[]{"actionPerformed(java.awt.event.ActionEvent)", "addToSameRow()", "adjustmentValueChanged(java.awt.event.AdjustmentEvent)", "getInsets(int,int,int,int)", "getInstance()", "getLabel()", "getString(java.awt.dnd.DropTargetDropEvent)", "getValue(java.lang.String)", "isMacro()", "isMatch(java.lang.String,java.lang.String)", "itemStateChanged(java.awt.event.ItemEvent)", "keyPressed(java.awt.event.KeyEvent)", "keyReleased(java.awt.event.KeyEvent)", "keyTyped(java.awt.event.KeyEvent)", "paint(java.awt.Graphics)", "parseDouble(java.lang.String)", "repaint()", "setCancelLabel(java.lang.String)", "setFont(java.awt.Font)", "stripSuffix(java.lang.String,java.lang.String)", "textValueChanged(java.awt.event.TextEvent)", "windowActivated(java.awt.event.WindowEvent)", "windowClosed(java.awt.event.WindowEvent)", "windowClosing(java.awt.event.WindowEvent)", "windowDeactivated(java.awt.event.WindowEvent)", "windowDeiconified(java.awt.event.WindowEvent)", "windowIconified(java.awt.event.WindowEvent)", "windowOpened(java.awt.event.WindowEvent)", "addButton(java.lang.String,java.awt.event.ActionListener)"}) {
            methods.put(string, null);
        }
        for (CtMethod ctMethod : original.getMethods()) {
            if (original != ctMethod.getDeclaringClass()) continue;
            name = ctMethod.getLongName();
            Assert.assertTrue((boolean)name.startsWith("ij.gui.GenericDialog."));
            name = name.substring("ij.gui.GenericDialog".length() + 1);
            if (name.startsWith("access$")) continue;
            Assert.assertTrue((String)(name + " is not overridden"), (boolean)methods.containsKey(name));
        }
    }

    @Test
    public void autogenerateDummyMethods() throws Exception {
        LegacyInjector injector = new LegacyInjector();
        injector.before.add(new LegacyInjector.Callback(){

            public void call(CodeHacker hacker) {
                hacker.insertNewMethod("ij.gui.GenericDialog", "public java.lang.String intentionalBreakage(java.awt.event.KeyEvent event)", "throw new RuntimeException(\"This must be overridden\");");
            }
        });
        LegacyEnvironment ij1 = new LegacyEnvironment(null, true, injector);
        Thread.currentThread().setName("Run$_Aaaargh!");
        ij1.setMacroOptions("Aaaaaaaaargh!!!");
        Object dialog = TestUtils.construct(ij1.getClassLoader(), "ij.gui.GenericDialog", "Hello");
        Object nextString = TestUtils.invoke(dialog, "intentionalBreakage", new Object[]{null});
        Assert.assertNull(nextString);
    }

    @Test
    public void testMenuStructure() throws Exception {
        Assume.assumeTrue((!GraphicsEnvironment.isHeadless() ? 1 : 0) != 0);
        File jarFile = new File(this.tmpDir, "Set_Property.jar");
        TestUtils.makeJar(jarFile, Set_Property.class.getName());
        LegacyEnvironment headlessIJ1 = TestUtils.getTestEnvironment();
        headlessIJ1.addPluginClasspath(new File[]{jarFile});
        headlessIJ1.runMacro("", "");
        LinkedHashMap<String, String> menuItems = new LinkedHashMap<String, String>(headlessIJ1.getMenuStructure());
        Assert.assertTrue((String)"does not have 'Set Property'", (boolean)menuItems.containsKey("Plugins>Set Property"));
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(false, false);
        ij1.addPluginClasspath(new File[]{jarFile});
        Frame ij1Frame = (Frame)TestUtils.construct(ij1.getClassLoader(), "ij.ImageJ", 2);
        MenuBar menuBar = ij1Frame.getMenuBar();
        Hashtable commands = (Hashtable)TestUtils.invokeStatic(ij1.getClassLoader(), "ij.Menus", "getCommands", new Object[0]);
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            Menu menu = menuBar.getMenu(i);
            this.assertMenuItems(menuItems, commands, menu.getLabel() + ">", menu);
        }
        Assert.assertTrue((String)("Left-over menu items: " + menuItems.keySet()), (menuItems.size() == 0 ? 1 : 0) != 0);
    }

    private void assertMenuItems(Map<String, String> menuItems, Hashtable<String, String> commands, String prefix, Menu menu) {
        int separatorCounter = 0;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            MenuItem item = menu.getItem(i);
            String label = item.getLabel();
            String menuPath = prefix + label;
            if (menuPath.startsWith("Help>Examples>")) continue;
            if (item instanceof Menu) {
                this.assertMenuItems(menuItems, commands, menuPath + ">", (Menu)item);
                continue;
            }
            if ("-".equals(label)) {
                String menuPath2 = menuPath + ++separatorCounter;
                Assert.assertTrue((String)("Not found: " + menuPath2), (boolean)menuItems.containsKey(menuPath2));
                menuItems.remove(menuPath2);
                continue;
            }
            if (menuPath.startsWith("File>Open Recent>")) continue;
            Assert.assertTrue((String)("Not found: " + menuPath), (boolean)menuItems.containsKey(menuPath));
            Assert.assertEquals((String)("Command for menu path: " + menuPath), (Object)commands.get(label), (Object)menuItems.get(menuPath));
            menuItems.remove(menuPath);
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

