/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.imagej.patcher.CodeHacker;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import org.junit.Assert;
import org.junit.Test;

public class HelpfulExceptionTracesIT {
    @Test
    public void testHelpfulTrace() throws Exception {
        LegacyInjector injector = new LegacyInjector();
        injector.after.add(new LegacyInjector.Callback(){

            public void call(CodeHacker hacker) {
                hacker.addToClassInitializer("ij.IJ", "this does not compile");
            }
        });
        LegacyEnvironment ij1 = new LegacyEnvironment(null, true, injector);
        try {
            ij1.setMacroOptions("");
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            e.printStackTrace(out);
            out.close();
            Assert.assertTrue((boolean)writer.toString().contains("this does not compile"));
        }
    }

    @Test
    public void testInvocationTargetException() throws Exception {
        LegacyInjector injector = new LegacyInjector();
        injector.after.add(new LegacyInjector.Callback(){

            public void call(CodeHacker hacker) {
                hacker.insertAtTopOfMethod("ij.IJ", "public static void run(java.lang.String command, java.lang.String options)", "throw new NullPointerException(\"must fail!\");");
            }
        });
        LegacyEnvironment ij1 = new LegacyEnvironment(null, true, injector);
        try {
            ij1.run("", "");
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            e.printStackTrace(out);
            out.close();
            Assert.assertTrue((boolean)writer.toString().contains("must fail!"));
        }
    }
}

