/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.Macro;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.imagej.patcher.Headless_Example_Plugin;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Plugin_With_DialogListener;
import net.imagej.patcher.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class HeadlessEnvironmentTest {
    private String threadName;
    private ClassLoader threadLoader;

    @Before
    public void saveThreadName() {
        this.threadName = Thread.currentThread().getName();
        this.threadLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void restoreThreadName() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        if (this.threadLoader != null) {
            Thread.currentThread().setContextClassLoader(this.threadLoader);
        }
    }

    @Test
    public void testMacro() throws Exception {
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
        String propertyName = "headless.test.property" + Math.random();
        String propertyValue = "Hello, world!";
        System.setProperty(propertyName, "(unset)");
        Assert.assertFalse((boolean)"Hello, world!".equals(System.getProperty(propertyName)));
        ij1.runMacro("call(\"java.lang.System.setProperty\", \"" + propertyName + "\", getArgument());", "Hello, world!");
        Assert.assertEquals((Object)"Hello, world!", (Object)System.getProperty(propertyName));
    }

    @Test
    public void testEncapsulation() throws Exception {
        Thread.currentThread().setName("Run$_" + this.threadName);
        Macro.setOptions((String)"(unset)");
        Assert.assertEquals((Object)"(unset) ", (Object)Macro.getOptions());
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment();
        ij1.runMacro("call(\"ij.Macro.setOptions\", \"Hello, world!\");", null);
        Assert.assertEquals((Object)"(unset) ", (Object)Macro.getOptions());
        Method getOptions = ij1.getClassLoader().loadClass("ij.Macro").getMethod("getOptions", new Class[0]);
        Assert.assertEquals((Object)"Hello, world! ", (Object)getOptions.invoke(null, new Object[0]));
    }

    @Test
    public void testHeadless() throws Exception {
        Assert.assertTrue((boolean)HeadlessEnvironmentTest.runExampleDialogPlugin(true));
    }

    @Test
    public void testPatchIsRequired() throws Exception {
        Assume.assumeTrue((boolean)GraphicsEnvironment.isHeadless());
        Assert.assertFalse((boolean)HeadlessEnvironmentTest.runExampleDialogPlugin(false));
    }

    @Test
    public void testPluginWithDialogListener() throws Exception {
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(true, false);
        ij1.addPluginClasspath(HeadlessEnvironmentTest.class.getClassLoader());
        ij1.setMacroOptions("please=123");
        String value = ij1.runPlugIn(Plugin_With_DialogListener.class.getName(), "").toString();
        Assert.assertEquals((Object)"value: 123\nevent: null\nfinal value: 123\n", (Object)value);
    }

    @Test
    public void saveDialog() throws Exception {
        Assert.assertTrue((boolean)HeadlessEnvironmentTest.runExamplePlugin(true, "SaveDialog", "file=README.txt", "true"));
    }

    @Test
    public void booleanTest() throws Exception {
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key", "This is the key! true");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key ", "This is the key! true");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key=1", "This is the key! false");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the key!] key1", "This is the key! false");
        HeadlessEnvironmentTest.runExamplePlugin(true, "BooleanParameter", "key=[This is the next key!]", "This is the next key! false");
    }

    @Test
    public void testIJInit() throws Exception {
        LegacyEnvironment ij1 = new LegacyEnvironment(null, true);
        ClassLoader loader = ij1.getClassLoader();
        Method runPlugIn = loader.loadClass("ij.IJ").getMethod("runPlugIn", String.class, String.class);
        runPlugIn.invoke(null, "ij.IJ.init", "");
        Method getCommands = loader.loadClass("ij.Menus").getMethod("getCommands", new Class[0]);
        Assert.assertNotNull((Object)getCommands.invoke(null, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonOverriddenMethods() throws Exception {
        Object result;
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(true, false);
        ClassLoader loader = ij1.getClassLoader();
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        try {
            ij1.setMacroOptions("Booh!");
            if (!threadName.startsWith("Run$_")) {
                thread.setName("Run$_" + threadName);
            }
            Object dialog = TestUtils.construct(loader, "ij.gui.GenericDialog", "Test parseDouble");
            result = TestUtils.invoke(dialog, "parseDouble", "2.182859");
        }
        finally {
            thread.setName(threadName);
        }
        Assert.assertNotNull(result);
        Assert.assertTrue((String)("Not a Double: " + result.getClass()), (boolean)(result instanceof Double));
        Assert.assertEquals((double)2.182859, (double)((Double)result), (double)1.0E-6);
    }

    private static boolean runExampleDialogPlugin(boolean patchHeadless) throws Exception {
        return HeadlessEnvironmentTest.runExamplePlugin(patchHeadless, "the argument", "prefix=[*** ]", "*** the argument");
    }

    private static boolean runExamplePlugin(boolean patchHeadless, String arg, String macroOptions, String expectedValue) throws Exception {
        LegacyEnvironment ij1 = TestUtils.getTestEnvironment(patchHeadless, false);
        ij1.addPluginClasspath(HeadlessEnvironmentTest.class.getClassLoader());
        try {
            ij1.setMacroOptions(macroOptions);
            String value = ij1.runPlugIn(Headless_Example_Plugin.class.getName(), arg).toString();
            Assert.assertEquals((Object)expectedValue, (Object)value);
            return true;
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            while ((t instanceof InvocationTargetException || t instanceof RuntimeException) && t.getCause() != null) {
                t = t.getCause();
            }
            if (!(t instanceof HeadlessException)) {
                t.printStackTrace();
            }
            return false;
        }
    }

    static {
        try {
            LegacyInjector.preinit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Got exception (see error log)");
        }
    }
}

