/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import org.scijava.util.ProcessUtils;

public class ChangeIcon {
    private static void usage() {
        System.err.println("Usage: ChangeIcon (ImageJ-win32.exe|ImageJ-win64.exe) ImageJ.ico");
        System.exit(1);
    }

    public static void main(String ... args) {
        if (args.length != 2) {
            ChangeIcon.usage();
        }
        File executable = new File(args[0]);
        for (File file : new File[]{executable, new File(args[1])}) {
            if (file.exists()) continue;
            System.err.println("Cannot find '" + file + "'; not changing icon");
            return;
        }
        try {
            File debug = new File(executable.getParentFile(), "debug.exe");
            if (!debug.exists()) {
                debug.createNewFile();
            }
            FileInputStream in = new FileInputStream(executable);
            FileOutputStream out = new FileOutputStream(debug);
            FileChannel source = in.getChannel();
            FileChannel target = out.getChannel();
            target.transferFrom(source, 0L, source.size());
            source.close();
            target.close();
            in.close();
            out.close();
            ProcessUtils.exec(null, (PrintStream)System.err, (PrintStream)System.out, (String[])new String[]{debug.getPath(), "--set-icon", executable.getPath(), args[1]});
            System.err.println("Changed icon of '" + executable + "' to '" + args[1] + "'");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

